FROM ubuntu:22.04

ARG DEBIAN_FRONTEND=noninteractive

RUN apt-get update
RUN apt-get install -yq \
    wget \
    jq \
    gcc \
    vim \
    expect \
    inotify-tools \
    uuid-runtime \
    python3 \
    python3-pip \
    python-is-python3 \
    qemu-system-x86

WORKDIR /workdir

# repro.sh tries to write to this file, make sure the env var is set
ENV GITHUB_OUTPUT="./gh_out"

ARG exploit_name
ARG exploit_environment
ARG kernelctf_release


COPY "./build/exploit-build/exploits/$exploit_name/exploit/$exploit_environment" ./exp

COPY ./assets/$kernelctf_release/bzImage ./bzImage

COPY ./assets/rootfs.img ./rootfs.img

COPY ./assets/repro.sh ./repro.sh

RUN mkdir init
COPY ./assets/init.sh ./init/init.sh

CMD ["./repro.sh", "0"]
