#!/bin/bash

set -ex

EXPLOIT=$1

if [[ -z "$EXPLOIT" ]]; then
  echo "Error: Exploit Type is required."
  usage
elif [[ "$EXPLOIT" != "modified" && "$EXPLOIT" != "original" ]]; then
  echo "Error: Exploit Type must be 'modified' or 'original'."
  exit 1
fi

for EXPLOIT_DIR in exploits/*; do
    METADATA_FILE="$EXPLOIT_DIR/metadata.json"

    echo "$METADATA_FILE"

    if [[ -f "$METADATA_FILE" ]]; then
        jq -r '.exploits[].environment' "$METADATA_FILE" | while read -r release_name; do
            echo "$release_name"
            pushd "$EXPLOIT_DIR/exploit/$release_name"
                make clean || true
                make prerequisites || true
                if [ "$EXPLOIT" = "original" ]; then
                    make exploit_orig
                else
                    make exploit
                fi
            popd
        done
    else
        echo "No metadata.json found in $CVE_FOLDER"
    fi
done

