#!/bin/bash

set -ex

EXPLOIT=$1

if [[ -z "$EXPLOIT" ]]; then
  echo "Error: Exploit Type is required."
  usage
elif [[ "$EXPLOIT" != "modified" && "$EXPLOIT" != "original" ]]; then
  echo "Error: Exploit Type must be 'modified' or 'original'."
  exit 1
fi

rm -r build/exploit-build || true
mkdir -p build/exploit-build

# BUILD EXPLOITS
docker build \
    --build-arg exploit_type=$EXPLOIT \
    -f ./docker/exploit-build.dockerfile \
    -t ret2entry-exploits .
docker run ret2entry-exploits cat /eval-cve/exploits.tar.gz > ./build/exploit-build/exploits.tar.gz

pushd build/exploit-build
    tar -xzf ./exploits.tar.gz
popd
