# CVE Evaluation of 'Swapgs Stack Pivoting' on kernelCTF Vulns

This directory contains kernelCTF exploits ported to use the 'Swapgs Stack Pivoting' technique proposed in our paper.

Note: in many locations in this repo the attack is referred to as 'ret2entry' (abbreviated r2e), due to its targeting of kernel entrypoints.

## Running

To run an evaluation of the stability of the exploits on your system use the `./run-eval.sh` script.
The script takes an argument 'Exploit Type' which can be either 'modified' or 'original' to choose which exploits to evaulate, either our modified exploits or the original ones.
The results of the script will be written out to a file in the current directory.


## Stability Results

Stability (success rates) of the original exploit techniques and our exploit technique, not including instability side-channels.

Measurement was done on an `AMD Ryzen Threadripper 7960X 24-Cores` CPU, it is likely that results will vary on different processors (these exploits were tuned for the 7960X with PML5 enabled). Stability may also vary from noise on the host system.


| Vuln                   | Orig Stability | Modified Stability |
| ---------------------- | -------------- | ------------------ |
| CVE-2023-4623_lts_cos  | 50/50          | 50/50              |
| CVE-2023-6111_lts      | 50/50          | 50/50              |
| CVE-2023-6817_lts_cos  | 49/50          | 49/50              |
| CVE-2024-1085_lts      | 50/50          | 45/50              |
| CVE-2024-26925_lts_cos | 50/50          | 44/50              |

