#!/usr/bin/env python3
import subprocess
import json
import csv
import sys

def json_to_csv(json_string):
    data = json.loads(json_string)

    with open('output.csv', 'w', newline='') as csvfile:
        fieldnames = ['type', 'address', 'instruction']
        writer = csv.DictWriter(csvfile, fieldnames=fieldnames)

        writer.writeheader()
        for key, values in data.items():
            for value in values:
                writer.writerow({'type': key, 'address': hex(value[0]), 'instruction': value[1]})
    print("results written to output.csv")


def main(argc, argv):
    if argc < 3:
        print("usage: run.py <path> <arch>")
        exit(1)

    json_string = subprocess.check_output(["/root/.cargo/bin/cargo", "run", "--release", "--", "--path", argv[1], argv[2]])
    json_to_csv(json_string)

if __name__ == "__main__":
    main(len(sys.argv), sys.argv)

