# SysGadget

A tool for identifying potential System Register Hijacking gadgets.

## Usage

```
./run.py <vmlinux>
```

## Notes on False Positives and False Negatives

The simplest way to avoid False Positives and False Negatives is to use a memory dump of the kernel run under the exact configuration expected to be used by the victim system.
This is because the kernel does a lot of patching that depend on the system it is being run on, it will replace some instructions with alternative instructions based on cpu features and security features.
For reproducibility we ran all of our experiments using a dump of the kernel text section obtained by specifying the "-cpu max" option to the QEMU system emulator.

This tool does supports only analysis of both memory dumps.

The following version of QEMU was used in the experiments:
```
QEMU emulator version 6.2.0 (Debian 1:6.2+dfsg-2ubuntu6.24)
Copyright (c) 2003-2021 Fabrice Bellard and the QEMU Project developers
```
