#!/bin/bash


ARCH=$1

usage() {
  echo "Usage: $0 <ARCH>"
  echo "  ARCH: Architecture to analyze dumps for ('x86' or 'arm')."
  exit 1
}

if [[ -z "$ARCH" ]]; then
  echo "Error: ARCH is required."
  usage
elif [[ "$ARCH" != "x86" && "$ARCH" != "arm" ]]; then
  echo "Error: ARCH must be 'x86' or 'arm'."
  exit 1
fi

DUMPS_DIR=$ARCH"_out/dumps"
RESULTS_DIR=$ARCH"_out/analysis_results"

# Create the results directory if it doesn't exist
mkdir -p "$RESULTS_DIR"

# Iterate over all files in the vmlinux directory
for dump in "$DUMPS_DIR"/*; do
  if [[ -f "$dump" ]]; then
    dump=$(realpath "$dump")

    pushd ./sysgadget

    python3 run.py $dump $ARCH

    popd

    # Check if output.csv was created
    if [[ -f "./sysgadget/output.csv" ]]; then
      base_name=$(basename "$dump")

      new_file_name="${base_name}.csv"

      mv "./sysgadget/output.csv" "$RESULTS_DIR/$new_file_name"
    else
      echo "Error: output.csv not found after processing $dump" >&2
    fi

  else
    echo "Skipping non-file entry: $dump"
  fi
done

echo "Analysis completed. Results saved in '$RESULTS_DIR'."
