from openpyxl import Workbook
import pandas as pd
import sys
import os

def csvs_to_excel(directory, output_file):
    with pd.ExcelWriter(output_file, engine='openpyxl') as writer:
        for file_name in os.listdir(directory):
            if file_name.endswith('.csv'):
                file_path = os.path.join(directory, file_name)

                df = pd.read_csv(file_path)

                sheet_name = os.path.splitext(file_name)[0]
                df.to_excel(writer, index=False, sheet_name=sheet_name)
    print(f"Spreadsheet saved to {output_file}")

if __name__ == "__main__":
    input_directory = sys.argv[1]
    output_path = sys.argv[2]

    csvs_to_excel(input_directory, output_path)
