#!/usr/bin/env python3

from openpyxl import Workbook
from natsort import natsorted
import pandas as pd
import sys
import os

def csvs_to_table(directory):
    inst_map = {
        "msr elr_el1": 0,
        "msr pan": 0,
        "msr sctlr_el1": 0,
        "msr spsr_el1": 0,
        "msr tcr_el1": 0,
        "msr ttbr0_el1": 0,
        "msr ttbr1_el1": 0,
        "msr vbar_el1": 0,
    }
    line = ""
    for k in inst_map.keys():
        line += f"\\rotatebox{{90}}{{\\textbf{{{k}}}}} & "
    line = line[:-2]
    line = line.replace("_", "\\_")
    print(f"\\textbf{{Kernel}} & {line} \\\\")

    results_map = {}

    for file_name in os.listdir(directory):
        if file_name.endswith('.csv'):
            inst_map = {
                "msr elr_el1": 0,
                "msr pan": 0,
                "msr sctlr_el1": 0,
                "msr spsr_el1": 0,
                "msr tcr_el1": 0,
                "msr ttbr0_el1": 0,
                "msr ttbr1_el1": 0,
                "msr vbar_el1": 0,
            }

            file_path = os.path.join(directory, file_name)

            df = pd.read_csv(file_path)
            sheet_name = os.path.splitext(file_name)[0] \
                .replace("kernel-core-", "") \
                .replace("linux-image-", "") \
                .replace("unsigned-", "") \
                .replace(".aarch64_dump", "") \
                .replace("~20.04.1_arm64_dump", "") \
                .replace("~22.04.1_arm64_dump", "") \
                .replace("~24.04.1_arm64_dump", "") \
                .replace("_", "\\_")

            for idx in range(len(df)):
                typ = df.loc[idx, 'type']
                valid = df.loc[idx, 'validity']

                if not valid:
                    continue

                if typ in inst_map.keys():
                    inst_map[typ] += 1
                else:
                    inst_map[typ] = 1

            results_map[sheet_name] = inst_map

    keys = natsorted(list(results_map.keys()))

    sums_map = {
        "msr elr_el1": 0,
        "msr pan": 0,
        "msr sctlr_el1": 0,
        "msr spsr_el1": 0,
        "msr tcr_el1": 0,
        "msr ttbr0_el1": 0,
        "msr ttbr1_el1": 0,
        "msr vbar_el1": 0,
    }

    for sheet_name in keys:
        line = ""
        for k, v in results_map[sheet_name].items():
            if k in sums_map.keys():
                sums_map[k] += v
                line += f"{v} & "
        line = line[:-2]
        print(f"{sheet_name} & {line} \\\\")

    line = "Average & "
    for k, v in sums_map.items():
        line += f"{round(v/len(keys))} & "
    line = line[:-2]
    print(f"{line} \\\\")

if __name__ == "__main__":
    input_directory = sys.argv[1]

    csvs_to_table(input_directory)
