#!/usr/bin/env python3

from IPython.display import display
from multiprocessing import Pool
from IPython import embed
import pandas as pd
import sys
import os

def analyze_dump(task):
    csv_path = task['csv_path']
    out_path = task['out_path']

    if os.path.exists(out_path):
        print("Already analyzed:", csv_path)
        return
    else:
        print("Analyzing:", csv_path)

    df = pd.read_csv(csv_path)

    res_validity = []
    res_asm = []
    for idx in range(len(df)):
        if df.loc[idx, 'validity'] == False:
            res_validity += [False]
            continue

        instr_type = df.loc[idx, 'type']
        instruction = df.loc[idx, 'instruction']
        instrs = df.loc[idx, 'asm'].split(';')

        if '12, x' in instruction:
            # temporarily work around the fuck up gadgets
            res_validity += [False]
            continue

        # sanity check that the value we just set wont be overwritten
        overwritten = False
        for instr in instrs[1:]:
            if instr_type in instr:
                overwritten = True

        # we assume we can't bypass PAC
        pac = False
        for instr in instrs[1:]:
            if 'autiasp' in instr:
                pac = True

        # exclude PAN enable
        invalid_pan = False
        if instruction == 'msr pan, #1':
            invalid_pan = True

        if (not overwritten) and (not invalid_pan) and (not pac):
            res_validity += [True]
        else:
            res_validity += [False]

        #print(res_validity[-1], overwritten, pac, instrs)

    df['validity'] = res_validity
    display(df)

    df.to_csv(out_path)

def main(argc, argv):
    csvs_path = argv[1]
    out_path = argv[2]

    tasks = []
    for csv_file in os.listdir(csvs_path):
        csv_path = csvs_path + '/' + csv_file
        new_csv_path = out_path + '/' + csv_file
        tasks += [{'csv_path': csv_path, 'out_path': new_csv_path}]
        #print("ANALYZING:", csv_path)
        #analyze_dump(csv_path, dump_path, new_csv_path)

    print(tasks)
    #analyze_dump(tasks[0])
    with Pool(1) as p:
        p.map(analyze_dump, tasks)

if __name__ == "__main__":
    main(len(sys.argv), sys.argv)
