#!/bin/bash

# Pull and extract all the kernel images to be analyzed

while true; do
    ./container-scripts/get-images.sh ./kernel_sources/kernels-x86.json x86
    # Sometimes we fail to get the dump, check if there are any dumps
    if ! find ./x86_out/dumps -type f -empty | grep -q .; then
        break  # break if no empty dumps
    fi
    find ./x86_out/dumps -type f -empty -delete
done

while true; do
    ./container-scripts/get-images.sh ./kernel_sources/kernels-arm.json arm

    # Sometimes we fail to get the dump, check if there are any dumps
    if ! find ./arm_out/dumps -type f -empty | grep -q .; then
        break  # break if no empty dumps
    fi
    find ./arm_out/dumps -type f -empty -delete
done

# x86-64 Analysis
echo Beginning x86-64 Analysis
./scripts/sysgadget.sh x86
mkdir ./x86_out/angrop_validated
python3 ./scripts/angrop_validate_x86.py ./x86_out/analysis_results ./x86_out/dumps ./x86_out/angrop_validated
mkdir ./x86_out/angrop_validated_post
python3 ./scripts/x86_pass.py ./x86_out/angrop_validated ./x86_out/dumps ./x86_out/angrop_validated_post

# aarch64 Analysis
echo Beginning aarch64 Analysis
./scripts/sysgadget.sh arm
mkdir ./arm_out/angrop_validated
python3 ./scripts/angrop_validate_arm.py ./arm_out/analysis_results ./arm_out/dumps ./arm_out/angrop_validated
mkdir ./arm_out/angrop_validated_post
python3 ./scripts/arm_pass.py ./arm_out/angrop_validated ./arm_out/angrop_validated_post

echo DONE!
