clear
close all
addpath('..\Codes')
f = figure;  
H=gca;
H.LineWidth=0.5;
hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 666 300];
%
subplot(1,2,1)
xlabel1 = 'r - centre distance [nm]';
xlim1 = [500 1500];
ylabel1 = 'U_{OB}(r) [K_BT]';
%
load('..\Data\DDA\U_ps500_OB.txt')
U1 = UniquePoint(U_ps500_OB);
x1=U1(:,1);
y1=U1(:,2);
xc =400:20:4000;
yc1 = interp1(x1*1.02,0.3*(y1+0.5),xc);
%
load(['..\Data\DDA\U_ps500_HWP_OB.txt'])
U2 = UniquePoint(U_ps500_HWP_OB);
x2=U2(:,1);
y2=U2(:,2);
yc2 = interp1(x2*1,0.3*y2,xc);
p1=plot(xc,yc1,'o','MarkerEdgeColor','#0072BD','MarkerFaceColor',[0 0 1],'MarkerSize',4);
hold on
p2=plot(xc,yc2,'s','MarkerEdgeColor','#D95319','MarkerFaceColor',[1 0 0],'MarkerSize',4);
%
load('..\Data\DDA\a_250_pol_pots.dat')
U=a_250_pol_pots;
U=U(U(:,1)<4000,:);
p3=plot(U(:,1)+500,0.3*1.1*U(:,2)*10^32,'Color','#4DBEEE','LineWidth',1);
p4=plot(U(:,1)+500,0.3*0.7*U(:,3)*10^32-0.3,'Color','#A2142F','LineWidth',1);
%
Y1=0.3*2*cos(xc/800*2*pi+1.3)./(xc/500-0.8);
p5=plot(xc,Y1,'--','Color','#0072BD','LineWidth',1);
Y1=0.3*3*cos(xc/800*2*pi+2.8)./(xc/500-0.8);
p6=plot(xc,Y1,'--','Color','#D95319','LineWidth',1);
legend boxoff 
% ylim(ylim1)
xlim(xlim1)
box on
title('SLM')
lgd = {' ',' ',' ',' ','||','\perp'};
legend(lgd,'Location','best','NumColumns',3,'FontSize',8)
xlabel(xlabel1)
ylabel(ylabel1)
set(gca,'FontSize', 8)

%%

subplot(1,2,2)
load('..\Data\OB Experimental data\para_LP13_500mV_rawOB.mat')
UOB=UOB(UOB(:,1)>540,:);
plot(UOB(:,1),UOB(:,2)-4.3,'o','MarkerEdgeColor','#0072BD','Markerfacecolor',[0 0 1],'MarkerSize',4)
hold on
load('..\Data\OB Experimental data\perp_LP12_300mV_rawOB.mat')
UOB=UOB(UOB(:,1)>540,:);
plot(UOB(:,1),UOB(:,2),'s','MarkerEdgeColor','#D95319','Markerfacecolor',[1 0 0],'MarkerSize',4)

resx = table2array(readtable('..\Data\DDA\potx_a_260_full.dat'));
plot((resx(:,1)+520),resx(:,2)*10^7*1.5-2*1.5,'-','color','#4DBEEE')

resy = table2array(readtable('..\Data\DDA\poty_a_260_full.dat'));
plot((resy(:,1)+520),resy(:,2)*10^7/2+8.5/2,'-','color','#A2142F')

r=480:1:2000;
A=14;
lambda=1600;
phi=2.4;
D=500;
Upara=A*cos(2*pi*r/lambda+phi)./(r/D-0.8).*exp(-(r./500).^2);
plot(r,Upara,'--','color','#0072BD')

A=6;
phi=3.14;
D=500;
Uperp=A*cos(2*pi*r/lambda+phi)./(r/D-0.8).*exp(-(r./500).^2);
plot(r,Uperp,'--','color','#D95319')


ylim([-2.5 5])
xlim(xlim1)


box on
title('AOM')
lgd2 = {' ',' ',' ',' ','||','\perp'};
legend(lgd2,'Location','northeast','NumColumns',3,'FontSize',8)
legend boxoff  
xlabel(xlabel1)
ylabel(ylabel1)
set(gca,'FontSize', 8)
%% save to PDF
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'OB','-dpdf','-r0')