%% 
clear
close all
addpath('..\Codes')
T=35+273.15;
load('..\Data\Depletion\1p_500_2D.mat')
pos=ALLres(:,1)*74;
pos=pos-mean(pos);
%
step=20;
bin=-1000:step:1000;
[a1,b]=hist(pos,bin);
a1=a1/sum(a1)/step;
bin = b;
U1 = -log(a1);
x=bin(~isinf(U1));
y=U1(~isinf(U1));

x=x(abs(y)<10);
y=y(abs(y)<10);
fun = fittype(@(k,mu,C,x) 0.5*k*(x-mu).^2+C);
guess=[2*10^-5,0,0];
up=[2*10^-4,100,10];
low=[2*10^-6,-100,-10];
opt = fitoptions('method','NonlinearLeastSquares','Upper',up,'Lower',low,'MaxIter',1e10,'TolFun',1e-14,'TolX', 1e-14);
set(opt,'Startpoint', guess); 
[fit1] = fit(x',y', fun, opt);
k=fit1.k;
mu=fit1.mu;
C=fit1.C;
yc=0.5*k*(bin-mu).^2+C;
%%
f = figure;  
f.Position = [1 1 666 450]; 
%
subplot(2,3,1)
H1=gca;
H1.LineWidth=0.5;
[Pr,b]=hist(pos,-400:50:400);
Pr=Pr/sum(Pr)/50;
p11=bar(b,Pr,'FaceColor','#EDB120','EdgeColor','#808080','LineWidth',1);
xlim([-400,400])
% ylim([0,0.005])
% title('\rm d = 500 nm','Units', 'normalized', 'Position', [0.5, 0.0, 0]);
% legend([p1 p2 p3 p4 p5 ],{'Exp,','Fit,','OT','OB','PP'},'Location','best','NumColumns',2);
% legend boxoff 
xlabel('x - centre position [nm]')
ylabel('P(x)')
set(gca,'FontSize', 8)
text(-0.25,1,'a)','Units','normalized','FontSize',12)
%
subplot(2,3,2)
H2=gca;
H2.LineWidth=0.5;
p21=plot(bin,U1,'o','MarkerEdgeColor','#EDB120','MarkerFaceColor','#808080','MarkerSize',4);
hold on
p22=plot(bin,yc,'-','Color','#0072BD','LineWidth',1);
xlim([-400,400])
ylim([5,15])
% title('\rm d = 500 nm','Units', 'normalized', 'Position', [0.5, 0.0, 0]);
legend([p21 p22],{'Exp','OT = $\frac{1}{2} k_{1p} x^2$ '},'Interpreter','latex','Location','best');
legend boxoff 
xlabel('x - centre position [nm]')
ylabel('U(x)')
set(gca,'FontSize', 8)
text(-0.25,1,'b)','Units','normalized','FontSize',12)
%%
load('..\Data\Depletion\2p_500_T40_F108_2mM_2D_U2.mat')
x=U2(:,1);
Raw=U2(:,2);
Fit=U2(:,3);
PP=U2(:,4);
OT=U2(:,5);
OB=U2(:,6);
id1=1:42;
id2=43:3:length(x);
id=[id1,id2];
%
subplot(2,3,3)
H3=gca;
H3.LineWidth=0.5;
Pr2=exp(-Raw);
p31=area(x,Pr2,'FaceColor','#808080','EdgeColor','k','LineWidth',1);
set(H3,'YScale','log')
xlim([400,1100])
% ylim([0,0.005])
% title('\rm d = 500 nm','Units', 'normalized', 'Position', [0.5, 0.0, 0]);
% legend([p1 p2 p3 p4 p5 ],{'Exp,','Fit,','OT','OB','PP'},'Location','best','NumColumns',2);
% legend boxoff 
xlabel('r - centre distance [nm]')
ylabel('P(x)')
set(gca,'FontSize', 8)
text(-0.25,1,'c)','Units','normalized','FontSize',12)
%
subplot(2,3,4)
H4=gca;
H4.LineWidth=0.5;
p41=plot(x(id),Raw(id),'o','MarkerEdgeColor','k','MarkerFaceColor','#808080','MarkerSize',4);
hold on
p42=plot(x(id),OT(id)-10,'-','Color','#0072BD','LineWidth',1);
p43=plot(x(id),OB(id)+PP(id)-15,'o','MarkerEdgeColor','#D95319','MarkerFaceColor','#808080','MarkerSize',4);
xlim([400,1100])
ylim([-27,15])
% title('\rm d = 500 nm','Units', 'normalized', 'Position', [0.5, 0.0, 0]);
legend([p41 p42 p43],{'Exp','OT = $\frac{1}{2} k_{2p} r^2$ ','OB + PP'},'Interpreter','latex','Location','best');
legend boxoff 
xlabel('r - centre distance [nm]')
ylabel('U(r)')
set(gca,'FontSize', 8)
text(-0.25,1,'d)','Units','normalized','FontSize',12)
%
subplot(2,3,5)
H5=gca;
H5.LineWidth=0.5;
p51=plot(x(id),OB(id)+PP(id)+5,'o','MarkerEdgeColor','#D95319','MarkerFaceColor','#808080','MarkerSize',4);
hold on
p52=plot(x(id),OB(id)+5,'-','Color','#7E2F8E','LineWidth',1);
p53=plot(x(id),PP(id),'s','MarkerEdgeColor','#77AC30','MarkerFaceColor','#808080','MarkerSize',4);
xlim([400,1100])
ylim([-7,20])
% title('\rm d = 500 nm','Units', 'normalized', 'Position', [0.5, 0.0, 0]);
legend([p51 p52 p53],{'OB + PP','OB(fit)','PP'},'Location','best');
legend boxoff 
xlabel('r - centre distance [nm]')
ylabel('U(r)')
set(gca,'FontSize', 8)
text(-0.25,1,'e)','Units','normalized','FontSize',12)
%
subplot(2,3,6)
H6=gca;
H6.LineWidth=0.5;
p61=plot(x(id),Raw(id)+5,'ok','MarkerEdgeColor','k','MarkerFaceColor','#808080','MarkerSize',4,'LineWidth',1);
hold on
p62=plot(x,Fit+5,'-','Color','#D95319','LineWidth',1);
% p3=plot(x,OT-4,'-.','Color','#0072BD','LineWidth',1);
% p4=plot(x,OB,'--','Color','#7E2F8E','LineWidth',1);
p65=plot(x(id),PP(id),'s','MarkerEdgeColor','#77AC30','MarkerFaceColor','#808080','MarkerSize',4,'LineWidth',1);
xlim([400,1100])
ylim([-4,18])
% title('\rm d = 500 nm','Units', 'normalized', 'Position', [0.5, 0.0, 0]);
legend([p61 p62 p65 ],{'Exp','Fit','PP',},'Location','East','NumColumns',1);
legend boxoff 
xlabel('r - centre distance [nm]')
ylabel('U(r) [k_BT]')
set(gca,'FontSize', 8)
text(-0.25,1,'f)','Units','normalized','FontSize',12)

%%
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'PotentialRaw','-dpdf','-r0')