clear
close all
addpath('..\Codes')
%
staticE=3;
dynamicE=5;
a=500;
sigma_z=30;
[UD1] = UHarsphere_exp(a,dynamicE,staticE,sigma_z);
f = figure;  
H=gca;
H.LineWidth=0.5;

hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 333 500];
%
subplot(2,1,1)
UD1(isinf(UD1(:,3)),3)=100;
plot(UD1(:,1),UD1(:,3),'k','LineWidth',1)
hold on
plot(   UD1(:,1),UD1(:,13),'Color','#1F77B4','LineWidth',1)
plot(  UD1(:,1),-log(UD1(:,9))-UD1(:,12),'Color','#FF7F0E','LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color','#2CA02C','LineWidth',1)
legend('Hard-sphere','+ Z motion','+ Dynamic error','+ Static error')
legend boxoff 
box on
% grid on
% ---fonts
set(gca,'FontSize', 8)
ylim([-1,8])
xlim([480,560])
xlabel('r [nm]')
ylabel('U [kT]')
% title('Error')
% grid on

%%
[Umodel,n] = UDepletion_exp(1,50,a,10,dynamicE,staticE,sigma_z);
subplot(2,1,2)
Umodel(isinf(Umodel(:,3)),3)=100;
plot(Umodel(:,1),Umodel(:,3),'k','LineWidth',1)
hold on
plot(   Umodel(:,1),Umodel(:,13),'Color','#1F77B4','LineWidth',1)
plot(  Umodel(:,1),-log(Umodel(:,9))-Umodel(:,12),'Color','#FF7F0E','LineWidth',1)
plot(Umodel(:,1),Umodel(:,2),'Color','#2CA02C','LineWidth',1)
legend('Depletion','+ Z motion','+ Dynamic error','+ Static error')
legend boxoff 
box on
% grid on
% ---fonts
set(gca,'FontSize', 8)
ylim([-5,8])
xlim([480,560])
xlabel('r [nm]')
ylabel('U [kT]')
% title('Error')
%% save to PDF
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'potentialerrors','-dpdf','-r0')