function [Pradial]=map2radial(X,Y,S)
% get a radial profile from a 2D map;
%X Y are the coordinates of the map S
dis=sqrt(X.^2+Y.^2);
M=max(dis(:));
step=0.5;
r=1:step:M;
r=[0 r];
is00=0;
for id = 1 : length(r)
    rtemp=dis(abs(dis-r(id))<step/2);
    Stemp=S(abs(dis-r(id))<step/2);
    if ~isempty(rtemp)
        Pradial(id,1)=mean(rtemp);
        Pradial(id,2)=mean(Stemp);
    elseif id == 1
        Pradial(id,1)=0;
        Pradial(id,2)=0;
        is00=1;
    else
        Pradial(id,1)=r(id);
        Pradial(id,2)=Pradial(id-1,2);
    end
end
if is00
    Pradial(1,1)=0;
    Pradial(1,2)=Pradial(2,2);
end