function [UD] = UHarsphere_exp(a,dynamicE,staticE,sigma)
%all size in unit of nm
%set up things
step=1;
r=(a-100):step:(a+1000);
% guess=[4.7*10^-5,8.6,800,1.11,800,0];
k=5*10^-5;
AOB=9;
omega=800;
phi=1.1;
Dfit=420;
OT_sigma=800;
UOT=U_OT_OB_B(r,k,AOB,omega,phi,0,Dfit,OT_sigma);
LB=0.71;
ka=1/4.3;
Z=3750; %charge
lambda=1/LB; %kT
Ah=1*10^-21/(1.38*10^-23*300);
U=Z^2*lambda*exp(-ka*(r))./(r)*(exp(ka*a/2)/(1+ka*a/2))^2-0*Ah*a./(12*(r-a)); %VDW is longer range and being removed while fitting pot
% U(isinf(U))=0;
U(r<=a)=inf;
U(r>a)=0; %perfect hard sphere
UD(:,1)=r;
UD(:,3)=U;
if nargin < 2
    dynamicE=0;
end
if nargin < 3
    staticE=0;
end
if nargin <4
    sigma = 0;
end
% z motion correction
if sigma > 0
    [U]=GPT_ZCorrection(r,U,sigma);
end
UD(:,13)=U;
% dynamic error
    UD(:,4)=U+UOT;%total U
    UD(:,5)=exp(-UD(:,4)); %PDF
    PDFU=UD(:,5);
    if dynamicE  > 0
        % defind grid for relative motion
        rs=-5*dynamicE:step:5*dynamicE;
        % Define Gaussian fluctuation probability distribution P_D(a)
        P_D = exp(-rs.^2 / (2 * dynamicE^2));
        P_D = P_D / trapz(rs, P_D); % Normalize P_D
        
        % Compute P_D(a) modified by the Boltzmann factor
        [RR, AA] = meshgrid(r, rs);
        PDFUinterp = @(x) interp1(r, PDFU, x, 'linear', 'extrap'); % Interpolated PDFU
        P_D_mod = PDFUinterp(RR - AA) .* exp(-AA.^2 / (2 * dynamicE^2));
        P_D_mod = P_D_mod ./ trapz(rs, P_D_mod, 1); % Normalize along a
        
        % Compute observed probability distribution P_dyn(r_dyn) using convolution
        P_dyn = conv2(PDFU, P_D_mod, 'same') * step; % Discrete convolution with step size correction

        % Compute r_dyn (camera recorded position)
        r_dyn = trapz(rs, (RR - AA) .* P_D_mod, 1) ./ trapz(rs, P_D_mod, 1);
        
        %save to UD
        UD(:,11)=r_dyn;
        UD(:,7)=P_dyn;
        P_dyn_interp=interp1(UD(UD(:,11)>0,11),UD(UD(:,11)>0,7),UD(:,1)); 
        P_dyn_interp(isnan(P_dyn_interp))=0;
        UD(:,9)=P_dyn_interp;
    else
        UD(:,9) = UD(:,5);
    end
    % static error
    if staticE > 0
    pG= 1/(staticE*sqrt(2*pi))*exp(-(r-mean(r)).^2/(2*staticE^2))*step;
    pG=pG/sum(pG);
    UD(:,10)=conv(UD(:,9),pG,'same');
    else
    UD(:,10)=UD(:,9);
    end
    % convert back to potential
    UD(:,2)=-log(UD(:,10))-UOT';
    UD(:,12)=UOT';
    UD(isinf(UD(:,3)),3)=100;

end