function [UD] = UDoubleLayer_exp(a,LDebye,Z,dynamicE,staticE,sigma)
%all size in unit of nm
%d is tracking precision e.g. 1.5 nm
step=1;
r=(a-100):step:(a+1000);
% guess=[4.7*10^-5,8.6,800,1.11,800,0];
k=5*10^-5;
AOB=9;
omega=800;
phi=1.1;
Dfit=420;
OT_sigma=800;
UOT=U_OT_OB_B(r,k,AOB,omega,phi,0,Dfit,OT_sigma);
LB=0.71;
% ka=1/4.3;
% Z=3750; %charge
ka=1/LDebye;
lambda=1/LB; %kT
Ah=1*10^-21/(1.38*10^-23*300);
U=Z^2*lambda*exp(-ka*(r))./(r)*(exp(ka*a/2)/(1+ka*a/2))^2-0*Ah*a./(12*(r-a)); %VDW is longer range and being removed while fitting pot
% U(isinf(U))=0;
U(r<=a)=inf;
% U(r>a)=0; %perfect hard sphere
UD(:,1)=r;
%
UD(:,3)=U;
if nargin <6
    sigma = 0;
end
if sigma > 0
    [U]=GPT_ZCorrection(r,U,sigma);
end
%
UD(:,13)=U;
%
if nargin < 4
    dynamicE=0;
end
if nargin < 5
    staticE=0;
end

%%  
    UD(:,4)=U+UOT;
    UD(:,5)=exp(-UD(:,4));
%     UD(:,5)=UD(:,5)/sum(UD(:,5))/step;
    if dynamicE  > 0
        %--unifrom
%         pU=r*0;
%         L=floor(dynamicE/step);
%         pU(floor(length(r)/2)-L:floor(length(r)/2)+L)=1;
%         pU=pU/sum(pU);
        %---Gaussian
        pU= 1/(dynamicE*sqrt(2*pi))*exp(-(r-mean(r)).^2/(2*dynamicE^2))*step;
        pU=pU/sum(pU);
        %--------
%         UD5=(UD(:,5)>0)/sum(UD(:,5)>0);
        UD5=UD(:,5);
        UD(:,6)=UD5.*UD(:,1);
        UD7=conv(UD5,pU,'same');
        UD(:,7)=conv(UD(:,5),pU,'same');
        UD(:,8)=conv(UD(:,6),pU,'same');
        UD(:,11)=UD(:,8)./UD7;
        %interpolate
        UD(isnan(UD(:,11)),11)=0;
        UD(isinf(UD(:,11)),11)=0;
        UD(:,9)=interp1(UD(UD(:,11)>0,11),UD(UD(:,11)>0,7),UD(:,1));
        UD(isnan(UD(:,9)),9)=0;
    else
        UD(:,9) = UD(:,5);
    end
    %
%     if nargin <5
%     sigma = 0;
%     end
%     if sigma > 0
%         [Uobs]=GPT_ZCorrection(UD(:,1),UD(:,9),sigma);
%         UD(:,13)=UD(:,9);
%         UD(:,9)=Uobs;
%     end
    %
    if staticE > 0
    pG= 1/(staticE*sqrt(2*pi))*exp(-(r-mean(r)).^2/(2*staticE^2))*step;
    pG=pG/sum(pG);
    UD(:,10)=conv(UD(:,9),pG,'same');
    else
    UD(:,10)=UD(:,9);
    end
    UD(:,2)=-log(UD(:,10))-UOT';
%     offset=mean(UD(abs(UD(:,1)-300)<100,2));
%     UD(:,2)=UD(:,2)-offset;
    UD(:,12)=UOT';
end