function [ER,z,E,penalty] = ThreeErrors_fitCore(x,y,p,dynamicE,staticE,sigma,lambda,ifRaw,method)
% method = 1, Totoal Variation regularization
% method = 2, default - L2 Smoothness regularization
% method = 3, adaptive L2 Smoothness regularization
if nargin < 9
    method =2;
end
%put some margin, 3 points
step=x(2)-x(1);
xstart=[x(1)-step*3,x(1)-step*2,x(1)-step*1];
xend=[x(end)+step*1,x(end)+step*2,x(end)+step*3];
x1=[xstart x' xend]';
p1=interp1(x,p,x1,'makima','extrap');
%from guess p to z
if ifRaw
    [UD] = UThreeErrors_expRaw(x1,p1,dynamicE,staticE,sigma);
else
    [UD] = UThreeErrors_exp(x1,p1,dynamicE,staticE,sigma);
end
z=UD(4:end-3,2);
%compute residual
E=sum((z-y).^2);
%compute 2nd direvative of the guess
dx = step;         % Assume uniform spacing
d1p1 = diff(p1, 1) / dx;
d2p1 = diff(p1, 2) / dx^2;  % Second derivative using finite differences
d1p=d1p1(4:end-3);
d2p=d2p1(4:end-3);
%compute ER
if method == 1 
    E1=sum(abs(d1p));
    penalty=E1;
    ER=E+lambda*(E1);
elseif method == 2
    E2=sum(d2p.^2);
    penalty=E2;
    ER=E+lambda*(E2);
elseif method ==3
%-----sharp point at a known position (hard sphere)
%     weight=x*0+1;
%     weight(x<515)=1-(515-x(x<515))*0.2;
%     weight(x<505)=(505-x(x<505))*0.1;
%     weight(weight<0)=0;
%     weight(weight>1)=1;
%     w=weight(2:end-1);
%     E3=sum((weight.*d2p.^2);
%     penalty=E3;
%     ER=E+lambda*(E3);
%-----adaptive method
    alpha=1;
    E3=sum((1./(1+alpha*d2p.^2)).*d2p.^2);
    penalty=E3;
    ER=E+lambda*(E3);
end