#
# INTEGRATE THE FORCE TO GET THE POTENTIAL POTENTIAL AND PLOT IT
using DelimitedFiles
using PyCall
using StringEncodings
@pyimport scipy.integrate as sci
@pyimport scipy.interpolate as spi



#radius in nm
a=260

#loading data
datax=readdlm("a_260__f2_xdata") #SIMULATED DATA
data_setup=readdlm("a_260__xsetup") #SETUP DATA

#load the beam profile to ponderate
ros=LinRange(-2.25,2.25,41)
data_beam=readdlm("um_intensity_line500_parallel.csv",',')

#recentering the profile
center=(6.02+2.14)/2 #from joses data
data_beam[:,1]=data_beam[:,1].-center

#interpolating
interp_beam=spi.interp1d(data_beam[:,1],data_beam[:,2],kind="linear",fill_value="extrapolate")
weights=interp_beam(ros).-minimum(interp_beam(ros))

N=length(datax[2:end,1]) #length of the data
ds=datax[2:end,1] #distances

#interval of beams potition to be considered
interval=2:42

for i=1:length(interval)
    datax[2:end,interval[i]]=datax[2:end,interval[i]].*weights[i]
end

#summing the forces
datax=sum(datax[2:end,interval],dims=2) #sum the forces
datax=[ds datax] #concatenate the distances and the forces

#interpolating
spl = spi.CubicSpline(datax[:,1], datax[:,2])
pot_pos=LinRange(ds[1],ds[end],1000)
forcex=spl(pot_pos)

#integrating
potx=sci.cumulative_simpson(forcex,x=pot_pos,initial=0)

#save into file
writedlm("potx_a_"*string(a)*".dat",[pot_pos[1:end-1]./1e-9 potx[1:end-1] ])
