using Base
using LinearAlgebra
using DelimitedFiles
using CoupledElectricMagneticDipoles



#medium parameters
eps_h=1.33^2
#particles parameters
as=[260]*1e-9 #RADIUS
eps=1.59^2
#laser parameter
lambda=800*1e-9
knorm=2*pi/lambda
FWHM=274*1e-9
w0=FWHM/sqrt(2*log(2))
#beam position parameter
min_r0=-2.25e-6
max_r0=2.25e-6
Nr0=41
r0s=LinRange(min_r0,max_r0,Nr0)
#distance parameters
min_d=0.001e-6
max_d=10e-6
Nd=200
dis=LinRange(min_d,max_d,Nd)


#compute the x-component of the force and return force on part. 1 and 2. 
function calculate_force_bis(bis,r,alpha,r0;Ainv=nothing,Ainv1=nothing,Ainv2=nothing,compute_inverse=true)
    #number of dipoles
    Nr=length(r[:,1])
    Ns=Int(Nr/2)
    #computing the input field
    e0=InputFields.gaussian_beam_e(knorm*(r-r0),knorm*w0)
    e01=InputFields.gaussian_beam_e(knorm*(r-r0)[1:Ns,:],knorm*w0)
    e02=InputFields.gaussian_beam_e(knorm*(r-r0)[Ns+1:2*Ns,:],knorm*w0)
    #computing derivative of the fields
    dx,dy,dz=InputFields.d_gaussian_beam_e(knorm*(r-r0),knorm*w0)
    dx1,dy1,dz1=InputFields.d_gaussian_beam_e(knorm*(r-r0)[1:Ns,:],knorm*w0)
    dx2,dy2,dz2=InputFields.d_gaussian_beam_e(knorm*(r-r0)[Ns+1:2*Ns,:],knorm*w0)
    #computing the inverse of the DDA matrix, if needed
    if compute_inverse
        Ainv=DDACore.solve_DDA_e(knorm*r,alpha,solver="CPU")
        Ainv1=DDACore.solve_DDA_e(knorm*r[1:Ns,:],alpha[1:Ns],solver="CPU")
        Ainv2=DDACore.solve_DDA_e(knorm*r[1+Ns:2*Ns,:],alpha[1+Ns:2*Ns],solver="CPU")
    end
    #compute the forces using the force function
    fx,fy,fz=Forces.force_e(knorm*r,alpha, Ainv, e0, dx, dy, dz)
    fx1,fy1,fz1=Forces.force_e(knorm*r[1:Ns,:],alpha[1:Ns], Ainv1, e01, dx1, dy1, dz1)
    fx2,fy2,fz2=Forces.force_e(knorm*r[1+Ns:2*Ns,:],alpha[1+Ns:2*Ns], Ainv2, e02, dx2, dy2, dz2)
    #resturn the optical binding force
    f1=sum(fx[1:1:Ns])-sum(fx1)
    f2=sum(fx[1+Ns:1:2*Ns])-sum(fx2)
    return f1,f2,Ainv,Ainv1,Ainv2,sum(fx1),sum(fx2)
end

##############################MAIN###########################

#loop on all the radius
for a in as
    #lattice generation
    sphere_latt,dx=Geometries.discretize_sphere(a,10,N_sub=10)
    rs=sphere_latt[:,1:3]
    V=dx^3
    Ns=length(rs[:,1])
    #positions
    r=zeros(Float64,2*Ns,3)
    r[1:Ns,:]=rs
    r[Ns+1:2*Ns,:]=rs
    #filling fraction
    fill=zeros(Float64,2*Ns)
    fill[1:Ns]=sphere_latt[:,4]
    fill[Ns+1:2*Ns]=sphere_latt[:,4]
    #polarizabilities check
    alpha=Alphas.alpha_radiative.(Alphas.alpha0_volume.(V,eps.*fill.+(1 .-fill).*eps_h,eps_h),knorm)
    #forces calculations
    force1=zeros(Float64,Nd+1,Nr0+1)
    force1[2:end,1]=dis
    force1[1,2:end]=r0s
    force2=copy(force1) 
    force1t=copy(force1)
    force2t=copy(force1)
    #loop on all the surface to surface diatances
    for i=1:Nd
        #update x coordinates of both particles
        global r[1:Ns,1]=rs[:,1].-(dis[i]+2*a)/2
        global r[Ns+1:2*Ns,1]=rs[:,1].+(dis[i]+2*a)/2
        #loop on all the beam positions
        for j=1:Nr0
            println("i=",i," j=",j) 
            #update beam position
            r0_temp=zeros(Float64,2*Ns,3)
            r0_temp[:,1].=r0s[j]
            #compute forces
            if j==1
               global f1,f2,Ainv,Ainv1,Ainv2,f1t,f2t=calculate_force_bis(knorm,r,alpha,r0_temp,compute_inverse=true)
            else
               global f1,f2,Ainv,Ainv1,Ainv2,f1t,f2t=calculate_force_bis(knorm,r,alpha,r0_temp,Ainv=Ainv,Ainv1=Ainv1,Ainv2=Ainv2,compute_inverse=false)
            end
            #save
            println("f1=",f1," f2=",f2) 
            force1[i+1,j+1]=f1
            force2[i+1,j+1]=f2
            force1t[i+1,j+1]=f1t
            force2t[i+1,j+1]=f2t
        end
    end
    #save data
    name="a_"*string(Int(floor(a*1e9)))*"_"
    #saving
    writedlm(name*"_f1_xdata",force1)
    writedlm(name*"_f2_xdata",force2)
    writedlm(name*"_f1t_xdata",force1t)
    writedlm(name*"_f2t_xdata",force2t)
    writedlm(name*"_xsetup",[a lambda min_d max_d min_r0 max_r0])
end