function [U_obs]=GPT_ZCorrection(r,U_kT,sigma_z)
% MATLAB script to compute the observed pair potential U_obs from given U(r)

% Load or define your pair potential data (r: distances, U_kT: potential in kT units)

% Define parameters
z_max = 10 * sigma_z; % Integration limit for z (truncating Gaussian tail)
num_z = 200; % Number of z points for numerical integration
z_vals = linspace(-z_max, z_max, num_z); % Discretize z axis

% Compute observed potential U_obs
U_obs = zeros(size(r));

for i = 1:length(r)
    % Compute probability distribution P(z)
    P_z = exp(-z_vals.^2 / (2 * sigma_z^2)) / sqrt(2 * pi * sigma_z^2);
    P_z = P_z / trapz(z_vals, P_z); % Normalize P(z)

    r_actual = sqrt(r(i)^2 + z_vals.^2); % True distance in 3D
    U_interp = interp1(r, U_kT, r_actual, 'linear', 'extrap'); % Interpolate U(r)
    U_obs(i) = trapz(z_vals, P_z .* exp(-U_interp)) / trapz(z_vals, P_z); % Weighted average
    U_obs(i) = -log(U_obs(i)); % Convert back to potential form
end
% 
% % Plot results
% figure;
% plot(r, U_kT, 'b-', 'LineWidth', 2); hold on;
% plot(r, U_obs, 'r--', 'LineWidth', 2);
% xlabel('r / D');
% ylabel('U / kT');
% legend('True U', 'Observed U');
% title('Effect of Axial Fluctuations on Measured Potential');
% grid on;

end