// swift-tools-version:5.5
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
    name: "TAPMLSwift",
    products: [
        .library(
            name: "TAPMLSwift",
            targets: ["TAPMLEngineObjC", "TAPMLSwift"]
        )
    ],
    dependencies: [],
    targets: [
        .target(
            name: "TAPMLEngineObjC",
            path: "Sources/ObjC",
            cxxSettings: [
                .headerSearchPath("../../tvm_home/include"),
                .headerSearchPath("../../tvm_home/3rdparty/dmlc-core/include"),
                .headerSearchPath("../../tvm_home/3rdparty/dlpack/include")
            ]
        ),
        .target(
            name: "TAPMLSwift",
            dependencies: ["TAPMLEngineObjC"],
            path: "Sources/Swift"
        )
    ],
    cxxLanguageStandard: .cxx17
)
