# STAR-Prompting Converter

Developed within the scope part of the paper: "STAR-Prompting: Estruturando Prompts Eficientes para IA Conversacional através do Método STAR aplicados para Defesa e Segurança".

The application transforms natural language prompts into the structured STAR format (Situation, Task, Action, Result) and runs them across multiple AI models. It was used to automate the workflow, enabling a larger number of tests and reinforcing the article’s thesis that STAR-Prompting delivers more efficient results than free-form prompting.

## Abstract

Originally used in the field of human resources, the STAR method (Situation, Task, Action, Result) provides a logical structure for framing responses in behavioral interviews. This study proposes the term STAR-Prompting to define the technique of structuring prompts based on the STAR logic for interactions with conversational artificial intelligences, aiming for clearer, more consistent, and reliable responses — especially in critical decision-making contexts in the fields of Defense and Security. 

Through a controlled experiment using an algorithm that automates prompt structuring and execution, the study compares free-form prompts with those structured through STAR-Prompting, as well as the results obtained from four of the most widely used large language models: Claude 3 Haiku, GPT-4o, Gemini Pro, and Llama 3 70B. 

The results show that STAR-Prompting significantly improves the quality of generated responses. The study also explores the practical benefits of this approach and highlights its promising potential to significantly enhance outcomes and the efficiency of human-AI communication.


## Features

- **Multi-Model Support**: Test your prompts across various AI models including:
  - Google: Gemini Flash 2.0
  - Meta: Llama 3.3 70B Instruct
  - GPT-4oOpenAI: GPT-4o-mini
  - Anthropic: Claude 3.5 Sonnet

- **STAR Format Conversion**: Automatically converts natural language prompts into structured STAR format
- **Parallel Execution**: Run both original and STAR-formatted prompts simultaneously
- **Comparative Analysis**: View and compare responses from different models
- **Batch Processing**: Handle multiple prompts at once
- **Real-time Status Tracking**: Monitor the progress of prompt processing
- **Error Handling**: Robust error handling and user feedback

## Data Flow

- The user enters the prompts and selects the models in the interface.  
- API requests are sent to the backend.  
- The backend processes the requests and forwards them to OpenRouter.  
- OpenRouter communicates with the AI models.  
- The responses return along the same path.  
- The interface is updated with the results.


## Getting Started

### Prerequisites

- Node.js (v18 or higher)
- npm or yarn
- OpenRouter API key

### Installation

1. Install dependencies:
```bash
npm install
# or
yarn install
```

2. Create a `.env.local` file in the root directory and add your OpenRouter API key:
```env
OPENROUTER_API_KEY=your_api_key_here
```

4. Start the development server:
```bash
npm run dev
# or
yarn dev
```

5. Open [http://localhost:3000](http://localhost:3000) with your browser to see the application.

## Usage

1. **Select Models**: Choose one or more AI models from the available options
2. **Enter Prompts**: Input your prompts in the text area (one per line)
3. **Process Prompts**: Click the "Process" button to start conversion and execution
4. **View Results**: 
   - First section shows the STAR-formatted prompts
   - Second section displays the execution results from both original and STAR-formatted prompts

## Architecture

The application follows a modern web architecture:

- **Frontend**: Next.js with React
- **Backend**: Next.js API Routes
- **External Services**: OpenRouter API for AI model access
- **State Management**: React Hooks
- **Styling**: Tailwind CSS

### Key Components

- `app/page.tsx`: Main application interface
- `app/api/route.ts`: API route handler
- `components/ui/card.tsx`: UI components
- `lib/utils.ts`: Utility functions

## Configuration

### Available Models

The application supports the following AI models:

```typescript
const models = [
  { id: "google/gemini-2.0-flash-001", name: "Google: Gemini Flash 2.0" },
  { id: "meta-llama/llama-3.3-70b-instruct", name: "Meta: Llama 3.3 70B Instruct" },
  { id: "openai/gpt-4o-mini", name: "GPT-4oOpenAI: GPT-4o-mini" },
  { id: "anthropic/claude-3.5-sonnet", name: "Anthropic: Claude 3.5 Sonnet" },
]
```

### Environment Variables

- `OPENROUTER_API_KEY`: Your OpenRouter API key

## Development

### Project Structure

```
starprompt-converter/
├── app/
│   ├── api/
│   │   └── route.ts
│   ├── page.tsx
│   └── layout.tsx
├── components/
│   └── ui/
│       └── card.tsx
├── lib/
│   └── utils.ts
├── public/
└── package.json
```

### Available Scripts

- `npm run dev`: Start development server
- `npm run build`: Build for production
- `npm run start`: Start production server
- `npm run lint`: Run ESLint