import pandas as pd
import glob
root_folder = "C:/data/dma"


df_main = pd.DataFrame(
    {
        "Datetime": pd.date_range(start="2024-03-01", end="2024-07-01", freq='30min')
    }
)

print(df_main.head().to_string())

ls_files = glob.glob(f"{root_folder}/*_tier2.csv")
for fle in ls_files:
    print(fle)
    df_local = pd.read_csv(fle, sep=";", parse_dates=["Datetime"])
    df_main = pd.merge(left=df_main, right=df_local, on="Datetime", how="left")

df_main.drop(columns=["8744400 Usina do Gasômetro"], inplace=True)

print("\n")
print(df_main.head().to_string())
print(df_main.tail().to_string())

df_main = df_main.round(decimals=3)

df_main.to_csv(f"{root_folder}/dados_tier3.txt", sep=";", encoding="utf-8", index=False)