import pandas as pd
import matplotlib.pyplot as plt

root_folder = "C:/data/dma"

f = f"{root_folder}/dados_guaiba_C_tier1.csv"

df = pd.read_csv(f, sep=";", encoding="utf-8")

print(df.head().to_string())

# Rename columns to lowercase to match pd.to_datetime expectations
df.rename(columns={'Year': 'year', 'Month': 'month', 'Day': 'day',
                   'Hour': 'hour', 'Min': 'minute', 'Sec': 'second'}, inplace=True)

# Combine the columns into a single datetime column
df['Datetime'] = pd.to_datetime(df[['year', 'month', 'day', 'hour', 'minute', 'second']])

# Move the Datetime column to the first position
df = df[['Datetime'] + [col for col in df.columns if col != 'Datetime']]

# Drop the original year, month, day, hour, minute, and second columns
df.drop(['year', 'month', 'day', 'hour', 'minute', 'second'], axis=1, inplace=True)



print(df.head(30).to_string())

'''
plt.scatter(df["Datetime"], df["Guaiba Catsul"])
plt.ylim(0, 7)
plt.show()
'''

#df.to_csv(f"{root_folder}/dados_guaiba_C_tier2.csv", sep=";", index=False, encoding="utf-8")

print("*****\n")


