import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.dates as mdates
import matplotlib as mpl
import numpy as np
import locale

# Set the locale to Portuguese
locale.setlocale(locale.LC_TIME, 'pt_BR.utf8')

plt.style.use("seaborn-v0_8")

def normalize_vector(v):
    # Ignore NaN values for min and max calculations
    v_min = np.nanmin(v)
    v_max = np.nanmax(v)
    # Normalize, ensuring that NaNs remain unaffected
    return (v - v_min) / (v_max - v_min)

root_folder = r"C:\Users\Ipo\My Drive\athens\losalamos\B000\B008_paper-dma\inputs\dados"

f_niveis = "dados_reguas_tier3.txt"
f_chuva = "dados_chuva_86743800_tier2.txt"

df_niveis = pd.read_csv(f"{root_folder}/{f_niveis}", sep=";", skiprows=15, parse_dates=["Datetime"])
ls_niveis = [
    "Rio Taquari - Estrela",
    "Guaíba - Cais Mauá C6",
    "Guaíba - Usina do Gasômetro",
    "Guaiba - Catsul",
    "Lagoa dos Patos - Pelotas Porto",
]
df_niveis = df_niveis[["Datetime"] + ls_niveis].copy()

df_chuva = pd.read_csv(f"{root_folder}/{f_chuva}", sep=";", skiprows=4, parse_dates=["Datetime"])

dt_start = "2024-04-25"
dt_end = "2024-06-10"

df_niveis.query("Datetime >= '{}' and Datetime < '{}'".format(dt_start, dt_end), inplace=True)
df_chuva.query("Datetime >= '{}' and Datetime < '{}'".format(dt_start, dt_end), inplace=True)
#df_chuva["Chuva_acc"] = df_chuva["Chuva"].cumsum()

# Set 'Datetime' as the index of the DataFrame
df_chuva.set_index('Datetime', inplace=True)

# Resample and sum the 'Chuva' values for each day
daily_rain = df_chuva.resample('D').sum()
daily_rain["Acc"] = daily_rain["Chuva"].cumsum()
daily_rain["Acc"].values[1:] = daily_rain["Acc"].values[0:-1]
df_chuva = df_chuva.reset_index()
daily_rain = daily_rain.reset_index()


print(daily_rain["Chuva"].max())
max_rain = daily_rain["Chuva"].max()
print(daily_rain.head(20).to_string())
#print(df_niveis)

df_niveis_a = df_niveis[["Datetime", ls_niveis[0]]].copy().dropna()
print(ls_niveis[0])
print(df_niveis_a[ls_niveis[0]].min())
print(df_niveis_a[ls_niveis[0]].max())

df_niveis_b = df_niveis[["Datetime", ls_niveis[3]]].copy().dropna()
print(ls_niveis[3])
print(df_niveis_b[ls_niveis[3]].min())
print(df_niveis_b[ls_niveis[3]].max())

df_niveis_c = df_niveis[["Datetime", ls_niveis[4]]].copy().dropna()
print(ls_niveis[4])
print(df_niveis_c[ls_niveis[4]].min())
print(df_niveis_c[ls_niveis[4]].max())


# Deploy figure
fig = plt.figure(figsize=(10, 7))  # Width, Height
gs = mpl.gridspec.GridSpec(
    4, 1, wspace=0.8, hspace=0.3, left=0.40, bottom=0.1, top=0.95, right=0.95
)

# plot map
ax = plt.subplot(gs[0, 0])

plt.bar(daily_rain["Datetime"], daily_rain["Chuva"], width=pd.Timedelta(value=20, unit="h"), color="navy")


# Set minor ticks for each day
ax.xaxis.set_minor_locator(mdates.DayLocator())
#ax.xaxis.set_minor_formatter(mdates.DateFormatter('%d'))

# Enable grid for major and minor ticks
ax.grid(True, which='major', linestyle='-', linewidth='0.5', color='white')  # Major grid
ax.grid(True, which='minor', linestyle='-', linewidth='0.5', color='white')  # Minor grid for days

# Set major ticks format
ax.xaxis.set_major_locator(mdates.WeekdayLocator(byweekday=mdates.MO))  # Every Monday
ax.xaxis.set_major_formatter(mdates.DateFormatter('%d %b'))  # Day and month

# Extend ticks outside the plot area for each Monday
ax.tick_params(
    axis='x',
    which='major',
    direction='out',
    length=6, width=1,
    colors='darkgray',
    pad=5, labelsize=10,
    labelcolor='black',
    bottom=True, top=False
)

df = pd.DataFrame(df_niveis[ls_niveis[0]], index=df_niveis["Datetime"])
# Color background for each week alternately
week_color = True
for week, group in df.groupby(pd.Grouper(freq='W-MON')):
    start_date = group.index.min() - pd.Timedelta(value=1, unit="d")
    end_date = group.index.max() - pd.Timedelta(value=1, unit="d")
    if week_color:
        ax.axvspan(start_date, end_date, color='grey', alpha=0.2)  # Visible week
    else:
        ax.axvspan(start_date, end_date, color='none')  # Fully transparent week
    week_color = not week_color  # Toggle between True and False

plt.xlim(df.index.min(), df.index.max() - pd.Timedelta(value=4, unit="d"))
plt.ylim(0, 300)
plt.ylabel("mm / d")

# Create the secondary y-axis
ax2 = ax.twinx()
# Plot the line graph
ax2.plot(daily_rain["Datetime"], daily_rain["Acc"], color='black')
plt.ylim(0, 1500)


# plot map
ax = plt.subplot(gs[1, 0])
plt.plot(df_niveis_a["Datetime"], normalize_vector(v=df_niveis_a[ls_niveis[0]].values), c="purple")
plt.plot(df_niveis_b["Datetime"], normalize_vector(v=df_niveis_b[ls_niveis[3]].values), c="blue")
plt.plot(df_niveis_c["Datetime"], normalize_vector(v=df_niveis_c[ls_niveis[4]].values), c="teal")
plt.ylim(0, 1.2)

# Set minor ticks for each day
ax.xaxis.set_minor_locator(mdates.DayLocator())
#ax.xaxis.set_minor_formatter(mdates.DateFormatter('%d'))

# Enable grid for major and minor ticks
ax.grid(True, which='major', linestyle='-', linewidth='0.5', color='white')  # Major grid
ax.grid(True, which='minor', linestyle='-', linewidth='0.5', color='white')  # Minor grid for days

# Set major ticks format
ax.xaxis.set_major_locator(mdates.WeekdayLocator(byweekday=mdates.MO))  # Every Monday
ax.xaxis.set_major_formatter(mdates.DateFormatter('%d %b'))  # Day and month

# Extend ticks outside the plot area for each Monday
ax.tick_params(
    axis='x',
    which='major',
    direction='out',
    length=6, width=1,
    colors='darkgray',
    pad=5, labelsize=10,
    labelcolor='black',
    bottom=True, top=False
)

df = pd.DataFrame(df_niveis[ls_niveis[0]], index=df_niveis["Datetime"])
# Color background for each week alternately
week_color = True
for week, group in df.groupby(pd.Grouper(freq='W-MON')):
    start_date = group.index.min() - pd.Timedelta(value=1, unit="d")
    end_date = group.index.max() - pd.Timedelta(value=1, unit="d")
    if week_color:
        ax.axvspan(start_date, end_date, color='grey', alpha=0.2)  # Visible week
    else:
        ax.axvspan(start_date, end_date, color='none')  # Fully transparent week
    week_color = not week_color  # Toggle between True and False

plt.xlim(df.index.min(), df.index.max() - pd.Timedelta(value=4, unit="d"))
plt.yticks([0, 1], ['min', 'max'])
# Beautify the x-labels
#plt.gcf().autofmt_xdate()

# plot map
ax = plt.subplot(gs[2:, 0])
plt.ylim(0, 1)

# Set minor ticks for each day
ax.xaxis.set_minor_locator(mdates.DayLocator())
#ax.xaxis.set_minor_formatter(mdates.DateFormatter('%d'))

# Enable grid for major and minor ticks
ax.grid(True, which='major', linestyle='-', linewidth='0.5', color='white')  # Major grid
ax.grid(True, which='minor', linestyle='-', linewidth='0.5', color='white')  # Minor grid for days

# Set major ticks format
ax.xaxis.set_major_locator(mdates.WeekdayLocator(byweekday=mdates.MO))  # Every Monday
ax.xaxis.set_major_formatter(mdates.DateFormatter('%d %b'))  # Day and month

# Extend ticks outside the plot area for each Monday
ax.tick_params(
    axis='x',
    which='major',
    direction='out',
    length=6, width=1,
    colors='darkgray',
    pad=5, labelsize=10,
    labelcolor='black',
    bottom=True, top=False
)

df = pd.DataFrame(df_niveis[ls_niveis[0]], index=df_niveis["Datetime"])
# Color background for each week alternately
week_color = True
for week, group in df.groupby(pd.Grouper(freq='W-MON')):
    start_date = group.index.min() - pd.Timedelta(value=1, unit="d")
    end_date = group.index.max() - pd.Timedelta(value=1, unit="d")
    if week_color:
        ax.axvspan(start_date, end_date, color='grey', alpha=0.2)  # Visible week
    else:
        ax.axvspan(start_date, end_date, color='none')  # Fully transparent week
    week_color = not week_color  # Toggle between True and False

plt.xlim(df.index.min(), df.index.max() - pd.Timedelta(value=4, unit="d"))
plt.yticks([0, 1], ['', ''])
# Beautify the x-labels
#plt.gcf().autofmt_xdate()
plt.savefig(f"{root_folder}/base_fig2.jpg", dpi=300)

