# StratoBayes: A Bayesian method for automated stratigraphic correlation and age modelling

Author(s): [Kilian Eichenseer](mailto:kilian.eichenseer@gmail.com), [Matthias Sinnesael](mailto:sinnesam@tcd.ie), [Martin R. Smith](mailto:martin.smith@durham.ac.uk) and [Andrew R. Millard](mailto:A.R.Millard@durham.ac.uk)

This repository contains the data and code required to run the analyses and generate the results for the article "StratoBayes: A Bayesian method for automated stratigraphic correlation and age modelling" submitted to Geochronology in 2025. 

To run StratoBayes, please visit [stratobayes.github.io/software/](https://stratobayes.github.io/software.html) for installation instructions. To seamlessly use the R scripts in this repository, download the repo, unpack the Zip archive and navigate the working directory of your R session to that folder using `setwd()` or by opening the *StratoBayesManuscript* R project in RStudio.

To cite the paper: 
> Kilian Eichenseer, Matthias Sinnesael, Martin R. Smith and Andrew R. Millard. 2025. StratoBayes: A Bayesian method for automated stratigraphic correlation and age modelling. Submitted to *Geochronology*.

-------

## Binaries
Instead of using the installation instructions at [stratobayes.github.io/software/](https://stratobayes.github.io/software.html) (recommended), the package can also be installed from the binaries contained in the **./bin** folder. This requires an **R 4.4.x** installation and is supported for Windows, macOS Intel and macOS Apple silicon. 

Replace *path/to/directory* with the actual path to the StratoBayes-Manuscript folder on your computer, then run the following command from the R console within RStudio:

   ```r
   install.packages("StratoBayes", 
                    repos = c("file:///path/to/StratoBayes-Manuscript/",
                     getOption("repos")), 
                    type = "binary", 
                    dependencies = TRUE)
   ```

## Data
The data is organised in the folder "data" as follows:

* **./data/simulated/**
This folder contains simulated data used for the model demonstration and illustration.

* **./data/cambrian/**
This folder contains the early Cambrian &delta;^13^C, the radiometric dates, site partitionings and astrochronological data.

-------

## Figures
The "figures" folder contains the final composite figures of the manuscript, as well as two subfolders containing elements of the figures:

* **./figures/conceptual-figure/**
Elements of Fig. 1.

* **./figures/illustration-Figure/**
Elements of Fig. 2.

* **./figures/cambrian-Figure/**
Elements of Fig. 3--7 and the figures of Appendix B.
-------

## R
R scripts for generating the results of the manuscript.

* **./R/01-simulate-data.R**
This script simulates the data for the conceptual figure and for the model illustration.

* **./R/02-analyse-simulated-data-1.R**
Generates the results for the conceptual figure.

* **./R/03-analyse-simulated-data-2.R**
Generates the results for the model illustration.

* **./R/04-analyse-Cambrian-data.R**
Analysis of the early Cambrian data.

* **./R/05-results-for-text.R**
Compiles results for the text.

* **./R/figures/**
This folder contains the R scripts to generate the figures.

-------

## Results
The "results" folder stores the results generated by the 
analysis scripts, organised in the following subfolders:

* **./results/model-illustration**
Results from analysing the simulated data. `alignment-2-peaks.rds` holds the results from the MCMC for the model illustration analysis.

* **./results/cambrian/**
Results from analysing the Cambrian data. `cambrian-results.rds` holds the results from the MCMC for the Cambrian analysis.

* **./results/text-results/**
Results saved for use in the manuscript text.

-------
