# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
# import sphinx_bootstrap_theme

import os

# -- Project information -----------------------------------------------------

project = "croco_pytools"
copyright = "2023, CROCO team"
author = ""
author_tex = ""

# The short X.Y version
version = ""
# The full version, including alpha/beta/rc tags
release = "1.0.2"


# -- General configuration ---------------------------------------------------

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.intersphinx",
    "sphinx.ext.napoleon",
    "sphinx.ext.viewcode",
    "sphinx.ext.extlinks",
    "sphinx.ext.mathjax",
    "IPython.sphinxext.ipython_directive",
    "IPython.sphinxext.ipython_console_highlighting",
    "nbsphinx",
    "sphinxarg.ext",
    "sphinxcontrib.programoutput",
    "sphinx_book_theme",
]

# Add option for creating tab

sphinx_tabs_valid_builders = ["linkcheck"]
sphinx_tabs_disable_tab_closing = True


sphinx_tabs_disable_css_loading = True


# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# %% Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_book_theme"

html_logo = "_static/logo_CROCO_2.png"

html_favicon = "_static/favicon_CROCO.png"
# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#


# Récupérer la branche actuelle à partir des variables d'environnement de GitLab CI
branch_name = os.getenv("CI_COMMIT_REF_NAME", "unknown")

# Définir le message d'annonce en fonction de la branche
if branch_name.startswith("release"):
    announcement = f"CROCO_PYTOOLS release {release} documentation"
elif branch_name == "unknown":
    announcement = f"⚠️ You're on a development branch of CROCO_PYTOOLS documentation. Work in progress! ⚠️"
else:
    announcement = f"⚠️ You're on a development branch of CROCO_PYTOOLS documentation (branch :{branch_name}). Work in progress! ⚠️"

# Passer ce message à Sphinx via html_theme_options
html_theme_options = {
    "announcement": announcement,
    "repository_provider": "gitlab",
    "repository_url": "https://gitlab.inria.fr/croco-ocean/croco_pytools",
    "use_repository_button": True,
}


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = False

# Output file base name for HTML help builder.
htmlhelp_basename = "crocodocpytools"
