import { MonotoneSvgProps } from './types';

export default function MapSVG({ primaryColor }: MonotoneSvgProps) {
  return (
    // <!-- Generator: Adobe Illustrator 25.4.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
    <svg
      version="1.1"
      id="Layer_1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      x="0px"
      y="0px"
      viewBox="0 0 500 500"
      xmlSpace="preserve"
    >
      <style type="text/css">
        {/* <!-- svg classes --> */}
        .world-outline&#123;fill:none;stroke:#AFB1B2;stroke-width:0.6;stroke-miterlimit:10;&#125;
        .world-fill&#123;fill:#AFB1B2;&#125;
        .dots&#123;fill-rule:evenodd;clip-rule:evenodd;stroke:#FFFFFF;stroke-width:4;stroke-miterlimit:10;&#125;
      </style>
      <g>
        <path
          id="Path_00000026876776521971495720000016408140299421107896_"
          className="world-outline"
          d="M448.68,251.323
        C448.68,361.047,359.729,450,250.003,450S51.32,361.049,51.32,251.323l0,0c0-109.73,88.955-198.683,198.683-198.683
        S448.68,141.594,448.68,251.323z"
        />
      </g>
      <g>
        <path
          id="Shape_00000148646265399476379110000008089688319055894188_"
          className="world-fill"
          d="M235.305,436.677
        c-1.003-0.151-1.862-0.642-1.924-1.07c-0.054-0.438-0.125-1.1-0.169-1.478c-0.107-0.925-4.745-5.001-7.789-6.85
        c-1.537-0.924-2.768-2.345-3.272-3.766c-0.455-1.255-1.066-2.285-1.358-2.285c-0.286,0-0.518-0.428-0.518-0.954
        c0-0.532-0.629-1.397-1.396-1.947c-0.76-0.532-1.197-1.293-0.955-1.684c0.272-0.438,0.044-0.554-0.592-0.317
        c-0.75,0.297-1.022-0.04-1.022-1.209c0-1.012-1.14-2.798-3.05-4.812c-3.151-3.282-4.503-7.317-3.077-9.136
        c0.363-0.456,0.848-1.644,1.09-2.64c0.238-0.992,1.324-2.471,2.404-3.28c2.347-1.738,2.414-2.379,0.582-5.493
        c-0.766-1.303-1.217-2.815-0.999-3.385c0.212-0.554-0.838-3.551-2.341-6.635c-2.027-4.192-3.669-6.49-6.437-9.028
        c-3.339-3.055-6.689-7.677-6.689-9.237c0-0.317,0.451-0.594,0.993-0.594c0.673,0,0.999-0.691,1.013-2.15
        c0.014-1.188,0.455-2.734,0.993-3.445c1.725-2.295,0.707-7.002-1.124-5.177c-0.451,0.46-1.201,0.827-1.682,0.827
        c-1.217,0-1.066-1.947,0.195-2.429c1.914-0.739-0.471-1.532-4.681-1.55c-2.182-0.01-4.3-0.243-4.707-0.506
        c-0.407-0.279-1.527-2.042-2.472-3.937c-1.513-3.011-2.061-3.513-4.227-3.921c-3.325-0.626-7.405-0.618-13.383,0.026
        c-4.648,0.506-5.172,0.422-8.265-1.241c-2.559-1.371-4.58-1.859-8.924-2.144c-6.433-0.434-6.971-0.775-12.748-8.173
        c-1.856-2.369-4.731-5.561-6.383-7.101c-1.973-1.839-2.758-2.973-2.273-3.318c1.183-0.827,0.286-4.491-1.628-6.651
        c-0.965-1.09-2.132-2.538-2.589-3.22c-0.461-0.695-1.439-2.154-2.176-3.24c-0.993-1.478-1.211-2.501-0.858-3.979
        c0.266-1.1,0.508-3.477,0.524-5.302c0.024-2.116,0.417-3.668,1.086-4.31c1.392-1.323,2.758-4.641,1.914-4.641
        c-0.353,0-0.645-0.895-0.645-1.995c0-1.09,0.256-1.985,0.572-1.985s0.538,0.522,0.498,1.158c-0.179,2.608,1.14,1.606,1.382-1.054
        c0.179-1.923,0.034-2.74-0.431-2.443c-0.882,0.54-0.891,0.685,0.29-4.951c0.804-3.85,1.517-5.338,3.806-8.004
        c1.547-1.803,3.329-3.439,3.965-3.642c0.639-0.205,1.153-0.807,1.153-1.353c0-1.761,2.007-4.083,3.858-4.451
        c1.028-0.207,2.216-1.104,2.724-2.052c0.703-1.313,1.245-1.6,2.442-1.303c0.955,0.249,1.557,0.104,1.557-0.371
        c0-0.418,0.369-0.705,0.824-0.626c0.455,0.072,1.275-0.058,1.819-0.291c0.542-0.229,1.769-0.697,2.714-1.046
        c1.328-0.486,1.819-1.225,2.138-3.182c0.558-3.527,4.527-7.58,8.438-8.62c3.709-0.982,6.476-4.421,6.02-7.496
        c-0.199-1.377-0.663-1.991-1.503-1.991c-0.663,0-1.386-0.301-1.61-0.662c-0.228-0.365-0.985-0.666-1.695-0.666
        c-1.523,0-1.58-0.536-0.266-2.291c0.621-0.823,0.834-2.034,0.592-3.328c-0.3-1.62,0.034-2.568,1.638-4.593
        c2.099-2.646,3.349-6.065,3.359-9.156c0.004-1.546,0.387-1.903,2.714-2.535c2.249-0.604,2.903-0.554,3.848,0.307
        c0.629,0.57,1.584,1.036,2.118,1.036c0.538,0,1.265,0.301,1.624,0.658c0.353,0.355,2.128,1.104,3.931,1.654
        c3.151,0.962,3.335,0.948,4.421-0.361c0.625-0.753,1.332-2.399,1.56-3.648c0.498-2.656-0.165-6.912-1.076-6.912
        c-0.343,0-0.629-0.414-0.629-0.929c0-0.51-0.447-1.094-0.993-1.309c-0.578-0.223-0.989-1.215-0.989-2.389
        c0-1.897,0.145-2.008,2.589-2.008c1.429,0,2.758,0.375,2.972,0.831c0.208,0.456,0.195,0.108-0.024-0.763
        c-0.316-1.255-0.179-1.508,0.625-1.198c0.562,0.219,1.144,0.04,1.304-0.398c0.189-0.544,0.699-0.422,1.624,0.408
        c1.281,1.138,1.479,1.144,3.897,0.078l2.549-1.128l-2.317-0.58c-1.271-0.317-4.542-0.691-7.27-0.837
        c-2.73-0.135-5.482-0.287-6.113-0.321c-1.793-0.108-1.362-1.182,0.655-1.634c1.003-0.223,2.414-0.871,3.145-1.435
        c1.072-0.837,1.144-1.134,0.397-1.6c-1.217-0.749-0.431-2.69,1.096-2.69c0.882,0,1.197-0.492,1.177-1.819
        c-0.02-1.6,0.204-1.799,1.789-1.63c1.61,0.165,1.809-0.024,1.745-1.66c-0.044-1.128-0.195-1.397-0.377-0.695
        c-0.165,0.642-0.756,1.158-1.314,1.158c-0.625,0-0.872-0.375-0.645-0.982c0.316-0.823,0.165-0.851-0.921-0.169
        c-0.713,0.452-1.298,1.441-1.298,2.208c0,0.763-0.518,1.849-1.157,2.407c-1.338,1.172-6.84,2.12-8.763,1.508
        c-1.967-0.628-1.735-3.483,0.359-4.445c0.999-0.452,1.541-1.134,1.332-1.674c-0.518-1.353,1.628-4.29,2.807-3.844
        c0.538,0.213,1.531-0.108,2.192-0.715c0.699-0.632,1.866-0.958,2.787-0.783c1.062,0.205,1.836-0.108,2.347-0.915
        c0.471-0.753,0.504-1.215,0.091-1.215c-1.173,0-0.717-1.323,0.494-1.401c1.1-0.078,1.1-0.092,0-0.379
        c-1.557-0.408-1.459-1.138,0.403-3.156c1.6-1.737,3.727-2.271,3.727-0.944c0,0.526,0.286,0.51,0.959-0.058
        c0.528-0.438,1.294-0.598,1.696-0.345c0.397,0.249,1.318-0.078,2.027-0.725c1.032-0.938,1.459-1.006,2.104-0.351
        c0.649,0.652,0.363,1.225-1.342,2.768c-1.856,1.678-1.973,1.947-0.828,1.947c1.755,0,1.755,2.068,0,3.652
        c-1.531,1.391-1.358,3.644,0.737,9.463c1.435,4.013,1.662,8.512,0.431,8.946c-0.455,0.165-0.629,0.51-0.393,0.769
        c0.737,0.803,4.221-1.415,6.097-3.897c1.624-2.136,2.099-2.359,5.027-2.359c3.568,0,3.679-0.141,4.308-5.234
        c0.494-3.949,1.046-4.742,4.018-5.764c1.973-0.685,2.66-0.701,3.053-0.084c0.296,0.466,0.514-0.098,0.514-1.353
        c0.014-2.379-0.931-2.754-3-1.178c-0.707,0.536-2.176,0.982-3.272,0.992c-2.946,0.03-3.844-1.853-3.276-6.854
        c0.615-5.37,1.654-7.223,4.89-8.683c1.483-0.671,2.69-1.455,2.69-1.737c0-0.291,1.046-0.905,2.327-1.363
        c1.566-0.57,3.097-1.965,4.678-4.272c1.298-1.883,3.073-3.81,3.955-4.276c0.878-0.482,1.479-0.982,1.328-1.138
        c-0.151-0.151-0.921,0.078-1.711,0.5c-0.79,0.422-1.594,0.614-1.789,0.418c-0.524-0.53,3.77-4.324,6.538-5.764
        c1.338-0.695,2.613-1.566,2.845-1.937c0.228-0.375,1.288-0.681,2.361-0.681c1.066,0,1.944-0.239,1.944-0.526
        c0-0.783,3.945-1.975,6.709-2.028c1.688-0.034,2.934,0.442,4.165,1.59c0.969,0.901,2.192,1.63,2.714,1.63
        c0.528,0,0.959,0.301,0.959,0.666s0.586,0.662,1.308,0.662c2.341,0,9.782,3.453,10.548,4.898c0.431,0.793,1.467,1.441,2.424,1.498
        c1.541,0.092,1.584,0.01,0.633-1.046c-0.566-0.632-1.032-1.644-1.032-2.252c0-0.614-0.306-1.114-0.665-1.114
        c-0.363,0-0.663-0.476-0.663-1.066c0-0.823,0.494-1.002,2.152-0.759c1.177,0.161,2.666,0.52,3.296,0.797
        c0.848,0.371,1.769-0.205,3.568-2.204c1.564-1.755,3.202-2.855,4.638-3.128c4.243-0.793,1.761-3.591-2.744-3.084
        c-1.769,0.199-3.48-0.064-4.803-0.753c-1.741-0.901-2.118-1.546-2.452-4.218c-0.218-1.732-0.568-3.897-0.772-4.806
        c-0.804-3.644-0.441-5.501,1.334-6.797c0.953-0.701,1.745-1.718,1.745-2.262c0-0.588,0.469-0.895,1.154-0.753
        c0.905,0.179,1.1,0.739,0.901,2.538c-0.145,1.265-0.29,4.489-0.316,7.175c-0.052,4.3,0.117,5.025,1.435,6.095
        c1.967,1.596,7.727,2.68,11.043,2.076l2.646-0.486l-1.823-1.586c-0.999-0.881-1.813-2.19-1.813-2.919
        c0-0.729-0.417-1.789-0.921-2.369c-0.508-0.574-1.134-2.058-1.396-3.294c-0.455-2.156-0.407-2.224,1.207-1.819
        c1.463,0.365,1.705,0.189,1.89-1.391l0.206-1.819l1.483,1.61c1.207,1.299,1.489,1.397,1.489,0.486c0-0.614-0.326-1.12-0.733-1.12
        c-0.431,0-0.612-0.691-0.421-1.66c0.169-0.911,0.081-1.66-0.201-1.66c-0.286,0-0.703-1.265-0.935-2.817
        c-0.85-5.613-1.106-6.328-2.375-6.665c-1.813-0.476-1.648-2.443,0.204-2.471c1.445-0.024,1.447-0.044,0.159-0.769
        c-0.721-0.414-1.541-1.08-1.803-1.474c-0.334-0.5-0.488-0.506-0.498-0.014c-0.01,0.389-1.916,1.09-4.237,1.552
        c-4.455,0.891-5.885,0.584-7.723-1.668c-0.868-1.05-0.76-1.11,1.318-0.701c1.566,0.317,2.744,0.132,3.864-0.604
        c0.959-0.632,2.239-0.901,3.198-0.658c0.945,0.239,1.59,0.108,1.59-0.311c0-0.472,0.993-0.57,2.879-0.287
        c2.291,0.341,2.96,0.219,3.286-0.618c0.498-1.313,2.466-1.337,6.554-0.092c3.048,0.935,3.141,0.919,3.141-0.432
        c0-0.763,0.518-1.775,1.157-2.268c1.052-0.803,0.999-0.885-0.621-0.905c-2.112-0.024-2.589-0.608-2.079-2.564
        c0.304-1.162,0.882-1.451,3.105-1.488c1.503-0.034,2.361-0.205,1.91-0.389c-0.459-0.185-0.828-0.745-0.828-1.255
        c0-2.393-6.786-4.29-9.089-2.544c-2.341,1.781-6.776,0.662-6.776-1.712c0-0.701-0.294-1.451-0.659-1.674
        c-1.187-0.735-0.699-2.321,0.727-2.321c0.83,0,1.523,0.53,1.731,1.323c0.189,0.725,0.659,1.329,1.04,1.329
        c0.383,0,1.237,0.496,1.89,1.09c1.116,1.006,1.231,1.006,1.614,0c0.226-0.594,0.828-1.09,1.338-1.09
        c1.096,0,1.215-1.06,0.204-1.694c-0.397-0.243-0.572-0.996-0.397-1.668c0.226-0.875-0.33-1.61-1.93-2.558
        c-2.259-1.337-2.952-2.67-1.422-2.73c1.348-0.054-4.91-3.078-7.429-3.604c-1.277-0.263-5.589-2.062-9.587-3.999
        c-4.004-1.937-7.945-3.716-8.763-3.959c-1.674-0.492-2.017-1.674-0.5-1.674c0.542,0,0.995-0.301,0.995-0.662
        c0-0.365,0.447-0.662,0.989-0.662c0.546,0,0.989,0.297,0.989,0.662c0,0.361,0.818,0.666,1.823,0.666
        c0.993,0.004,2.708,0.476,3.8,1.056c2.666,1.407,8.922,2.076,8.922,0.954c0-0.52,0.437-0.662,1.159-0.379
        c0.633,0.243,4.576,1.172,8.757,2.072c4.177,0.891,8.198,1.903,8.924,2.242c3.252,1.532,6.544,2.67,7.717,2.67
        c0.703,0,2.156,0.456,3.222,1.012c1.755,0.911,1.948,0.911,1.948,0c0-0.554,0.306-1.012,0.669-1.012
        c0.359,0,0.659,0.452,0.659,0.992c0,0.544,0.52,0.996,1.163,0.996c0.645,0,2.797,0.624,4.795,1.387
        c1.991,0.759,4.681,1.606,5.976,1.877c2.646,0.544,9.216,3.949,9.216,4.782c0,0.753-7.532-0.925-13.548-3.021
        c-0.727-0.257-0.206,0.223,1.15,1.066s2.476,1.911,2.476,2.369c0.006,0.452,0.316,0.827,0.685,0.827c0.369,0,1.94,1.154,3.47,2.574
        c1.535,1.421,5.916,4.445,9.736,6.719c3.82,2.277,7.872,5.025,9.016,6.105c1.308,1.241,2.239,1.698,2.517,1.245
        c0.643-1.046-0.175-2.052-1.308-1.616c-0.917,0.351-1.072,0.108-1.231-1.927c-0.036-0.456-0.52-1.178-1.056-1.6
        c-1.983-1.552-0.044-1.586,4.392-0.098c4.618,1.556,5.986,2.491,4.769,3.24c-0.403,0.257-0.228,0.598,0.427,0.857
        c0.611,0.233,1.39,0.249,1.735,0.034c0.349-0.219,1.04-0.054,1.551,0.365c0.508,0.428,1.836,0.793,2.956,0.823
        c1.477,0.048,1.987,0.351,1.862,1.124c-0.107,0.691,0.324,1.066,1.265,1.08c1.715,0.024,8.152,5.278,8.152,6.649
        c0,1.347-0.917,1.182-2.374-0.432c-0.689-0.763-1.846-1.674-2.579-2.024c-1.564-0.749,2.283,2.821,8.066,7.476
        c2.369,1.907,4.953,4.762,6.103,6.753c2.069,3.547,10.032,12.113,13.987,15.042l2.236,1.66l-2.482-3.405
        c-2.585-3.551-2.875-4.222-1.862-4.222c0.872,0,12.238,15.187,11.733,15.683c-0.232,0.229-0.872,0.04-1.425-0.422
        c-1.41-1.178-1.251-0.5,0.316,1.313c1.302,1.518,1.699,2.652,0.921,2.652c-0.222,0-1.936-1.64-3.81-3.644
        c-1.876-1.999-3.683-3.644-4.01-3.644c-0.33,0-1.187-0.52-1.904-1.158c-1.285-1.144-1.285-1.138-0.201,0.992
        c0.717,1.397,0.834,2.15,0.349,2.15c-0.411,0-0.572,0.472-0.359,1.032c0.258,0.671,0.131,0.871-0.353,0.56
        c-1.523-0.934,0.175,1.026,2.021,2.339l1.87,1.343l-0.226-1.975c-0.365-3.162,0.891-2.285,3.121,2.18
        c2.656,5.322,3.29,6.119,3.949,5.045c0.355-0.57,1.499,0.267,3.699,2.704c3.588,3.959,5.313,6.538,8.269,12.308
        c1.124,2.184,2.666,4.627,3.435,5.414c2.327,2.379,3.089,3.463,4.082,5.856c1.261,3.011,1.241,4.567-0.058,4.067
        c-0.776-0.301-0.872-0.126-0.391,0.759c0.872,1.65,3.387,13.948,3.387,16.568c0,1.221,0.645,3.618,1.435,5.332
        c1.606,3.493,2.468,10.07,1.318,10.07c-0.391,0-1.046-1.265-1.445-2.817c-1.187-4.611-1.416-5.254-1.735-4.924
        c-0.169,0.169,0.123,2.626,0.665,5.473c0.891,4.728,1.215,5.396,3.877,7.867c3.732,3.459,4.866,7.502,5.458,19.439
        c0.377,7.715,0.31,8.785-0.607,8.785c-0.566,0-1.036-0.448-1.036-0.992c0-0.55-0.447-0.996-0.983-0.996
        c-0.542,0-0.989-0.448-0.989-0.988c0-1.488-1.169-1.202-1.678,0.404c-0.542,1.718,0.242,8.548,0.979,8.548
        c0.3,0,0.731,1.275,0.963,2.825c0.306,1.999,0.844,3.031,1.832,3.483c2.934,1.353,4.449,13.563,2.924,23.512
        c-0.534,3.453-1.289,6.386-1.678,6.522c-0.387,0.124-0.707,0.662-0.707,1.168c0,0.522-0.3,0.944-0.665,0.944
        c-0.363,0-0.659-0.452-0.659-1.002c0-1.255-2.728-7.209-3.441-7.512c-0.868-0.365-0.596-1.566,0.538-2.397
        c0.941-0.691,0.868-0.911-0.665-1.913c-2.192-1.445-2.224-3.716-0.097-5.721c1.372-1.293,1.803-1.401,2.662-0.691
        c0.566,0.472,1.211,0.672,1.445,0.438c0.669-0.675-1.842-9.048-2.714-9.048c-0.455,0-1.285-2.202-1.94-5.137
        c-1.973-8.877-2.535-10.999-3.955-15.083l-1.396-3.979l-0.679,3.595c-0.655,3.419-2.031,5.161-2.585,3.26
        c-0.139-0.486-0.602-2.156-1.018-3.702c-0.421-1.552-1.013-2.817-1.312-2.817c-0.31,0-1.694-1.046-3.083-2.321
        c-1.386-1.285-2.69-2.321-2.889-2.311c-0.699,0.02-4.664,9.423-4.664,11.047c0,0.891-0.417,3.017-0.921,4.732
        c-1.096,3.712-2.507,11.768-2.44,13.942c0.026,0.853-0.669,3.041-1.541,4.874c-1.467,3.08-1.523,3.499-0.643,5.591
        c0.514,1.249,0.973,3.678,1.009,5.404c0.081,3.746,1.018,7.245,2.136,7.938c1.654,1.022,3.719,4.748,3.719,6.709
        c0,2.521-1.179,5.199-2.517,5.711c-1.348,0.52-1.997-0.648-2.523-4.501c-0.475-3.517-1.318-3.395-2.529,0.371
        c-0.534,1.644-1.072,2.16-2.293,2.16c-1.265,0-1.987-0.753-3.474-3.648c-1.034-1.999-2.172-3.746-2.539-3.862
        c-0.369-0.126-1.396-1.765-2.287-3.648c-0.891-1.881-2.347-4.192-3.218-5.131c-0.872-0.935-1.789-2.355-2.045-3.148
        c-0.252-0.791-0.76-1.445-1.14-1.445c-0.375,0-0.532-0.408-0.338-0.915c0.195-0.506-0.365-1.981-1.253-3.28
        c-0.88-1.299-1.594-2.662-1.594-3.027c0-0.371-1.082-0.526-2.502-0.357c-1.678,0.205-3.339-0.129-5.088-1.032
        c-1.435-0.733-2.996-1.337-3.46-1.337c-0.465,0-0.854-0.424-0.854-0.94c0-0.52-0.911-1.142-2.027-1.385
        c-1.116-0.249-2.186-0.875-2.384-1.397c-0.204-0.52-0.959-1.275-1.688-1.658c-1.04-0.554-1.705-0.444-3.063,0.548
        c-0.953,0.691-2.785,1.684-4.052,2.19c-1.275,0.522-2.893,1.468-3.605,2.136c-0.717,0.656-1.604,1.08-1.981,0.944
        c-0.383-0.132-2.031,0.149-3.661,0.642c-3.703,1.12-7.419,1.158-8.464,0.112c-1.163-1.162-1.05,1.032,0.175,3.401
        c1.116,2.17,2.482,2.855,4.592,2.325c0.915-0.233,2.438,0.189,3.975,1.1c2.321,1.367,2.462,1.628,2.069,3.854
        c-0.226,1.313-0.582,3.503-0.788,4.874c-0.228,1.508-0.737,2.485-1.298,2.485c-0.621,0-0.927,0.807-0.927,2.497
        c0,1.771-0.373,2.728-1.318,3.322c-0.727,0.454-1.328,1.451-1.328,2.204c0,0.837-0.534,1.528-1.352,1.741
        c-0.82,0.213-1.503,1.09-1.725,2.202c-0.228,1.154-0.907,1.985-1.779,2.214c-2.2,0.564-6.262,4.246-6.494,5.89
        c-0.129,0.921-1.463,2.301-3.514,3.648c-1.819,1.198-4.012,2.827-4.866,3.624c-1.977,1.833-8.104,5.808-8.958,5.808
        c-0.359,0-1.453,0.773-2.44,1.722c-1.09,1.054-2.631,1.761-3.949,1.823c-1.94,0.094-2.317-0.205-3.661-2.879
        c-1.87-3.736-2.351-5.131-2.579-7.564c-0.125-1.349-1.197-2.861-3.514-4.977c-1.832-1.678-3.5-3.658-3.713-4.421
        c-0.208-0.759-1.348-1.795-2.521-2.321c-1.664-0.733-2.347-1.61-3.049-3.925c-1.523-5.007-2.859-7.307-4.517-7.721
        c-0.858-0.223-2.007-1.255-2.549-2.309c-0.546-1.05-1.241-1.913-1.555-1.913c-0.31,0-0.752-0.672-0.975-1.488
        c-0.707-2.548-4.604-6.587-5.885-6.095c-0.621,0.237-1.128,0.885-1.128,1.441c0,1.275,3.427,7.317,5.273,9.301
        c0.77,0.821,1.235,1.765,1.032,2.096c-0.484,0.789,0.278,2.704,1.082,2.704c1.856,0,4.241,4.047,4.876,8.289
        c0.349,2.361,0.858,3.236,2.365,4.131c1.056,0.626,2.569,2.491,3.349,4.138c0.786,1.644,1.751,3.22,2.142,3.483
        c0.475,0.331,0.447,0.492-0.107,0.496c-0.441,0.006-0.629,0.462-0.421,1.008c0.504,1.307,1.56,1.275,1.56-0.048
        c0-0.697,0.484-0.972,1.483-0.827c0.979,0.135,1.487,0.666,1.487,1.54c0,0.817,1.066,2.038,2.797,3.206
        c4.187,2.802,6.514,5.204,7.018,7.219c0.721,2.939,2.617,3.487,6.246,1.839c1.711-0.779,3.554-1.7,4.096-2.034
        c0.542-0.341,1.439-0.803,1.977-1.022c4.298-1.718,8.36-3.86,8.797-4.637c0.29-0.51,1.112-0.928,1.819-0.928
        c0.963,0,1.289,0.456,1.289,1.853c0,1.022,0.369,2.238,0.824,2.696c0.663,0.671,0.606,0.962-0.306,1.478
        c-0.621,0.351-0.969,1.05-0.776,1.556c0.191,0.502-0.304,2.186-1.1,3.752c-0.79,1.556-2.162,4.742-3.03,7.083
        c-2.492,6.639-5.69,11.027-14.36,19.686c-11.982,11.983-18.289,19.585-16.248,19.585c1.032,0,0.699,2.538-0.365,2.774
        c-0.864,0.185-0.872,0.438-0.058,2.004c1.062,2.042,1.018,3.27-0.169,4.708c-1.116,1.343-0.326,4.232,1.265,4.641
        c1.134,0.301,1.257,0.94,1.163,6.197l-0.107,5.866l-2.724,2.646c-1.545,1.508-4.207,3.182-6.137,3.871
        c-1.88,0.662-3.784,1.654-4.237,2.196c-0.455,0.544-1.967,1.576-3.377,2.295c-2.811,1.451-3.671,2.805-2.585,4.115
        c0.84,1.022,0.268,5.467-0.814,6.328c-0.407,0.317-2.263,1.08-4.12,1.684c-2.841,0.934-3.562,1.518-4.517,3.628
        c-1.134,2.531-1.352,2.696-10.493,7.54c-5.599,2.973-9.284,3.688-20.606,4.015C241.883,436.837,236.304,436.843,235.305,436.677z
         M287.155,391.451c-0.548-1.391-1.308,2.399-0.854,4.252c0.256,1.022,0.437,0.817,0.798-0.934
        C287.359,393.523,287.381,392.031,287.155,391.451z M273.15,382.188c0-0.321-0.615-0.749-1.362-0.944
        c-1.116-0.291-1.217-0.185-0.578,0.584C272.084,382.885,273.15,383.082,273.15,382.188z M282.68,366.865
        c1.354,0,3.228-2.501,2.772-3.696c-0.31-0.817-0.872-0.966-2.224-0.632c-0.995,0.243-1.916,0.725-2.027,1.06
        c-0.125,0.341-0.611,0.614-1.092,0.614c-0.469,0-0.983,0.891-1.138,1.971c-0.238,1.58-0.036,1.989,1.08,2.15
        c0.752,0.108,1.463-0.175,1.58-0.632C281.747,367.24,282.225,366.865,282.68,366.865z M443.001,278.436
        c-0.629-0.584-0.723-0.476-0.387,0.462c0.232,0.666,0.465,1.716,0.514,2.319c0.058,0.61,0.226,0.398,0.387-0.46
        C443.68,279.895,443.442,278.851,443.001,278.436z M442.376,276.354c0-1.269-0.411-1.269-0.895,0
        c-0.212,0.55-0.103,0.998,0.256,0.998C442.09,277.352,442.376,276.904,442.376,276.354z M339.264,271.471
        c0.01-0.935,0.103-0.948,0.629-0.098c0.83,1.313,1.459,0.61,3.965-4.465c1.124-2.285,2.337-4.144,2.686-4.144
        c0.349,0,0.635-0.371,0.621-0.827c-0.014-0.46-0.77,0.03-1.695,1.08c-2.108,2.399-6.311,3.07-9.369,1.484
        c-1.13-0.584-2.512-0.885-3.069-0.672c-0.989,0.375-5.68-3.862-5.68-5.133c0-0.315-0.314-0.574-0.703-0.574
        c-0.389,0-0.514-0.295-0.29-0.661c0.222-0.365,0.091-0.662-0.296-0.662c-0.381,0-0.707,0.668-0.711,1.488
        c-0.01,1.205-0.131,1.303-0.649,0.496c-0.552-0.857-0.645-0.847-0.655,0.114c-0.004,0.608-0.377,1.269-0.834,1.469
        c-0.566,0.243-0.359,0.705,0.665,1.458c0.814,0.604,1.483,1.502,1.483,1.995c0,0.5,0.417,0.729,0.945,0.526
        c0.558-0.219,1.416,0.389,2.138,1.512c0.659,1.032,1.642,2.273,2.194,2.76c0.548,0.48,0.679,0.719,0.288,0.52
        c-0.393-0.189-0.723,0.036-0.723,0.512c0,0.466,0.427,0.851,0.937,0.851c0.629,0,0.838-0.52,0.643-1.56
        c-0.256-1.339-0.097-1.498,1.102-1.134c1.787,0.544,1.672,0.408,2.359,2.792c0.403,1.421,0.34,2.14-0.189,2.369
        c-0.542,0.223-0.5,0.506,0.165,0.966C336.421,274.754,339.244,273.033,339.264,271.471z M238.116,261.436
        c0.29-2.598,0.621-3.128,2.643-4.14c3-1.498,5.636-1.472,7.179,0.078c0.679,0.681,2.384,1.455,3.806,1.718
        c1.41,0.267,2.863,0.719,3.228,1.006c0.363,0.291,1.699,0.691,2.976,0.901c1.271,0.205,3.804,0.652,5.617,0.996
        c2.827,0.526,3.574,0.438,5.077-0.636c1.842-1.319,5.148-1.634,9.17-0.901c3.044,0.56,3.451,0.02,5.196-7.018
        c1.719-6.936,1.298-10.756-1.231-11.116c-0.901-0.126-1.793,0.199-2.122,0.779c-0.854,1.522-4.388,2.086-5.726,0.915
        c-1.755-1.546-4.082-2.068-4.082-0.919c0,1.907-3.47,2.365-5.158,0.675c-1.018-1.022-1.124-0.992-1.457,0.448
        c-0.365,1.572-1.977,2.68-1.977,1.367c0-0.398-0.617-1.343-1.372-2.096c-0.75-0.753-1.197-1.819-0.993-2.369
        c0.282-0.735,0.048-0.881-0.941-0.56c-0.941,0.301-1.314,0.112-1.314-0.662c0-0.588,0.296-0.895,0.659-0.671
        c0.359,0.223,0.659,0.098,0.659-0.291c0-0.389-0.455-0.705-1.022-0.705c-0.794,0-0.985-0.666-0.87-2.973
        c0.087-1.634-0.048-3.176-0.3-3.425c-0.256-0.257-0.459-0.108-0.459,0.317s-0.447,0.769-0.985,0.769
        c-0.542,0-0.989-0.442-0.989-0.992c0-0.54,0.296-0.992,0.659-0.992c0.365,0,0.659-0.496,0.659-1.1c0-0.875-0.252-0.793-1.298,0.414
        c-0.727,0.827-2.234,1.698-3.369,1.931l-2.061,0.422l1.715,1.853c0.969,1.05,2.045,1.65,2.478,1.387
        c0.417-0.263,0.586-0.189,0.373,0.151c-0.212,0.341,0.814,1.927,2.277,3.523c2.283,2.477,2.511,2.977,1.59,3.493
        c-0.592,0.327-0.901,0.881-0.693,1.221c0.212,0.341,0.107,0.624-0.242,0.624c-0.349,0-0.804-0.442-1.009-0.982
        c-0.212-0.56-0.814-0.813-1.392-0.588c-0.721,0.277-1.018-0.024-1.018-1.026c0-1.702-1.88-2.612-2.7-1.309
        c-0.316,0.51-0.586,1.745-0.596,2.748c0,1.002-0.306,1.819-0.669,1.819c-0.359,0-0.659-0.233-0.659-0.52
        c0-0.283-0.891-0.857-1.977-1.265c-1.338-0.506-1.987-1.205-1.987-2.136c0-0.763-0.427-1.387-0.951-1.387
        c-1.376,0-2.011-1.377-0.951-2.052c0.663-0.414,0.689-0.58,0.087-0.584c-0.455-0.004-0.824-0.594-0.824-1.299
        c0-0.709-0.306-1.474-0.673-1.702c-1.251-0.779-2.593-5.005-2.206-6.952c0.31-1.528,0.014-2.268-1.41-3.591
        c-0.979-0.915-2.801-1.999-4.038-2.413c-1.237-0.404-2.249-1.06-2.249-1.445c0-0.379-0.669-1.347-1.483-2.156
        c-2.458-2.393-3.81-4.29-3.81-5.336c0-1.508-1.294-1.168-1.94,0.51c-0.441,1.154-0.212,1.873,1.018,3.186
        c0.868,0.934,1.58,2.164,1.58,2.73c0,1.6,2.589,4.529,4.018,4.529c0.699,0,1.271,0.395,1.271,0.867c0,0.482,1.348,1.815,2.98,2.977
        c3.016,2.136,3.441,3.007,2.331,4.772c-0.524,0.837-0.834,0.753-2.011-0.516c-0.766-0.823-1.695-1.309-2.069-1.076
        c-0.461,0.283-0.447,0.652,0.04,1.138c0.393,0.398,0.723,1.231,0.723,1.849c0,1.566-3.345,5.244-4.775,5.244
        c-0.868,0-1.173,0.52-1.173,1.991c0,2.204-1.245,2.632-2.879,0.992c-0.548-0.55-1.193-0.992-1.435-0.992
        c-1.009,0-4.28-2.811-4.28-3.682c0-1.178,3.171-2.024,4.092-1.1c0.828,0.827,5.283,0.239,5.996-0.793
        c0.8-1.154-0.087-3.696-1.827-5.258c-3.582-3.206-5.085-4.421-5.501-4.437c-0.248-0.01-1.318-1.202-2.384-2.652
        c-1.066-1.455-2.331-2.636-2.807-2.636s-0.868-0.301-0.868-0.666c0-0.365,0.316-0.662,0.713-0.662c0.959,0,0.034-2.782-1.241-3.716
        c-0.76-0.554-1.513-0.486-3.044,0.277c-3.897,1.941-4.344,2.116-5.235,2.116c-0.494,0-1.846-0.476-3.01-1.056
        c-2.583-1.293-4.038-0.831-4.038,1.289c0,1.911-0.794,2.616-4.294,3.828c-3.484,1.202-7.076,4.431-6.597,5.926
        c0.393,1.245-3.353,5.521-4.314,4.928c-0.306-0.189-0.999,0.108-1.551,0.662c-1.14,1.144-2.932,1.275-5.279,0.375
        c-2.182-0.831-4.411-0.161-4.411,1.329c0,1.474,0.639,1.911,3.083,2.096c1.032,0.078,2.243,0.5,2.694,0.935
        c0.542,0.536,1.416,0.608,2.643,0.229c7.227-2.242,8.837-2.315,21.327-0.895c1.991,0.229,5.212,0.385,7.135,0.345
        c2.448-0.048,3.605,0.213,3.854,0.867c0.199,0.52,0.78,0.779,1.298,0.58c0.625-0.243,0.935,0.102,0.935,1.056
        c0,0.779-0.437,1.58-0.965,1.781c-0.756,0.301-0.804,0.675-0.228,1.805c1.948,3.8,1.973,3.925,1.086,4.495
        c-0.49,0.311-1.372,0.564-1.967,0.574c-0.596,0-1.265,0.476-1.489,1.04c-0.222,0.594-0.111,0.857,0.272,0.614
        c0.359-0.223,1.658,0.662,2.879,1.961c1.231,1.307,2.865,2.365,3.665,2.365c2.637,0,7.328,2.572,7.328,4.013
        c0,0.837,0.673,1.582,1.813,2.024c1.003,0.385,3.161,1.391,4.795,2.234C236.973,265.21,237.719,264.987,238.116,261.436z
         M251.132,249.021c-1.048-0.155-1.741-0.624-1.596-1.06c0.296-0.895,0.393-0.901,4.61-0.179
        C259.977,248.792,257.184,249.941,251.132,249.021z M274.468,248.798c0-0.958,1.731-2.642,2.216-2.156
        c0.212,0.213,1.138-0.108,2.065-0.715c1.719-1.134,2.287-0.624,0.876,0.789c-0.437,0.438-0.528,0.793-0.204,0.793
        c0.32,0,0.016,0.442-0.693,0.978C277.228,249.624,274.468,249.824,274.468,248.798z M259.026,247.178
        c0.494-1.269,0.907-1.269,0.907,0c0,0.55-0.29,0.996-0.639,0.996C258.939,248.174,258.82,247.732,259.026,247.178z M223.57,244.856
        c0-0.847,0.471-0.847,0.993,0c0.222,0.371,0.091,0.662-0.296,0.662C223.885,245.518,223.57,245.231,223.57,244.856z
         M209.611,232.477c-0.044-0.307-0.02-0.841,0.058-1.205c0.077-0.365,0.131-1.893,0.131-3.405c0-2.126,0.242-2.714,1.09-2.646
        c0.854,0.068,1.042-0.432,0.887-2.359c-0.151-1.907,0.101-2.592,1.177-3.172c1.193-0.648,1.358-0.55,1.318,0.779
        c-0.024,0.837-0.282,2.116-0.568,2.835c-0.296,0.729-0.282,1.991,0.02,2.801c0.417,1.12-0.222,4.961-0.985,5.906
        C212.348,232.491,209.668,232.885,209.611,232.477z M194.838,228.322c-0.582-0.944,0.161-2.024,1.386-2.024
        c0.572,0,0.911,0.462,0.78,1.104C196.751,228.735,195.433,229.291,194.838,228.322z M198.453,226.999
        c0-0.385,0.3-0.701,0.663-0.701c0.844,0,0.844,0.466,0,0.992C198.749,227.515,198.453,227.384,198.453,226.999z M253.394,240.03
        c-0.542-0.54-0.731-0.466-0.731,0.277c0,1.323,0.885,2.214,1.211,1.221C254.015,241.11,253.797,240.435,253.394,240.03z
         M326.905,230.769c0.969-0.715,1.018-1.124,0.31-2.987c-0.451-1.182-1.046-2.15-1.332-2.15c-0.288,0-0.52-0.379-0.52-0.841
        c0-0.466-0.596-1.955-1.322-3.314c-0.727-1.359-1.324-2.885-1.324-3.395c0-0.5-0.451-1.285-0.989-1.741
        c-0.546-0.452-0.993-1.532-0.993-2.399c0-1.144-0.369-1.572-1.354-1.572c-0.737,0-2.095-0.749-2.996-1.66
        c-0.915-0.915-1.924-1.66-2.239-1.66c-0.32,0-1.128-0.691-1.787-1.532c-1.618-2.052-3.238-2.588-4.227-1.387
        c-0.602,0.719-0.625,1.357-0.107,2.447c0.387,0.803,0.882,2.208,1.09,3.122c0.204,0.911,0.598,1.965,0.878,2.335
        c1.036,1.407,7.65,6.284,8.515,6.284c0.5,0,0.907,0.448,0.907,0.992s-0.461,0.996-1.028,0.996c-0.83,0-0.979,0.725-0.824,3.81
        c0.179,3.503,0.334,3.838,1.852,4.037c0.911,0.122,1.94,0.5,2.277,0.827C322.607,231.869,325.591,231.741,326.905,230.769z
         M263.233,228.95c0-0.365-0.469-0.666-1.028-0.666c-0.566,0-0.854,0.301-0.623,0.666
        C262.109,229.807,263.233,229.807,263.233,228.95z M271.677,224.712c2.637-1.694,8.743-2.865,8.743-1.678
        c0,0.379,0.31,0.5,0.689,0.263c0.379-0.237,1.13-0.068,1.654,0.375c0.542,0.448,2.879,0.797,5.297,0.797
        c3.588,0,4.6-0.253,5.918-1.498c1.981-1.863,1.396-3.264-2.138-5.127c-1.376-0.725-4.134-2.184-6.137-3.26
        c-3.897-2.082-5.273-2.106-8.037-0.141c-2.142,1.528-3.858,1.61-3.858,0.195c0-0.584-0.615-1.221-1.376-1.421
        c-0.941-0.249-1.275-0.745-1.05-1.596c0.226-0.871-0.036-1.235-0.882-1.235c-0.665,0-1.358-0.375-1.547-0.827
        c-0.441-1.08-3.038,2.034-3.057,3.652c-0.016,0.642-0.617,1.678-1.348,2.301c-0.727,0.632-1.318,1.955-1.318,2.977
        c0,1.012-0.272,1.843-0.588,1.843c-1.116,0-1.352,2.953-0.369,4.465C263.67,226.916,268.304,226.878,271.677,224.712z
         M283.271,209.473c0.195-0.506,0.04-1.225-0.34-1.606c-0.882-0.891-3.834,0.365-3.834,1.63
        C279.098,210.688,282.817,210.664,283.271,209.473z M235.101,181.52c1.561-1.192,3.786-1.259,4.886-0.151
        c0.568,0.57,0.965,0.604,1.289,0.118c0.262-0.389,0.955-0.885,1.557-1.11c0.693-0.257,1.207-1.435,1.425-3.264
        c0.189-1.576,0.872-4.421,1.523-6.328c0.989-2.895,1.513-3.537,3.204-3.969c1.775-0.452,1.547-0.554-1.948-0.851
        c-2.313-0.195-4.076-0.068-4.237,0.317c-0.465,1.12-1.715,2.14-3.198,2.608c-1.489,0.472-2.525,2.554-1.832,3.682
        c0.455,0.725-0.77,3.395-1.904,4.15c-0.397,0.273-1.392,0.492-2.21,0.5c-1.537,0.01-1.991,0.944-0.824,1.668
        c0.993,0.618,0.786,1.654-0.334,1.654c-0.542,0-0.989-0.297-0.989-0.662c0-0.365-0.743-0.662-1.654-0.662
        c-0.911,0-1.654,0.297-1.654,0.662c0,0.365,0.447,0.662,0.989,0.662c0.548,0,0.999,0.456,0.999,0.996
        C230.181,182.833,233.381,182.823,235.101,181.52z M239.439,173.494c0-0.769,0.451-1.781,1.003-2.242
        c1.56-1.313,1.711-0.472,0.29,1.698C239.589,174.689,239.445,174.753,239.439,173.494z M227.497,175.283
        c0.776-0.492,0.8-0.891,0.141-2.146c-0.48-0.925-0.659-1.036-0.447-0.301c0.222,0.749-0.101,1.596-0.8,2.14
        C225.086,175.961,226.008,176.228,227.497,175.283z M251.097,172.914c0.572-1.494-1.028-3.192-2.132-2.268
        c-0.699,0.57-0.713,0.992-0.091,1.995C249.826,174.175,250.582,174.267,251.097,172.914z M277.115,167.986
        c0-0.901-1.167-1.488-1.584-0.807c-0.397,0.642,0.175,1.435,1.032,1.435C276.869,168.614,277.115,168.333,277.115,167.986z
         M257.523,164.962c0.484-1.269,0.145-1.269-0.901,0c-0.478,0.574-0.538,0.992-0.149,0.992
        C256.842,165.958,257.311,165.512,257.523,164.962z M244.896,161.726c0.548-0.807,0.383-7.701-0.185-7.701
        c-0.199,0-1.265,0.837-2.374,1.853c-2.617,2.399-3.403,5.248-1.769,6.48C241.815,163.298,244.049,162.977,244.896,161.726z
         M265.216,162.334c0-0.847-1.866-2.349-2.934-2.349c-0.673,0-0.391,1.712,0.423,2.521
        C263.801,163.609,265.216,163.507,265.216,162.334z M249.066,151.628c2.505-1.921,2.972-3.571,0.993-3.571
        c-1.294,0-3.353,1.624-3.353,2.646c0,0.307-0.179,1.036-0.397,1.606C245.736,153.802,246.459,153.622,249.066,151.628z
         M269.515,150.042c-0.222-0.361-0.911-0.642-1.527-0.618c-0.917,0.044-0.878,0.151,0.204,0.618
        C269.961,150.811,269.981,150.811,269.515,150.042z M272.816,146.465c0-1.231-0.383-1.387-3.345-1.387
        c-2.996,0-3.322,0.135-3.093,1.323c0.206,1.09,0.808,1.343,3.345,1.397C272.449,147.852,272.816,147.696,272.816,146.465z
         M402.339,134.207c0.201-0.317-0.058-0.934-0.566-1.357c-0.762-0.632-0.872-0.526-0.576,0.584
        C401.583,134.936,401.801,135.078,402.339,134.207z M296.369,114.724c-0.649-0.652-0.731-0.57-0.369,0.371
        c0.248,0.658,0.617,1.022,0.82,0.817C297.028,115.712,296.819,115.172,296.369,114.724z M373.631,96.084
        c0-0.132-0.518-0.658-1.154-1.158c-1.046-0.823-1.07-0.797-0.246,0.253C373.087,96.277,373.631,96.634,373.631,96.084z
         M326.032,68.846c0-0.5-8.176-2.973-8.541-2.578c-0.401,0.438-0.185,0.54,4.576,2.228C324.71,69.436,326.032,69.551,326.032,68.846
        z M312.605,416.075c-0.145-0.263-0.304-1.694-0.349-3.182c-0.071-2.208,0.288-3.055,1.926-4.631
        c1.749-1.674,1.952-2.238,1.594-4.36c-0.475-2.786,1.076-6.541,2.686-6.541c1.838,0,6.951-2.817,8.759-4.816
        c7.284-8.104,7.338-8.153,8.303-7.111c1.288,1.367,1.842,6.376,0.8,7.249c-0.453,0.375-1.018,0.486-1.257,0.253
        c-0.242-0.243-0.437,0.361-0.437,1.333c0,0.976-0.3,1.771-0.663,1.771c-0.365,0-0.659,0.291-0.659,0.652
        c0,0.769-4.421,7.938-8.265,13.41c-2.011,2.869-3.349,4.043-5.575,4.894C316.111,416.288,312.994,416.776,312.605,416.075z
         M347.849,399.389c0-0.389,0.294-0.705,0.659-0.705c0.848,0,0.848,0.47,0,0.992C348.145,399.901,347.849,399.778,347.849,399.389z
         M191.177,358.283c0-0.389,0.306-0.705,0.663-0.705c0.854,0,0.854,0.47,0,0.992C191.478,358.799,191.177,358.672,191.177,358.283z
         M80.32,352.437c-7.348-11.513-16.474-32.295-20.91-47.606c-7.058-24.401-9.704-52.274-7.119-75.095
        c1.076-9.463,2.249-10.05,2.069-1.026c-0.326,16.689-0.204,22.751,0.484,23.582c0.403,0.482,1.076,2.963,1.497,5.507
        c0.417,2.548,1.032,5.143,1.362,5.774c0.326,0.632,0.606,2.578,0.611,4.31c0.01,1.741,0.421,4.945,0.921,7.141
        c0.504,2.19,1.1,5.467,1.332,7.297c0.737,5.848,6.165,19.069,9.675,23.594c1.013,1.323,3.218,5.276,4.886,8.795
        c1.678,3.517,3.302,6.396,3.621,6.396c0.693,0,1.207,1.245,2.424,5.838c1.348,5.065,1.173,6.538-1.076,9.345l-2.011,2.511
        l1.725,5.244c1.914,5.838,3.582,12.21,3.194,12.21C82.865,356.251,81.658,354.537,80.32,352.437z M347.184,310.504
        c1.304-0.847,2.831-0.847,2.317,0c-0.222,0.361-1.06,0.662-1.856,0.652C346.467,311.152,346.38,311.028,347.184,310.504z
         M308.845,306.135c0-1.168,1.426-0.962,1.832,0.269c0.145,0.432-0.206,0.789-0.786,0.789
        C309.319,307.191,308.845,306.708,308.845,306.135z M108.191,281.949c-0.238-0.389-0.276-0.867-0.083-1.06
        c0.471-0.476,1.759,0.361,1.759,1.138C109.872,282.878,108.729,282.824,108.191,281.949z M110.531,279.337
        c0-0.853,0.471-0.853,0.993,0c0.222,0.361,0.097,0.665-0.296,0.665C110.847,280.003,110.531,279.702,110.531,279.337z
         M107.061,275.051c-1.328-1.823-1.435-2.345-0.498-2.345c0.359,0,0.659,0.347,0.659,0.775c0,0.428,0.498,1.327,1.1,1.995
        c0.602,0.665,0.824,1.198,0.494,1.192C108.486,276.651,107.696,275.932,107.061,275.051z M431.621,255.062
        c-0.262-0.263-0.461-1.251-0.443-2.186l0.044-1.716l0.633,1.596C432.55,254.488,432.405,255.851,431.621,255.062z M138.019,251.579
        c-0.286-0.462-0.334-1.016-0.117-1.235c0.592-0.594,1.237,0.283,0.915,1.239C138.592,252.255,138.435,252.255,138.019,251.579z
         M142.601,250.427c0.951-0.944,1.876-1.566,2.065-1.387c0.518,0.52-1.914,3.116-2.913,3.116
        C141.247,252.153,141.602,251.434,142.601,250.427z M135.65,248.835c0-0.361,0.465-0.662,1.032-0.662
        c0.568,0,0.848,0.301,0.621,0.662C136.774,249.702,135.65,249.702,135.65,248.835z M140.278,233.59c0-0.847,0.471-0.847,0.993,0
        c0.222,0.365,0.091,0.662-0.29,0.662C140.594,234.252,140.278,233.955,140.278,233.59z M130.361,208.393
        c0-0.851,0.471-0.851,0.993,0c0.222,0.361,0.097,0.665-0.29,0.665C130.671,209.058,130.361,208.758,130.361,208.393z
         M126.702,203.055c-0.602-0.982-0.121-1.337,0.935-0.671c0.572,0.345,0.639,0.691,0.195,0.962
        C127.458,203.581,126.948,203.449,126.702,203.055z M61.058,197.115c0-0.911,0.151-1.285,0.334-0.827
        c0.179,0.456,0.179,1.202,0,1.66C61.207,198.404,61.058,198.036,61.058,197.115z M61.469,191.08
        c-0.49-1.285,0.828-7.219,1.61-7.219c0.538,0,0.199,2.919-0.786,6.605C61.973,191.682,61.761,191.837,61.469,191.08z
         M68.886,167.281c0-0.361,0.296-0.662,0.659-0.662s0.659,0.301,0.659,0.662c0,0.365-0.296,0.666-0.659,0.666
        S68.886,167.646,68.886,167.281z M70.864,163.609c0-0.827,2.108-4.378,2.408-4.071c0.359,0.355-1.566,4.437-2.095,4.437
        C71.009,163.969,70.864,163.808,70.864,163.609z M207.724,159.205c-0.01-0.624,0.3-1.323,0.693-1.562
        c1.157-0.725,1.328,0.04,0.3,1.401C207.865,160.17,207.744,160.184,207.724,159.205z M73.514,158.082c0-0.365,0.3-0.847,0.663-1.07
        c0.359-0.229,0.659-0.118,0.659,0.249s-0.3,0.851-0.659,1.076C73.816,158.56,73.514,158.448,73.514,158.082z M202.04,151.375
        c0-0.729,0.393-1.333,0.872-1.333c0.669,0,0.713,0.317,0.165,1.333C202.189,153.032,202.04,153.032,202.04,151.375z
         M116.722,147.23c0.077-0.456,0.359-1.201,0.645-1.66c0.33-0.53,0.141-0.831-0.514-0.831c-0.568,0-1.032-0.432-1.032-0.972
        c0-0.628,0.383-0.823,1.09-0.544c1.1,0.422,1.066-0.418-0.189-4.661c-0.252-0.837,0.064-1.313,1.022-1.562
        c0.76-0.199,1.382-0.564,1.382-0.813c0-0.243,0.534-0.486,1.201-0.53c2.011-0.155,6.746-2.457,6.514-3.172
        c-0.121-0.365-0.901-0.709-1.731-0.749c-1.759-0.092-2.797-1.445-2.313-3.007c0.189-0.608,0.034-1.303-0.343-1.536
        c-0.383-0.239-0.689,0.122-0.689,0.813c0,0.681-0.437,1.815-0.969,2.525c-1.517,2.014-1.271-0.267,0.31-2.875
        c1.819-2.983,1.668-3.887-0.743-4.374c-3.248-0.652-3.417-0.516-1.473,1.158c1.779,1.536,1.789,1.61,0.683,3.318
        c-0.625,0.958-1.58,1.741-2.112,1.741c-0.538,0-0.979,0.267-0.979,0.588s-0.606,0.745-1.348,0.938
        c-0.733,0.195-1.289,0.604-1.227,0.911c0.286,1.468-1.003,4.864-1.842,4.864c-0.524,0-0.79,0.263-0.596,0.574
        c0.195,0.317,1.173,0.442,2.182,0.291c1.678-0.267,1.739-0.205,0.683,0.658c-0.635,0.516-1.157,1.319-1.157,1.771
        c0,1.036-3.165,0.341-4.681-1.026c-0.568-0.516-1.551-0.938-2.172-0.938c-0.945,0-1.003-0.229-0.377-1.407
        c0.413-0.773,1.318-1.552,2.007-1.737c0.689-0.179,1.255-0.608,1.255-0.954c0-0.335-0.252-0.466-0.562-0.273
        c-0.31,0.189-0.901-0.389-1.308-1.289c-0.407-0.905-1.003-1.634-1.332-1.634c-0.999,0-4.048,2.69-3.887,3.429
        c0.083,0.389-0.272,0.861-0.78,1.046c-0.645,0.239-0.8,0.004-0.518-0.739c0.232-0.598,0.125-1.084-0.222-1.084
        c-0.347,0-0.639-0.496-0.639-1.104c0-1.016-0.087-1.016-1.211,0c-0.663,0.608-1.527,1.104-1.91,1.104
        c-0.387,0-2.162,1.313-3.941,2.913c-2.656,2.393-3.572,2.851-5.098,2.564c-1.479-0.283-2.192,0.034-3.484,1.562l-1.628,1.917
        l1.163-2.14c0.639-1.168,3.713-5.555,6.82-9.74c29.346-39.494,72.144-66.678,120.076-76.266c18.69-3.746,41.143-5.298,52.267-3.628
        c3.208,0.482,5.154,0.982,4.314,1.124c-0.844,0.135-1.695,0.671-1.894,1.192c-0.212,0.554-1.271,0.938-2.565,0.938
        c-2.418,0-3.645,1.046-1.793,1.532c0.969,0.257,0.937,0.317-0.189,0.379c-0.743,0.048-1.705,0.432-2.138,0.867
        c-0.538,0.536-4.967,0.841-14.177,0.962c-15.956,0.219-17.062,0.341-21.7,2.399c-1.977,0.875-5.132,1.775-7.014,1.999
        c-1.886,0.223-3.971,0.701-4.634,1.066c-0.659,0.361-2.085,0.847-3.155,1.08c-1.445,0.307-1.705,0.564-1.018,0.988
        c0.504,0.311,1.157,0.432,1.445,0.253c0.282-0.175,1.56-0.034,2.835,0.317c1.392,0.389,2.462,0.399,2.69,0.04
        c0.208-0.335,0-0.608-0.455-0.608c-0.524,0-0.602-0.229-0.212-0.608c1.13-1.094,5.245-1.036,6.84,0.084
        c1.439,1.012,1.459,1.114,0.306,1.708c-1.231,0.638-5.787,1.732-10.237,2.443c-1.803,0.297-2.515,0.779-2.797,1.921
        c-0.359,1.431-0.717,1.536-5.192,1.536c-5.152,0-11.235,1.411-10.872,2.525c0.3,0.911,3.635,1.255,4.624,0.476
        c2.694-2.14,9.428-2.564,8.656-0.54c-0.397,1.04,1.479,1.991,2.065,1.046c0.212-0.351,0.959-0.638,1.672-0.638
        c0.733,0,1.285-0.456,1.285-1.066c0-0.705,0.359-0.934,1.042-0.666c0.578,0.219,1.489,0.404,2.031,0.404
        c0.858,0,0.858,0.126-0.03,1.012c-1.61,1.616-0.683,2.73,2.017,2.413c1.654-0.195,2.243-0.048,1.93,0.466
        c-0.314,0.514,0.494,0.749,2.579,0.749s3.151,0.311,3.417,0.988c0.208,0.544,0.794,0.996,1.298,0.996
        c0.824,0,1.201,0.813,0.756,1.63c-0.091,0.165,0.421,0.729,1.134,1.249c1.116,0.817,1.187,1.192,0.518,2.666
        c-0.431,0.935-1.513,1.893-2.398,2.116l-1.616,0.406l1.425,1.435c0.79,0.789,2.079,1.488,2.869,1.562
        c0.79,0.068,2.361,0.598,3.49,1.182c1.614,0.837,2.001,1.425,1.827,2.748c-0.121,0.925-0.649,1.955-1.173,2.281
        c-0.717,0.462-0.743,0.608-0.087,0.614c0.475,0.004,0.679,0.317,0.455,0.681c-0.222,0.361,0.058,0.662,0.621,0.662
        c0.572,0,1.032,0.448,1.032,0.992c0,0.54-0.407,0.992-0.911,0.992c-1.382,0-7.024,2.636-7.024,3.284
        c0,0.317-0.669,0.442-1.489,0.297c-0.82-0.151-1.116-0.108-0.663,0.112c0.606,0.291,0.635,0.729,0.111,1.722
        c-0.393,0.729-0.887,1.158-1.096,0.948c-0.208-0.205-0.713,0.084-1.12,0.648c-0.413,0.56-1.281,1.1-1.94,1.198
        c-1.402,0.205-2.414,1.616-1.973,2.758c0.266,0.701-1.1,1.363-3.413,1.66c-0.359,0.048-1.076,0.432-1.57,0.851
        c-0.508,0.414-1.328,0.763-1.819,0.769c-1.022,0.01-6.19,4.83-6.19,5.778c0,0.335-0.635,0.418-1.41,0.175
        c-0.897-0.291-1.251-0.199-0.969,0.243c0.343,0.564-4.832,1.927-6.208,1.63c-5.72-1.211-8.013-1.293-13.723-0.51
        c-2.337,0.327-3.77,0.229-4.402-0.297c-0.727-0.604-1.473-0.554-3.31,0.213c-1.304,0.544-2.374,1.265-2.374,1.59
        c0,0.321-0.925,0.624-2.061,0.658c-1.13,0.034-4.072,1.124-6.538,2.417c-5.297,2.798-6.288,2.947-5.623,0.875
        c0.262-0.823,0.538-2.443,0.625-3.604c0.189-2.7,2.394-5.575,8.487-11.039c5.7-5.123,13.703-9.305,13.703-7.165
        c0,0.311,0.75,0.428,1.672,0.253c1.557-0.301,1.584-0.385,0.494-1.235c-1.12-0.871-1.11-0.962,0.151-1.955
        c0.727-0.574,2.132-0.929,3.127-0.783c1.328,0.189,1.92-0.078,2.2-0.968c0.228-0.729,2.666-2.291,5.952-3.838
        c6.393-2.987,8.962-5.171,8.438-7.181c-0.286-1.07,0.212-1.64,2.341-2.734c1.483-0.759,2.922-1.333,3.204-1.269
        c0.286,0.064,1.028-0.112,1.654-0.389c0.737-0.321,1.991,0.03,3.538,0.982c1.934,1.198,2.511,1.313,2.952,0.594
        c1.217-1.975-4.022-3.322-15.065-3.862c-1.964-0.102-1.88-1.498,0.228-4.009c1.275-1.522,1.453-2.034,0.699-2.034
        c-0.552,0-1.197,0.311-1.439,0.695c-0.286,0.462-1.009,0.317-2.132-0.414c-1.497-0.982-2.234-1.026-6.097-0.331
        c-2.414,0.432-5.273,1.367-6.335,2.072c-1.072,0.709-2.478,1.285-3.137,1.293c-0.659,0-1.013,0.301-0.79,0.666
        c0.683,1.104,2.986,0.739,5.158-0.807c2.253-1.61,9.947-2.544,11.134-1.353c1.201,1.205-2.565,5.677-6.446,7.657
        c-1.991,1.016-3.796,2.285-3.999,2.817c-0.202,0.532-0.786,0.968-1.294,0.968c-0.504,0-0.931,0.371-0.941,0.827
        c-0.02,0.905-5.289,3.814-6.907,3.814c-0.548,0-1.819,0.954-2.815,2.12c-4.213,4.908-4.61,5.171-7.513,5.059l-2.778-0.108
        l2.085-1.863c1.144-1.032,2.085-2.034,2.085-2.238c0-0.695-2.859,1.178-4.934,3.24c-1.15,1.138-3.208,2.413-4.576,2.821
        c-1.721,0.516-2.269,0.526-1.779,0.04c1.231-1.231,0.77-2.034-0.498-0.885c-2.021,1.833-2.259,1.235-0.649-1.644
        c0.838-1.508,2.768-3.76,4.28-5.011c1.517-1.249,3.063-3.152,3.437-4.228c0.397-1.124,1.416-2.234,2.414-2.612
        c2.23-0.851,2.303-0.841,2.303,0.355c0,1.387,1.973,2.048,2.7,0.905c0.417-0.658,0.586-0.685,0.596-0.092
        c0.004,0.452,0.334,0.827,0.743,0.827c0.417,0,0.582-0.588,0.383-1.363c-0.256-0.982,0.048-1.518,1.11-1.921
        c0.8-0.307,1.856-1.036,2.347-1.62c0.484-0.58,1.584-1.066,2.448-1.066c0.868,0,1.566-0.267,1.566-0.594
        c0-0.341-1.022-0.345-2.478-0.01c-1.358,0.327-3.723,0.414-5.235,0.195c-2.374-0.331-3.188-0.092-5.831,1.737
        c-1.692,1.162-3.272,1.917-3.518,1.668c-0.252-0.249,0.087-0.841,0.743-1.329c0.81-0.594,0.955-1.026,0.455-1.337
        c-1.177-0.729,1.298-3.084,2.754-2.616c1.783,0.57,2.734-0.263,1.6-1.397c-0.524-0.526-1.231-0.954-1.574-0.954
        c-0.349,0-0.999-0.448-1.449-0.992c-1.036-1.255-4.445-1.269-6.611-0.03c-0.911,0.52-2.666,1.411-3.901,1.985
        c-1.241,0.57-3.504,2.16-5.041,3.523c-1.541,1.357-4.042,3.479-5.569,4.708c-1.527,1.229-3.093,2.929-3.474,3.77
        c-0.381,0.841-1.61,1.911-2.724,2.379c-1.116,0.462-2.932,1.634-4.042,2.598c-1.116,0.968-2.875,2.204-3.921,2.754
        c-1.523,0.783-1.692,1.066-0.828,1.391c0.592,0.233,1.08,0.126,1.08-0.229c0-0.345,0.31-0.642,0.699-0.642s1.793-0.745,3.137-1.664
        c1.348-0.915,2.545-1.357,2.666-0.992c0.592,1.775,7.008-0.321,9.534-3.128c0.635-0.705,1.827-1.225,2.643-1.154
        c0.82,0.074,2.085-0.189,2.807-0.584c1.541-0.837,5.714-2.393,6.46-2.407c0.282-0.004,0.058,0.691-0.498,1.542
        c-0.552,0.847-0.854,1.702-0.655,1.903c0.195,0.195-0.699,1.279-1.977,2.413c-1.288,1.128-2.341,2.359-2.341,2.73
        c0,0.365-1.11,1.138-2.468,1.712c-2.617,1.094-5.462,3.429-5.462,4.489c0,0.355,1.328,0.482,3.121,0.277
        c2.66-0.301,2.952-0.229,1.964,0.5c-1.14,0.837-6.383,5.565-11.08,10.003c-1.304,1.225-2.758,3.425-3.242,4.88
        c-0.48,1.465-1.09,2.521-1.352,2.359c-0.272-0.165-0.848,0.564-1.285,1.624c-1.173,2.851-4.94,6.115-5.928,5.127
        c-0.596-0.588-0.679-0.516-0.369,0.311c0.306,0.783-0.141,1.275-1.61,1.785c-1.116,0.389-2.021,1.172-2.021,1.737
        c0,0.57-0.359,1.026-0.794,1.026c-0.586,0-0.602,0.195-0.048,0.749c0.941,0.944,0.349,2.467-1.701,4.378
        c-0.891,0.827-1.382,1.508-1.096,1.508c0.286,0-0.282,0.745-1.261,1.66C117.569,148.213,116.527,148.523,116.722,147.23z
         M109.499,119.215c0.316-1.329,0.248-1.765-0.195-1.329c-0.359,0.361-0.872,1.556-1.124,2.646
        c-0.316,1.333-0.242,1.771,0.195,1.333C108.739,121.501,109.247,120.309,109.499,119.215z M107.736,117.848
        c0.087-0.978-0.131-1.522-0.518-1.289c-0.766,0.482-0.891,2.987-0.135,2.987C107.367,119.54,107.662,118.781,107.736,117.848z
         M114.826,111.592c1.406-1.556,0.252-1.815-1.275-0.287c-1.167,1.168-1.298,1.61-0.48,1.61
        C113.382,112.915,114.166,112.317,114.826,111.592z M118.796,105.618c0.518-0.841-0.353-0.841-1.654,0
        c-0.858,0.55-0.838,0.648,0.125,0.658C117.885,106.28,118.568,105.987,118.796,105.618z M125.229,101.498
        c1.14-1.066,1.735-2.136,1.449-2.592c-0.32-0.516-0.199-0.608,0.363-0.257c0.568,0.345,0.746,0.219,0.542-0.399
        c-0.393-1.178-1.342-0.992-2.182,0.432c-0.359,0.618-1.473,1.961-2.478,2.983c-0.999,1.026-1.819,2.224-1.819,2.66
        C121.107,105.186,121.762,104.741,125.229,101.498z M183.577,87.056c-0.228-0.365-0.707-0.662-1.076-0.662
        c-0.359,0-0.475,0.297-0.252,0.662c0.222,0.365,0.707,0.666,1.072,0.666C183.686,87.721,183.801,87.42,183.577,87.056z
         M210.899,79.111c0.951,0.01,0.965,0.098,0.107,0.652c-0.864,0.56-0.854,0.648,0.091,0.652c0.582,0.01,1.42-0.408,1.852-0.929
        c0.611-0.745,0.514-1.016-0.494-1.343c-1.739-0.554-3.441,0.209-3.379,1.522c0.034,0.695,0.175,0.783,0.383,0.263
        C209.65,79.466,210.294,79.106,210.899,79.111z M191.347,73.132c0.558,0,1.183-0.448,1.392-0.992
        c0.514-1.333-0.141-1.249-2.754,0.341c-1.288,0.789-1.987,1.64-1.715,2.086c0.326,0.52,0.713,0.418,1.261-0.341
        C189.975,73.624,190.789,73.132,191.347,73.132z M198.776,67.168c0.228-0.365,0.117-0.666-0.252-0.666
        c-0.363,0-0.844,0.301-1.072,0.666c-0.228,0.361-0.107,0.662,0.256,0.662C198.072,67.83,198.554,67.529,198.776,67.168z
         M204.399,61.86c0-0.365-0.447-0.666-0.989-0.666c-0.542,0-0.989,0.301-0.989,0.666c0,0.361,0.447,0.662,0.989,0.662
        C203.952,62.522,204.399,62.221,204.399,61.86z M188.54,139.748c0-0.56-0.451-1.188-0.993-1.397c-1.285-0.496-1.285-1.562,0-1.562
        c0.542,0,0.993-0.452,0.993-0.992c0-0.55-0.316-0.996-0.707-0.996c-0.383,0-0.518-0.283-0.306-0.632s0.878-0.448,1.473-0.219
        c0.848,0.327,0.979,0.151,0.621-0.803c-0.518-1.347,0.49-2.295,2.462-2.311c0.911-0.01,1.14,0.331,0.887,1.313
        c-0.266,1.022-0.02,1.333,1.08,1.337c0.78,0,2.565,0.311,3.941,0.701c2.313,0.648,2.502,0.875,2.317,2.807
        c-0.266,2.748-2.321,3.76-7.644,3.776C189.394,140.764,188.54,140.551,188.54,139.748z M279.539,134.352
        c-0.911-0.911-0.391-2.208,0.882-2.208c0.882,0,1.324,0.442,1.324,1.329C281.747,134.747,280.45,135.263,279.539,134.352z
         M243.491,115.74c-0.413-0.779-0.747-1.877-0.747-2.451c0-0.564-0.3-1.036-0.663-1.036c-0.776,0-0.868-2.622-0.121-3.8
        c0.3-0.472,1.406-0.701,2.633-0.544c1.163,0.151,2.118,0.004,2.118-0.311c0-0.618,4.445-0.389,5.094,0.263
        c0.649,0.642-1.285,2.487-2.226,2.12c-1.217-0.466-1.12,0.925,0.169,2.345c1.231,1.367,0.76,2.538-0.969,2.403
        c-0.824-0.064-1.12-0.476-0.911-1.285c0.534-2.034-0.756-1.299-2.226,1.265C244.297,117.059,244.219,117.099,243.491,115.74z
         M154.644,106.858c0.447-0.452,0.975-0.652,1.177-0.448c0.203,0.203-0.155,0.574-0.814,0.823
        C154.072,107.599,154.001,107.521,154.644,106.858z M291.648,105.935c-1.215-1.465-0.524-1.634,0.84-0.205
        c0.633,0.671,0.895,1.215,0.576,1.215C292.739,106.945,292.102,106.493,291.648,105.935z M262.119,105.861
        c-0.546-0.223-0.455-0.666,0.33-1.459c0.782-0.793,1.344-0.934,1.87-0.456c0.417,0.375,0.602,0.944,0.407,1.265
        c-0.199,0.321,0.058,0.442,0.562,0.267c0.582-0.199,0.844-1.066,0.713-2.403c-0.204-2.024-0.155-2.068,1.594-1.401
        c1.304,0.5,1.94,0.482,2.275-0.074c0.334-0.55,0.596-0.56,0.921-0.03c0.252,0.404,0.121,0.735-0.288,0.735s-0.556,0.301-0.33,0.666
        c0.228,0.361,0.02,0.666-0.455,0.671c-0.629,0.01-0.596,0.185,0.123,0.652c0.808,0.526,0.721,0.648-0.447,0.658
        c-0.782,0.004-1.576-0.365-1.761-0.823c-0.212-0.516-0.353-0.422-0.387,0.263C267.176,105.987,264.387,106.786,262.119,105.861z
         M141.219,99.071c0.199-0.321,1.032-0.753,1.856-0.962c1.445-0.361,1.453-0.335,0.218,0.584
        C141.868,99.756,140.661,99.979,141.219,99.071z M158.124,92.358c1.298-0.841,2.176-0.841,1.654,0
        c-0.222,0.361-0.907,0.662-1.523,0.658C157.286,93.003,157.273,92.916,158.124,92.358z M161.43,89.044
        c0-0.361,0.451-0.666,0.993-0.666s0.989,0.307,0.989,0.666s-0.447,0.666-0.989,0.666C161.877,89.712,161.43,89.405,161.43,89.044z
         M220.445,77.37c0.222-0.219,0.79-0.243,1.271-0.054c0.518,0.209,0.369,0.371-0.403,0.399
        C220.613,77.749,220.226,77.589,220.445,77.37z M216.013,76.465c-0.703-0.249-0.999-0.604-0.659-0.789
        c0.878-0.486,6.601-0.705,6.137-0.239C220.681,76.25,217.234,76.898,216.013,76.465z M220.429,73.357
        c-1.41-0.57-0.911-1.654,0.663-1.431c0.814,0.118,1.41,0.516,1.318,0.875C222.214,73.608,221.535,73.793,220.429,73.357z
         M211.012,72.913c0-0.209,0.673-1.114,1.503-1.999c1.086-1.168,2.452-1.732,4.88-1.991c1.862-0.199,4.159-0.56,5.108-0.797
        c1.285-0.327,1.725-0.179,1.725,0.54c0,1.323-1.735,2.714-2.66,2.14c-0.403-0.253-2.128-0.243-3.824,0.024
        c-2.462,0.385-2.825,0.588-1.769,1.016c1.197,0.486,1.167,0.536-0.33,0.588c-0.911,0.03-2.321,0.233-3.141,0.452
        C211.679,73.108,211.012,73.118,211.012,72.913z M274.296,60.756c0.447-0.179,1.344-0.189,1.983-0.024
        c0.643,0.169,0.276,0.317-0.814,0.331C274.373,61.077,273.845,60.942,274.296,60.756z"
        />
      </g>
      <g style={{ fill: primaryColor }}>
        <circle
          id="Dot_2_00000068663652793263006470000018386112302284921240_"
          className="dots"
          cx="192.574"
          cy="291.584"
          r="19.802"
        />
        <circle
          id="Dot_2_00000181084659590183820420000012074889162821875903_"
          className="dots"
          cx="250.66"
          cy="331.188"
          r="19.802"
        />
        <circle
          id="Dot_2_00000106866895636055659880000016744308013633565880_"
          className="dots"
          cx="307.426"
          cy="175.413"
          r="19.802"
        />
      </g>
    </svg>
  );
}
