import { DuotoneSvgProps } from './types';

export default function LineSVG({
  primaryColor,
  secondaryColor,
}: DuotoneSvgProps) {
  return (
    // <!-- Generator: Adobe Illustrator 26.0.3, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
    <svg
      version="1.1"
      id="Layer_1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      x="0px"
      y="0px"
      viewBox="0 0 500 500"
      xmlSpace="preserve"
    >
      <style type="text/css">
        {/* <!-- svg classes --> */}
        .primary-markers&#123;fill-rule:evenodd;clip-rule:evenodd;&#125;
        .primary-line&#123;fill-rule:evenodd;clip-rule:evenodd;fill:none;stroke-width:5.6;stroke-miterlimit:10;&#125;
        .secondary-line&#123;fill-rule:evenodd;clip-rule:evenodd;fill:none;stroke-width:5.6;stroke-miterlimit:10;&#125;
        .secondary-markers&#123;fill-rule:evenodd;clip-rule:evenodd;&#125;
        .line-thin&#123;fill-rule:evenodd;clip-rule:evenodd;fill:none;stroke-width:3.0377;stroke-miterlimit:10;&#125;
      </style>
      <g style={{ fill: primaryColor }}>
        <circle
          id="Dot_21_00000157293055327189464480000005230154314322258066_"
          className="primary-markers"
          cx="62.128"
          cy="412.559"
          r="13.179"
        />
        <circle
          id="Dot_14_00000034065510359238136230000003913153677443400068_"
          className="primary-markers"
          cx="312.624"
          cy="300.206"
          r="13.179"
        />
        <circle
          id="Dot_16_00000052819802281250579650000015896080385672126140_"
          className="primary-markers"
          cx="437.872"
          cy="332.937"
          r="13.179"
        />
        <circle
          id="Dot_23_00000101805518294852130560000002432445750256369078_"
          className="primary-markers"
          cx="187.376"
          cy="337.49"
          r="13.179"
        />
      </g>
      <g style={{ stroke: primaryColor }}>
        <polyline
          className="primary-line"
          points="62.128,412.559 187.376,337.49 312.624,300.206 437.872,332.937 "
        />
        <line
          className="line-thin"
          x1="306.003"
          y1="241.177"
          x2="319.245"
          y2="241.177"
        />
        <line
          className="line-thin"
          x1="306.003"
          y1="333.273"
          x2="319.245"
          y2="333.273"
        />
        <line
          className="line-thin"
          x1="180.755"
          y1="372.954"
          x2="193.997"
          y2="372.954"
        />
      </g>
      <g style={{ stroke: primaryColor }}>
        <g>
          <line
            className="line-thin"
            x1="437.872"
            y1="290.236"
            x2="437.872"
            y2="394.044"
          />
          <line
            className="line-thin"
            x1="431.251"
            y1="290.236"
            x2="444.493"
            y2="290.236"
          />
          <line
            className="line-thin"
            x1="431.251"
            y1="394.044"
            x2="444.493"
            y2="394.044"
          />
        </g>
        <line
          className="line-thin"
          x1="312.624"
          y1="241.177"
          x2="312.624"
          y2="333.273"
        />
        <line
          className="line-thin"
          x1="187.376"
          y1="305.56"
          x2="187.376"
          y2="372.954"
        />
        <line
          className="line-thin"
          x1="180.755"
          y1="305.56"
          x2="193.997"
          y2="305.56"
        />
        <g>
          <line
            className="line-thin"
            x1="62.128"
            y1="382.335"
            x2="62.128"
            y2="448.984"
          />
          <line
            className="line-thin"
            x1="55.507"
            y1="382.335"
            x2="68.749"
            y2="382.335"
          />
          <line
            className="line-thin"
            x1="55.507"
            y1="448.984"
            x2="68.749"
            y2="448.984"
          />
        </g>
      </g>
      <g style={{ fill: secondaryColor }}>
        <circle
          id="Dot_21_00000017513433261314329920000013641791400069840263_"
          className="secondary-markers"
          cx="62.128"
          cy="264.301"
          r="13.179"
        />
        <circle
          id="Dot_14_00000146500748590022584990000008941163800800368538_"
          className="secondary-markers"
          cx="312.624"
          cy="158.021"
          r="13.179"
        />
        <circle
          id="Dot_16_00000183952090262577716440000004233371424266460841_"
          className="secondary-markers"
          cx="437.872"
          cy="83.75"
          r="13.179"
        />
        <circle
          id="Dot_23_00000010282265536662711440000016893251245597629614_"
          className="secondary-markers"
          cx="187.376"
          cy="131.007"
          r="13.179"
        />
      </g>
      <g style={{ stroke: secondaryColor }}>
        <polyline
          className="secondary-line"
          points="62.128,264.301 187.376,131.007 312.624,158.021 437.872,82.361 "
        />
      </g>
      <g style={{ stroke: secondaryColor }}>
        <g>
          <line
            className="line-thin"
            x1="437.872"
            y1="51.016"
            x2="437.872"
            y2="120.226"
          />
          <line
            className="line-thin"
            x1="431.251"
            y1="51.016"
            x2="444.493"
            y2="51.016"
          />
          <line
            className="line-thin"
            x1="431.251"
            y1="120.226"
            x2="444.493"
            y2="120.226"
          />
        </g>
        <g>
          <line
            className="line-thin"
            x1="312.624"
            y1="124.328"
            x2="312.624"
            y2="196.972"
          />
          <line
            className="line-thin"
            x1="306.003"
            y1="124.328"
            x2="319.245"
            y2="124.328"
          />
          <line
            className="line-thin"
            x1="306.003"
            y1="196.972"
            x2="319.245"
            y2="196.972"
          />
        </g>
        <g>
          <line
            className="line-thin"
            x1="187.376"
            y1="91.799"
            x2="187.376"
            y2="172.687"
          />
          <line
            className="line-thin"
            x1="180.755"
            y1="91.799"
            x2="193.997"
            y2="91.799"
          />
          <line
            className="line-thin"
            x1="180.755"
            y1="172.687"
            x2="193.997"
            y2="172.687"
          />
        </g>
        <g>
          <line
            className="line-thin"
            x1="62.128"
            y1="234.077"
            x2="62.128"
            y2="295.103"
          />
          <line
            className="line-thin"
            x1="55.507"
            y1="234.077"
            x2="68.749"
            y2="234.077"
          />
          <line
            className="line-thin"
            x1="55.507"
            y1="295.103"
            x2="68.749"
            y2="295.103"
          />
        </g>
      </g>
    </svg>
  );
}
