# "Research Data ScaryTales" published by the Thuringian Competence Network for Research Data Management
This dataset consists of 70 stories about bad (research) data management based on true stories. The stories were collected and adapted by the Thuringian Competence Network for Research Data Management and were used for events since 2020. The text of the stories themselves are free to use under the CC0 licence. This does not include the illustrations, which were used on the webpage or in the card game to visualize the stories.

## Structure
All the stories in this dataset are structured in 'de' for the German stories and 'en' for the English version of the stories. This dataset consists of the following formats.

### "ScaryTales_de.pdf" and "ScaryTales_en.pdf"
Summarization of all stories. Every story consists of a title, a catch phrase, a solution, a lesson learned at the end and a list with all sources. Every page represents one story.

### "sources.pdf"
Summarization of all sources of the stories in a table. The table also includes the number, the german and the english title of the stories.

### `"txt/de/*.txt"` and `"txt/en/*.txt"` files
Every story is saved in a seperate "stXX_title".txt file. The name of the .txt file includes the number and the title of the story. Inside the .txt file the following text segments are seperated by double breaks.
- title
- catch phrase
- solution (with single breaks for each paragraph)
- lessons learned (with single breaks for each paragraph)
- sources (with single breaks for each source)

### `"toml/*.toml"` files
Every story is saved in a "XXX_title.toml" file. The name of the .toml file includes the number and the title of the story. Inside the .toml file the following text segments are saved by the attributes:
- tags (w.i.p.)
- [de] or [en] (to categorize the language for the next attributes)
- title
- short (catchphrase)
- story
- story_shortened (shortened story to fit in card)
- lesson
- sources
The .toml files are used for generating the card pdf-files. For this they have more attributes than the .txt files and are machine readable. Card generator will be released in 2025.

### `categorization/*.pdf` files
This material adds keywords and scientific disciplines to the Research Data Scary Tales stories, allowing you to search for materials specifically suited for the context of the workshop you want to teach. The classification of scientific disciplines is based on the last version of the DFG-Fächersystematik (Amtsperiode 2024-2028). This folder consists of the following files:
- `keywords.pdf`(English) and `schlagwoerter.pdf`(German): Tabular overview of the keywords in English or German. The table matches the keyword and the Reserach Data Scary Tale story number.
- `scientific_disciplines.pdf` (English) and `faecherzuordnung.pdf` (German): Tabular summarization of the scientific discipline attributions in English or German. The table matches the scientific discipline and the story number.

## Licence
The text inside the txt- and pdf-files can be used under a Creative Commons Zero v1.0 Universal licence.

## Acknowledgments
Thanks for the financial support by the Thüringer Ministerium für Wirtschaft, Wissenschaft und digitale Gesellschaft and the universities of Jena, Erfurt, Weimar and Ilmenau which created the Thuringian Competence Network for Research Data Management. Further thanks to all the rdm institutions and researchers who also provided us with stories.