DefineConstant[
    restartComputation= {0},
    t_init = {0},
    t_end = {1.75},
    t_step = {0.001}, 
    t_theta = {1},
    Flag_nl_iteration = {1},
    Flag_write_solution_to_disk = {1},
    Flag_adaptive_time_stepping = {1},
    rel_tol_adaptive_time_stepping = {0},
    abs_tol_adaptive_time_stepping = {0.001},
    t_step_init = {0.0001}, 
	t_step_min = {1e-12}, 
	t_step_max = {1}, 
    nl_relTol_norm ={0},  // relative tolerance non-linear iteration
    nl_absTol_norm = {0.001},  // absolute tolerance non-linear iteration
    NMaxIt = {10},  // maximum number of iterations non-linear iteration
    relaxFactor = {0.7},  // relaxation factor non-linear iteration
    INPUT_extrapolationOrder = {0},// order of extrapolation for the time stepping scheme
    Flag_trackTimesPerTimeStep = {1}, // track the time spent in each time step
    timestep_file = {""}, 
    time_step_per_file = {0}
  ];
  If(time_step_per_file == 1 && Flag_adaptive_time_stepping == 0)
    Include timestep_file;
  EndIf
//======================================================================================
// Physical regions: ===================================================================
//======================================================================================
Group{

    DOM_allInsulationSurface_0 = Region[{ 2000009, 2000010, 2000011 }];

    DOM_terminalContactLayerSurface_WithoutNotch_0 = Region[{ 2000010 }];
    DOM_terminalContactLayerSurface_Notch_0 = Region[{ 2000011 }];

    DOM_terminalContactLayerSurface_0 = Region[{ DOM_terminalContactLayerSurface_WithoutNotch_0, DOM_terminalContactLayerSurface_Notch_0 }];

    DOM_windingMinus_1 = Region[{ 1000000 }];
    DOM_windingPlus_1 = Region[{ 1000002 }];

    DOM_allInsulationSurface_1 = Region[{ 2000000 }];
    DOM_allInsulationSurface_1 += Region[{ 2000001 }];
    DOM_allInsulationSurface_1 += Region[{ 2000002 }];


    DOM_windingMinus_2 = Region[{ 1000001 }];
    DOM_windingPlus_2 = Region[{ 1000003 }];

    DOM_allInsulationSurface_2 = Region[{ 2000003 }];
    DOM_allInsulationSurface_2 += Region[{ 2000004 }];
    DOM_allInsulationSurface_2 += Region[{ 2000005 }];


    DOM_windingMinus_3 = Region[{ 1000002 }];
    DOM_windingPlus_3 = Region[{ 1000000 }];

    DOM_allInsulationSurface_3 = Region[{ 2000006 }];
    DOM_allInsulationSurface_3 += Region[{ 2000007 }];
    DOM_allInsulationSurface_3 += Region[{ 2000008 }];


    DOM_windingMinus_4 = Region[{ 1000003 }];
    DOM_windingPlus_4 = Region[{ 1000001 }];

    DOM_allInsulationSurface_4 = Region[{ 2000009 }];
    DOM_allInsulationSurface_4 += Region[{ 2000010 }];
    DOM_allInsulationSurface_4 += Region[{ 2000011 }];


    DOM_windingMinus_5 = Region[{ 1000000 }];
    DOM_windingPlus_5 = Region[{ 1000002 }];

    DOM_allInsulationSurface_5 = Region[{ 2000000 }];
    DOM_allInsulationSurface_5 += Region[{ 2000001 }];
    DOM_allInsulationSurface_5 += Region[{ 2000002 }];




    // Add terminals to winding region logic:
    // 1000006: inner terminal
    // 1000007: outer terminal
    // 1000004: inner layer transition angle
    // 1000005: outer layer transition angle
    DOM_windingMinus_1 += Region[{ 1000006 }];
    DOM_windingMinus_1 += Region[{ 1000004 }];
    DOM_windingMinus_2 += Region[{ 1000006 }];
    DOM_windingMinus_2 += Region[{ 1000004 }];
    DOM_windingMinus_3 += Region[{ 1000006 }];
    DOM_windingMinus_3 += Region[{ 1000004 }];
    DOM_windingMinus_4 += Region[{ 1000006 }];
    DOM_windingMinus_4 += Region[{ 1000004 }];
    DOM_windingMinus_5 += Region[{ 1000006 }];
    DOM_windingMinus_5 += Region[{ 1000004 }];

    DOM_windingPlus_1 += Region[{ 1000007 }];
    DOM_windingPlus_1 += Region[{ 1000005 }];
    DOM_windingPlus_2 += Region[{ 1000007 }];
    DOM_windingPlus_2 += Region[{ 1000005 }];
    DOM_windingPlus_3 += Region[{ 1000007 }];
    DOM_windingPlus_3 += Region[{ 1000005 }];
    DOM_windingPlus_4 += Region[{ 1000007 }];
    DOM_windingPlus_4 += Region[{ 1000005 }];

    DOM_allInsulationSurface = Region[{ 2000000, 2000001, 2000002, 2000003, 2000004, 2000005, 2000006, 2000007, 2000008, 2000009, 2000010, 2000011 }];
    DOM_insulationSurface = Region[{ 2000000, 2000003, 2000006, 2000009 }];
    DOM_terminalContactLayerSurface_WithoutNotch = Region[{ 2000001, 2000004, 2000007, 2000010 }];
    DOM_terminalContactLayerSurface_Notch = Region[{ 2000002, 2000005, 2000008, 2000011 }];
    DOM_terminalContactLayerSurface = Region[{ DOM_terminalContactLayerSurface_WithoutNotch, DOM_terminalContactLayerSurface_Notch }];
    DOM_allInsulationSurface_WithoutNotch = Region[ {DOM_insulationSurface, DOM_terminalContactLayerSurface_WithoutNotch} ];


    DOM_insulationBoundaryCurvesAir = Region[{ 3000000 }];
    DOM_insulationBoundaryCurvesTerminal = Region[{ 3000001 }];

    // create windings region:
    DOM_allWindings = Region[{ 1000000, 1000001, 1000002, 1000003 }];

    // create terminals region:
    DOM_terminals = Region[{ 1000006, 1000007}];

    // create layer transition angle region:
    DOM_transitionNotchVolumes = Region[{1000004, 1000005}];

    // create powered region:
    DOM_powered = Region[{ DOM_allWindings, DOM_terminals, DOM_transitionNotchVolumes }];

    // support of edge-based magnetic field strength, i.e., all conducting doms:
    DOM_thermal = Region[{ DOM_powered}];
    DOM_allConducting = Region[{ DOM_powered }];
    DOM_resistiveHeating = Region[{ DOM_allWindings, DOM_terminals }];
    DOM_air = Region[{ 1000008 }];
    DOM_airPoints = Region[{ 4000000, 4000001 }];

DOM_allConductingWithoutWindings  = Region[DOM_allConducting];
DOM_allConductingWithoutWindings -= Region[DOM_allWindings];




    // boundary surface between the all conducting and non-conducting domains:
    DOM_pancakeBoundary = Region[{ 2000014 }];

    // support of magnetic scalar potential, i.e., all non-conducting doms:
    DOM_Phi = Region[{ DOM_air }];

    // cut inbetween current leads, used to impose current or voltage:
    DOM_terminalCut = Region[{ 3000002 }];
    DOM_airCuts = Region[{ DOM_terminalCut }];

    // total computational domain (Omega):
    DOM_total = Region[{ DOM_allConducting, DOM_Phi }];

    // top and bottom surfaces of the terminals for constant temperature BC:
    DOM_bottomTerminalSurface = Region[{ 2000013 }];
    DOM_topTerminalSurface = Region[{ 2000012 }];
    DOM_terminalSurfaces = Region[{ DOM_bottomTerminalSurface, DOM_topTerminalSurface }];

    
}

//======================================================================================
// Physical properties: ================================================================
//======================================================================================
Function{
    // Power supply / current source:
    listOfTimeValues = {0.0, 0.2, 0.225, 0.3, 0.325, 0.35, 0.4, 0.425, 0.45, 0.5, 0.51, 0.53, 0.6};
    listOfCurrentValues = {0.0, 200.0, 200.0, 400.0, 400.0, 500.0, 500.0, 350.0, 350.0, 100.0, 100.0, 0.0, 0.0};
    current[] = InterpolationLinear[$1]{ListAlt[listOfTimeValues, listOfCurrentValues]};

    // Pancake3D geometry related functions:

    // We use SetVariable and GetVariable to ensure some variables are only evaluated once
    // and saved in the memory. Input of the functions below is the position vector XYZ[].



    // to be templated below
    oneDGaussianOrder = 2;
    // to be templated above

    // Initial conditions:
    INPUT_initialTemperature = 15.0; // initial temperature, [K]

    // Time stepping parameters:
    INPUT_tStart = 0.0; // start time, [s]
    INPUT_tEnd = 0.6; // end time, [s]
    INPUT_extrapolationOrder = 0; // order of extrapolation for the time stepping scheme
    // Adaptive time stepping parameters:
    INPUT_tAdaptiveMinStep = 1e-10; // minimum time step, [s]
    INPUT_tAdaptiveMaxStep = 0.1; // maximum time step, [s]
    INPUT_tAdaptiveInitStep = 1e-06; // initial time step, [s]
    INPUT_tAdaptiveBreakPoints ={ 0.0, 0.2, 0.225, 0.3, 0.325, 0.35, 0.4, 0.425, 0.45, 0.5, 0.51, 0.53, 0.6 }; // force solution at these time points, [s]

    If (time_step_per_file == 1)
        t_step_fct[] = InterpolationLinear[$Time]{ListAlt[List_of_time_values, List_of_time_steps]};
    Else
        t_step_fct[] = t_step;
    EndIf


    // Nonlinear solver parameters:
    INPUT_NLSMaxNumOfIter = 15; // maximum number of iterations for the nonlinear solver
    INPUT_NLSRelaxFactor = 0.7; // relaxation factor for the nonlinear solver

    //==================================================================================
    // Material parameters: ============================================================
    //==================================================================================
    // Air permeability starts =========================================================
    // Linear:
    INPUT_airMagneticPermeability = 1.2566e-06;
    mu[] = INPUT_airMagneticPermeability;
    // Air permeability ends ===========================================================

    // Winding material combination parameters start ===================================
    INPUT_relativeThicknessCopper = 0.35;
    INPUT_relativeThicknessHastelloy = 0.625;
    INPUT_relativeThicknessSilver = 0.0125;

    INPUT_relativeThicknessOfSuperConductor = 0.0125;
    INPUT_relativeThicknessOfNormalConductor = 0.9874999999999999;
    INPUT_relativeWidthOfPlating = 0.0;
    // Factor 1.0/0.930232558139535 is used equate the scaling applied to Jcritical in the parallel direction 
    INPUT_jCriticalScalingNormalToWinding = 1.0/0.930232558139535 * 1;
    // Winding material combination parameters end =====================================

    // TSA parameters start ============================================================
    INPUT_insulationThickness = 1e-05; // thickness of the insulation, [m]
    INPUT_NumOfTSAElements = 1;
    th_terminal_k = INPUT_insulationThickness / (INPUT_NumOfTSAElements == 0 ? 1 : INPUT_NumOfTSAElements);
    th_insulation_k = th_terminal_k;
    // TSA parameters end ==============================================================
    


    // Winding resistivity, Jc, and lambda starts ======================================================
    
    rhoWindingAndDerivative[] = WindingWithSuperConductorRhoAndDerivativeV1[
        $Time,
        XYZ[],
        $3,
        $2,
        $1
    ]{  15.0,
        0.0,
        0.0,
        -1,
 
        0,
        1, // N of Ic Values
        1,
        780.0,
        3, // N of materials,
        0,
        1,
        2,
        0.35,
        0.625,
        0.0125,
        100.0,
        100,
        100.0,
        295.0,
        295,
        295.0,
        0,
        0.0,
        100.0,
        295.0,
        5, // material integer: HTS
        0.0125, // relative thickness of HTS
        0.0001, // electric field criterion of HTS
        30.0, // n value of HTS
        1e-18, // winding minimum possible resistivity (or superconductor minimum? bug)
        1e-08, // winding maximum possible resistivity (or superconductor maximum? bug)
        0, // local defect start turn
        0, // local defect end turn
        1, // local defect which pancake coil
        0, // local defect value
        99999999, // local defect start time
        0.005,
        0.000129,
        0,
        0.0,
        24,
        1,
        0.004,
        0.01,
        0.930232558139535,
        1 // arbitrary jCritical scaling normal to winding
    };
    rho[DOM_allWindings] =     GetFirstTensor[
        SetVariable[
            rhoWindingAndDerivative[$1, $2, $3],
            ElementNum[],
            QuadraturePointIndex[],
            $NLIteration
        ]{
            $rhoWindingAndDerivative
        }
    ];

    
    d_of_rho_wrt_j_TIMES_j[DOM_allWindings] = GetSecondTensor[
        GetVariable[ElementNum[], QuadraturePointIndex[], $NLIteration]{$rhoWindingAndDerivative}
    ];

    Jcritical[] = Pancake3DCriticalCurrentDensity[
        $Time,
        XYZ[],
        $2,
        $1
        ]{
            15.0,
            0.0,
            0.0,
            -1,
            1, // N of Ic Values
            1,
            780.0,
            3, // N of materials,
            0,
            1,
            2,
            0.35,
            0.625,
            0.0125,
            100.0,
            100,
            100.0,
            295.0,
            295,
            295.0,
            5, // material integer: HTS
            0.0125, // relative thickness of HTS
            0, // local defect start turn
            0, // local defect end turn
            1, // local defect which pancake coil
            0, // local defect value
            99999999, // local defect start time
            0.000129,
            0.004,
            0.930232558139535,
            0,
            0.0,
            100.0,
            295.0
        };

        Icritical[] = Pancake3DCriticalCurrent[
            $Time,
            XYZ[],
            $2,
            $1
            ]{
                15.0,
                0.0,
                0.0,
                -1,
                1, // N of Ic Values
                1,
                780.0,
                3, // N of materials,
                0,
                1,
                2,
                0.35,
                0.625,
                0.0125,
                100.0,
                100,
                100.0,
                295.0,
                295,
                295.0,
                5, // material integer: HTS
                0.0125, // relative thickness of HTS
                0, // local defect start turn
                0, // local defect end turn
                1, // local defect which pancake coil
                0, // local defect value
                99999999, // local defect start time
                0.000129,
                0.004,
                0.930232558139535,
                0,
                0.0,
                100.0,
                295.0
            };

            lambda[] = Pancake3DHTSCurrentSharingIndex[
                $Time,
                XYZ[],
                $3,
                $2,
                $1
            ]{  15.0,
                0.0,
                0.0,
                -1,
 
                0,
                1, // N of Ic Values
                1,
                780.0,
                3, // N of materials,
                0,
                1,
                2,
                0.35,
                0.625,
                0.0125,
                100.0,
                100,
                100.0,
                295.0,
                295,
                295.0,
                5, // material integer: HTS
                0.0125, // relative thickness of HTS
                0.0001, // electric field criterion of HTS
                30.0, // n value of HTS
                0, // local defect start turn
                0, // local defect end turn
                1, // local defect which pancake coil
                0, // local defect value
                99999999, // local defect start time
                0.000129,
                0.004,
                0.930232558139535,
                0,
                0.0,
                100.0,
                295.0
            };

            jHTS[] = Pancake3DHTSCurrentDensity[
                $Time,
                XYZ[],
                $3,
                $2,
                $1
            ]{  15.0,
                0.0,
                0.0,
                -1,
 
                0,
                1, // N of Ic Values
                1,
                780.0,
                3, // N of materials,
                0,
                1,
                2,
                0.35,
                0.625,
                0.0125,
                100.0,
                100,
                100.0,
                295.0,
                295,
                295.0,
                5, // material integer: HTS
                0.0125, // relative thickness of HTS
                0.0001, // electric field criterion of HTS
                30.0, // n value of HTS
                0, // local defect start turn
                0, // local defect end turn
                1, // local defect which pancake coil
                0, // local defect value
                99999999, // local defect start time
                0.000129,
                0.004,
                0.930232558139535,
                0,
                0.0,
                100.0,
                295.0
            };
    // Winding resistivity, Jc, and lambda ends ========================================================

    // Terminals resistivity starts ====================================================
    rho[DOM_transitionNotchVolumes] = 0.01;

    // Nonlinear:
    rho[DOM_terminals] = CFUN_rhoCu_T_B[$1, Norm[$2]]{100.0};
    
    // Terminals resistivity ends ======================================================

    // Insulation resistivity starts ===================================================
    // Linear:
    INPUT_insulationResistivity =0.000112; // resistivity of the insulation, [Ohm*m]

        electromagneticOnlyFunction[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_fct_only[]{
            th_terminal_k, INPUT_insulationResistivity
        };
    // Thin-shell insulation:
    electromagneticMassFunctionNoDta1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 1
        };
    
    electromagneticStiffnessFunctiona1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 1
        };

    electromagneticMassFunctionDta1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 1, 1
        };

    electromagneticMassFunctionNoDta1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 2
        };
    
    electromagneticStiffnessFunctiona1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 2
        };

    electromagneticMassFunctionDta1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 1, 2
        };

    electromagneticMassFunctionNoDta2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 1
        };
    
    electromagneticStiffnessFunctiona2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 1
        };

    electromagneticMassFunctionDta2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 2, 1
        };

    electromagneticMassFunctionNoDta2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 2
        };
    
    electromagneticStiffnessFunctiona2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 2
        };

    electromagneticMassFunctionDta2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 2, 2
        };

        
    electromagneticRHSFunctionk1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_rhs[]{
            th_terminal_k, INPUT_insulationResistivity
        };

    electromagneticTripleFunctionk1a1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 1, 1
        };

    electromagneticTripleFunctionk1a1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 1, 2
        };

    electromagneticTripleFunctionk1a2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 2, 1
        };

    electromagneticTripleFunctionk1a2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 1, 2, 2
        };

    electromagneticRHSFunctionk2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_rhs[]{
            th_terminal_k, INPUT_insulationResistivity
        };

    electromagneticTripleFunctionk2a1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 1, 1
        };

    electromagneticTripleFunctionk2a1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 1, 2
        };

    electromagneticTripleFunctionk2a2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 2, 1
        };

    electromagneticTripleFunctionk2a2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_insulationResistivity, 2, 2, 2
        };


    // Insulation resistivity ends =====================================================
    

    // Transition layer resistivity starts =============================================
    // Linear:
    INPUT_terminalContactLayerResistivity = 0.000112; // resistivity of the insulation, [Ohm*m]

    electromagneticOnlyFunction[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_fct_only[]{
        th_terminal_k, INPUT_terminalContactLayerResistivity
    };
    // Thin-shell insulation:
    electromagneticMassFunctionNoDta1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 1
        };

    electromagneticStiffnessFunctiona1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 1
        };

    electromagneticMassFunctionDta1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 1, 1
        };

    electromagneticMassFunctionNoDta1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 2
        };

    electromagneticStiffnessFunctiona1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 2
        };

    electromagneticMassFunctionDta1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 1, 2
        };

    electromagneticMassFunctionNoDta2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 1
        };

    electromagneticStiffnessFunctiona2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 1
        };

    electromagneticMassFunctionDta2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 2, 1
        };

    electromagneticMassFunctionNoDta2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 2
        };

    electromagneticStiffnessFunctiona2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 2
        };

    electromagneticMassFunctionDta2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_airMagneticPermeability, 2, 2
        };

        
    electromagneticRHSFunctionk1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_rhs[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity
        };

    electromagneticTripleFunctionk1a1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 1, 1
        };

    electromagneticTripleFunctionk1a1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 1, 2
        };

    electromagneticTripleFunctionk1a2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 2, 1
        };

    electromagneticTripleFunctionk1a2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 1, 2, 2
        };

    electromagneticRHSFunctionk2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_rhs[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity
        };

    electromagneticTripleFunctionk2a1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 1, 1
        };

    electromagneticTripleFunctionk2a1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 1, 2
        };

    electromagneticTripleFunctionk2a2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 2, 1
        };

    electromagneticTripleFunctionk2a2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_triple[]{
            th_terminal_k, INPUT_terminalContactLayerResistivity, 2, 2, 2
        };


    // Transition layer resistivity ends ===============================================

    // Winding thermal conductivity starts =============================================
    // Nonlinear:
    kappa[DOM_allWindings] = WindingThermalConductivityV1[
        XYZ[],
        $2,
        $1
    ]{   0 ,
        3, // N of materials,
        0,
        1,
        2,
        0.35,
        0.625,
        0.0125,
        100.0,
        100,
        100.0,
        295.0,
        295,
        295.0,
        0,
        0.0,
        100.0,
        295.0,
        0.005,
        0.000129,
        0,
        0.0,
        24,
        1,
        0.004,
        0.01,
        0.930232558139535,
        1 // arbitrary jCritical scaling normal to winding
    };
    // Winding thermal conductivity ends ===============================================

    // Terminals thermal conductivity starts ===========================================
    kappa[DOM_transitionNotchVolumes] = 100.0;

    // Nonlinear:
    kappa[DOM_terminals] = CFUN_kCu_T_rho0_rho[$1, CFUN_rhoCu_T[$1]{0, 100.0}, CFUN_rhoCu_T_B[$1, Norm[$2]]{100.0}]{100.0};
    // Terminals thermal conductivity ends =============================================

    // Insulation thermal conductivity starts ==========================================
    // Linear:
    INPUT_insulationThermalConductivity = 100.0; // thermal conductivity of the insulation, [W/*(m*K)]

    // Thin-shell insulation:
    thermalMassFunctionNoDta1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 1, 1
        };

    thermalStiffnessFunctiona1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 1, 1
        };
    thermalMassFunctionNoDta1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 1, 2
        };

    thermalStiffnessFunctiona1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 1, 2
        };
    thermalMassFunctionNoDta2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 2, 1
        };

    thermalStiffnessFunctiona2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 2, 1
        };
    thermalMassFunctionNoDta2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 2, 2
        };

    thermalStiffnessFunctiona2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_insulation_k, INPUT_insulationThermalConductivity, 2, 2
        };
    // Insulation thermal conductivity ends ============================================

    // Transition layer thermal conductivity starts ====================================
    // Linear:
    INPUT_terminalContactLayerThermalConductivity = 100.0; // thermal conductivity of the insulation, [W/*(m*K)]

    // Thin-shell insulation:
    thermalMassFunctionNoDta1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 1, 1
        };

    thermalStiffnessFunctiona1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 1, 1
        };

    thermalMassFunctionNoDta1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 1, 2
        };

    thermalStiffnessFunctiona1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 1, 2
        };

    thermalMassFunctionNoDta2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 2, 1
        };

    thermalStiffnessFunctiona2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 2, 1
        };

    thermalMassFunctionNoDta2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 2, 2
        };

    thermalStiffnessFunctiona2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_stiffness[]{
            th_terminal_k, INPUT_terminalContactLayerThermalConductivity, 2, 2
        };

    // Transition layer thermal conductivity ends ======================================
    

    // Winding specific heat capacity starts ===========================================
    // Nonlinear:
    CvCopper[] =  CFUN_CvCu_T[$1];
    CvHastelloy[] =  CFUN_CvHast_T[$1];
    CvSilver[] =  CFUN_CvAg_T[$1];

    Cv[DOM_allWindings] = 0.930232558139535 * RuleOfMixtures[
        CvCopper[$1],
        CvHastelloy[$1],
        CvSilver[$1]
    ]{
        INPUT_relativeThicknessCopper,
        INPUT_relativeThicknessHastelloy,
        INPUT_relativeThicknessSilver
    };
    // Winding specific heat capacity ends =============================================

    // Terminals specific heat capacity starts =========================================
    Cv[DOM_transitionNotchVolumes] = 150.0;

    // Nonlinear:
    Cv[DOM_terminals] =  CFUN_CvCu_T[$1];
    // Terminals specific heat capacity ends ===========================================
    
    // Insulation specific heat capacity starts ========================================
    // Linear:
    INPUT_insulationSpecificHeatCapacity = 150.0; // specific heat capacity of the terminal, [J/(kg*K)]

    // Thin-shell insulation:
    thermalMassFunctionDta1b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationSpecificHeatCapacity, 1, 1
        };

    thermalMassFunctionDta1b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationSpecificHeatCapacity, 1, 2
        };

    thermalMassFunctionDta2b1[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationSpecificHeatCapacity, 2, 1
        };

    thermalMassFunctionDta2b2[DOM_insulationSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_insulation_k, INPUT_insulationSpecificHeatCapacity, 2, 2
        };


    // Insulation specific heat capacity ends ==========================================

    // Transition layer specific heat capacity starts ==================================
    // Linear:
    INPUT_terminalContactLayerSpecificHeatCapacity = 150.0; // specific heat capacity of the terminal, [J/(kg*K)]

    // Thin-shell insulation:
    thermalMassFunctionDta1b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerSpecificHeatCapacity, 1, 1
        };

    thermalMassFunctionDta1b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerSpecificHeatCapacity, 1, 2
        };

    thermalMassFunctionDta2b1[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerSpecificHeatCapacity, 2, 1
        };

    thermalMassFunctionDta2b2[DOM_terminalContactLayerSurface] = TSA_constantMaterial_constantThickness_mass[]{
            th_terminal_k, INPUT_terminalContactLayerSpecificHeatCapacity, 2, 2
        };


    // Transition layer specific heat capacity ends ====================================
    

}

//======================================================================================
// Jacobian and integration: ===========================================================
//======================================================================================
Jacobian{
    {
        Name JAC_vol; // volume Jacobian
        Case
        {
            {
                Region All;
                Jacobian Vol;
            }
        }
    }

    // surface Jacobian for TSA:
    {
        Name JAC_sur; // surface Jacobian
        Case
        {
            {
                Region All;
                Jacobian Sur;
            }
        }
    }
}

Integration{
    {
        Name Int; // Gauss integraion scheme
        Case{
            {
                Type Gauss;
                Case{
                    {
                        GeoElement Triangle;
                        NumberOfPoints 4;
                    }
                    {
                        GeoElement Quadrangle;
                        NumberOfPoints 4;
                    }
                    {
                        GeoElement Tetrahedron;
                        NumberOfPoints 4;
                    }
                    {
                        GeoElement Hexahedron;
                        NumberOfPoints 6;
                    }
                    {
                        GeoElement Prism;
                        NumberOfPoints 9;
                    }
                    {
                        GeoElement Pyramid;
                        NumberOfPoints 8;
                    }
                }
            }
        }
    }
}

//======================================================================================
// Constraints: ========================================================================
//======================================================================================
Constraint{
    {
        // Impose current:
        Name CONSTRAINT_current;
        Case{
            {
                Region DOM_terminalCut;
                Type Assign;
                Value 1;


                TimeFunction current[$Time];
            }
        }
    }
    
    {
        Name CONSTRAINT_zeroPhiAtOuterPoint;
        Case{
            {
                Region DOM_airPoints;
                Type Assign;
                Value 0;
            }
        }
    }
    {
        Name CONSTRAINT_initialTemperature;
        Case {
            {
                Region DOM_bottomTerminalSurface;
                Type Assign;
                Value 15.0;
            }
            {
                Region DOM_topTerminalSurface;
                Type Assign;
                Value 15.0;
            }
            If(restartComputation == 0)
            {
                Region Region[
                            {
                                DOM_powered, 
                                DOM_allInsulationSurface
                            }
                        ];
                Type Init;
                Value 15.0;
            }
            EndIf
        }
    }
}

//======================================================================================
// Function spaces: ====================================================================
//======================================================================================
FunctionSpace{
    {
        Name SPACE_hPhi;
        Type Form1;
        BasisFunction{
            // gradient of nodal basis functions in DOM_Phi and on DOM_pancakeBoundary
            {
                Name BASISFUN_gradpsin;
                NameOfCoef phin;
                Function BF_GradNode;
                Support DOM_total;
                Entity NodesOf[{DOM_Phi}, Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal}];
            }
            // edge basis functions in DOM_allConducting, and not on DOM_pancakeBoundary or DOM_allInsulationSurface
            {
                Name BASISFUN_psie;
                NameOfCoef he;
                Function BF_Edge;
                Support DOM_allConducting;
                Entity EdgesOf[All, Not {DOM_pancakeBoundary, DOM_allInsulationSurface}];
            }
            // edge-based cohomology basis functions on both cuts
            {
                Name BASISFUN_sc;
                NameOfCoef Ii;
                Function BF_GroupOfEdges;
                Support Region[{DOM_total, DOM_allInsulationSurface}];
                Entity GroupsOfEdgesOf[DOM_airCuts];
            }
            // TSA basis functions starts ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // TSA contributions following special indexing to restrict them to one side of the thin
            // layer split in plus and minus side.
            {
                Name BASISFUN_snMinus_1;
                NameOfCoef BASISFUN_snMinus_coeff_1;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_1,
                                DOM_allInsulationSurface_2,
                                DOM_windingMinus_1,
                                DOM_windingMinus_2
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_1,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_0 }
                    ];
            }

            {
                Name BASISFUN_snPlus_1;
                NameOfCoef BASISFUN_snPlus_coeff_1;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_1,
                                DOM_allInsulationSurface_2,
                                DOM_windingPlus_1,
                                DOM_windingPlus_2
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_1,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_0 }
                    ];
            }
            {
                Name BASISFUN_snMinus_2;
                NameOfCoef BASISFUN_snMinus_coeff_2;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_2,
                                DOM_allInsulationSurface_3,
                                DOM_windingMinus_2,
                                DOM_windingMinus_3
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_2,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_1 }
                    ];
            }

            {
                Name BASISFUN_snPlus_2;
                NameOfCoef BASISFUN_snPlus_coeff_2;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_2,
                                DOM_allInsulationSurface_3,
                                DOM_windingPlus_2,
                                DOM_windingPlus_3
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_2,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_1 }
                    ];
            }
            {
                Name BASISFUN_snMinus_3;
                NameOfCoef BASISFUN_snMinus_coeff_3;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_3,
                                DOM_allInsulationSurface_4,
                                DOM_windingMinus_3,
                                DOM_windingMinus_4
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_3,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_2 }
                    ];
            }

            {
                Name BASISFUN_snPlus_3;
                NameOfCoef BASISFUN_snPlus_coeff_3;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_3,
                                DOM_allInsulationSurface_4,
                                DOM_windingPlus_3,
                                DOM_windingPlus_4
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_3,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_2 }
                    ];
            }
            {
                Name BASISFUN_snMinus_4;
                NameOfCoef BASISFUN_snMinus_coeff_4;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_4,
                                DOM_allInsulationSurface_5,
                                DOM_windingMinus_4,
                                DOM_windingMinus_5
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_4,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_3 }
                    ];
            }

            {
                Name BASISFUN_snPlus_4;
                NameOfCoef BASISFUN_snPlus_coeff_4;
                Function BF_Edge;
                Support Region[
                            {   
                                DOM_allInsulationSurface_4,
                                DOM_allInsulationSurface_5,
                                DOM_windingPlus_4,
                                DOM_windingPlus_5
                            }
                        ];
                Entity EdgesOf[
                    DOM_allInsulationSurface_4,
                    Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal,  DOM_allInsulationSurface_3 }
                    ];
            }

            // TSA basis functions ends ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // TSA contribution on boundary of the thin layer
            {
                Name BASISFUN_gradpsinBnd;
                NameOfCoef phin_bnd;
                Function BF_GradNode;
                Support Region[
                            {
                                DOM_allConducting,
                                DOM_Phi,
                                DOM_allInsulationSurface
                            }
                        ];
                Entity NodesOf[DOM_insulationBoundaryCurvesAir];
            }
            {
                Name BASISFUN_psieBnd;
                NameOfCoef psie_bnd;
                Function BF_Edge;
                Support Region[
                            {
                                DOM_allConducting,
                                DOM_allInsulationSurface
                            }
                        ];
                Entity EdgesOf[DOM_insulationBoundaryCurvesTerminal];
            }
            For i In {1:INPUT_NumOfTSAElements - 1}
                {
                    Name BASISFUN_sn~{i};
                    NameOfCoef he~{i};
                    Function BF_Edge;
                    Support DOM_allInsulationSurface;
                    Entity EdgesOf[ All, Not {DOM_insulationBoundaryCurvesAir, DOM_insulationBoundaryCurvesTerminal} ];
                }
            EndFor
        }

        SubSpace{
            // TSA subspaces starts ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // identification of the positive and negative side of the contact layer:
            {
                Name SUBSPACE_insulationSurface_down;
                NameOfBasisFunction{
                    BASISFUN_snMinus_1,
                    BASISFUN_snMinus_2,
                    BASISFUN_snMinus_3,
                    BASISFUN_snMinus_4,
                    BASISFUN_sc,
                    BASISFUN_gradpsinBnd,
                    BASISFUN_psieBnd
                };
            }
            {
                Name SUBSPACE_insulationSurface_up;
                NameOfBasisFunction{
                    BASISFUN_snPlus_1,
                    BASISFUN_snPlus_2,
                    BASISFUN_snPlus_3,
                    BASISFUN_snPlus_4,
                    BASISFUN_sc,
                    BASISFUN_gradpsinBnd,
                    BASISFUN_psieBnd
                };
            }



            For i In {1:INPUT_NumOfTSAElements - 1}
                {
                    Name SUBSPACE_tsa~{i}; 
                    NameOfBasisFunction {
                        BASISFUN_sn~{i},
                        BASISFUN_sc,
                        BASISFUN_gradpsinBnd,
                        BASISFUN_psieBnd
                    };
                }

            EndFor

            // TSA subspaces ends ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

        }
        // global quantities in order to impose/extract currents or voltages
        GlobalQuantity{
            {
                Name GLOBALQUANT_I;
                Type AliasOf;
                NameOfCoef Ii;
            }
            {
                Name GLOBALQUANT_V;
                Type AssociatedWith;
                NameOfCoef Ii;
            }
        }

        // imposing source current or voltage using global quantities
        Constraint
        {
            {
                NameOfCoef GLOBALQUANT_I;
                EntityType GroupsOfEdgesOf;
                NameOfConstraint CONSTRAINT_current;
            }
            {
                NameOfCoef phin;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_zeroPhiAtOuterPoint;
            }
            {
                NameOfCoef phin_bnd;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_zeroPhiAtOuterPoint;
            }
        }
    }
    {
        Name SPACE_temperature;
        Type Form0;
        BasisFunction{
            {
                Name BASISFUN_sn;
                NameOfCoef Tn;
                Function BF_Node;
                Support Region[{DOM_thermal 
                }];
                Entity NodesOf[DOM_thermal, 
                    Not {DOM_allInsulationSurface}];
            }
            // TSA basis functions starts ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // TSA contributions following special indexing to restrict them to one side of the thin
            // layer split in plus and minus side.
            {
                Name BASISFUN_snMinus_1;
                NameOfCoef BASISFUN_snMinus_coeff_1;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_1,
                                DOM_allInsulationSurface_2,
                                DOM_windingMinus_1,
                                DOM_windingMinus_2
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_1,
                        Not { DOM_allInsulationSurface_0, DOM_insulationBoundaryCurvesTerminal 
                        }
                            ];
            }

            {
                Name BASISFUN_snPlus_1;
                NameOfCoef BASISFUN_snPlus_coeff_1;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_1,
                                DOM_allInsulationSurface_2,
                                DOM_windingPlus_1,
                                DOM_windingPlus_2
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_1,
                        Not { DOM_allInsulationSurface_0, DOM_insulationBoundaryCurvesTerminal            
                    }
                        ];
            }
            {
                Name BASISFUN_snMinus_2;
                NameOfCoef BASISFUN_snMinus_coeff_2;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_2,
                                DOM_allInsulationSurface_3,
                                DOM_windingMinus_2,
                                DOM_windingMinus_3
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_2,
                        Not { DOM_allInsulationSurface_1, DOM_insulationBoundaryCurvesTerminal 
                        }
                            ];
            }

            {
                Name BASISFUN_snPlus_2;
                NameOfCoef BASISFUN_snPlus_coeff_2;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_2,
                                DOM_allInsulationSurface_3,
                                DOM_windingPlus_2,
                                DOM_windingPlus_3
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_2,
                        Not { DOM_allInsulationSurface_1, DOM_insulationBoundaryCurvesTerminal            
                    }
                        ];
            }
            {
                Name BASISFUN_snMinus_3;
                NameOfCoef BASISFUN_snMinus_coeff_3;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_3,
                                DOM_allInsulationSurface_4,
                                DOM_windingMinus_3,
                                DOM_windingMinus_4
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_3,
                        Not { DOM_allInsulationSurface_2, DOM_insulationBoundaryCurvesTerminal 
                        }
                            ];
            }

            {
                Name BASISFUN_snPlus_3;
                NameOfCoef BASISFUN_snPlus_coeff_3;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_3,
                                DOM_allInsulationSurface_4,
                                DOM_windingPlus_3,
                                DOM_windingPlus_4
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_3,
                        Not { DOM_allInsulationSurface_2, DOM_insulationBoundaryCurvesTerminal            
                    }
                        ];
            }
            {
                Name BASISFUN_snMinus_4;
                NameOfCoef BASISFUN_snMinus_coeff_4;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_4,
                                DOM_allInsulationSurface_5,
                                DOM_windingMinus_4,
                                DOM_windingMinus_5
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_4,
                        Not { DOM_allInsulationSurface_3, DOM_insulationBoundaryCurvesTerminal 
                        }
                            ];
            }

            {
                Name BASISFUN_snPlus_4;
                NameOfCoef BASISFUN_snPlus_coeff_4;
                Function BF_Node;
                Support Region[
                            {   
                                DOM_allInsulationSurface_4,
                                DOM_allInsulationSurface_5,
                                DOM_windingPlus_4,
                                DOM_windingPlus_5
                            }
                        ];
                Entity NodesOf[
                        DOM_allInsulationSurface_4,
                        Not { DOM_allInsulationSurface_3, DOM_insulationBoundaryCurvesTerminal            
                    }
                        ];
            }

            // TSA basis functions ends ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




            {
                Name BASISFUN_snBndTerminal;
                NameOfCoef Tn_Bnd;
                Function BF_Node;
                Support Region[{DOM_thermal, DOM_allInsulationSurface
                }];
                Entity NodesOf[DOM_insulationBoundaryCurvesTerminal];
            }

            For i In {1:INPUT_NumOfTSAElements - 1}
                {
                    Name BASISFUN_sn~{i};
                    NameOfCoef sn~{i};
                    Function BF_Node;
                    Support DOM_allInsulationSurface;
                    Entity NodesOf[ All, Not DOM_insulationBoundaryCurvesTerminal ];
                }

            EndFor

            
        }
        SubSpace {
            // TSA subspaces starts ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // identification of the positive and negative side of the contact layer:
            {
                Name SUBSPACE_insulationSurface_down;
                NameOfBasisFunction{
                    BASISFUN_snMinus_1,
                    BASISFUN_snMinus_2,
                    BASISFUN_snMinus_3,
                    BASISFUN_snMinus_4,
                    BASISFUN_snBndTerminal
                };
            }
            {
                Name SUBSPACE_insulationSurface_up;
                NameOfBasisFunction{
                    BASISFUN_snPlus_1,
                    BASISFUN_snPlus_2,
                    BASISFUN_snPlus_3,
                    BASISFUN_snPlus_4,
                    BASISFUN_snBndTerminal
                };
            }



            For i In {1:INPUT_NumOfTSAElements - 1}
                {
                    Name SUBSPACE_tsa~{i}; 
                    NameOfBasisFunction {
                        BASISFUN_sn~{i},
                        BASISFUN_snBndTerminal
                    };
                }

            EndFor

            // TSA subspaces ends ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

        }
        Constraint{
            {
                NameOfCoef Tn;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }
            {
                NameOfCoef BASISFUN_snMinus_coeff_1;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }
            {
                NameOfCoef BASISFUN_snPlus_coeff_1;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }

            {
                NameOfCoef BASISFUN_snMinus_coeff_2;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }
            {
                NameOfCoef BASISFUN_snPlus_coeff_2;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }

            {
                NameOfCoef BASISFUN_snMinus_coeff_3;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }
            {
                NameOfCoef BASISFUN_snPlus_coeff_3;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }

            {
                NameOfCoef BASISFUN_snMinus_coeff_4;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }
            {
                NameOfCoef BASISFUN_snPlus_coeff_4;
                EntityType NodesOf;
                NameOfConstraint CONSTRAINT_initialTemperature;
            }


    For i In {1:INPUT_NumOfTSAElements - 1}
        {
            NameOfCoef sn~{i};
            EntityType NodesOf;
            NameOfConstraint CONSTRAINT_initialTemperature;
        }

    EndFor
    
    {
        NameOfCoef Tn_Bnd;
        EntityType NodesOf;
        NameOfConstraint CONSTRAINT_initialTemperature;
    }
        }
    }


}


//======================================================================================
// Formulations: =======================================================================
//======================================================================================
Formulation{
    {
        Name FORMULATION_stronglyCoupled;
        Type FemEquation;
        Quantity{
            // Volumetric quantities starts ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            {
                Name LOCALQUANT_h;
                Type Local;
                NameOfSpace SPACE_hPhi;
            }
            {
                // Different test function is needed for non-symmetric tensors, otherwise, getdp
                // assumes the tensors are symmetric and the result is wrong.
                Name LOCALQUANT_h_Derivative;
                Type Local;
                NameOfSpace SPACE_hPhi;
            }
            {
                Name GLOBALQUANT_I;
                Type Global;
                NameOfSpace SPACE_hPhi[GLOBALQUANT_I];
            }
            {
                Name GLOBALQUANT_V;
                Type Global;
                NameOfSpace SPACE_hPhi[GLOBALQUANT_V];
            }
            // Volumetric quantities ends ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // Volumetric quantities starts ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            {
                Name LOCALQUANT_T;
                Type Local;
                NameOfSpace SPACE_temperature;
            }
            // Volumetric quantities ends ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // TSA quantities starts +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            {
                Name LOCALQUANT_hThinShell~{0};
                Type Local;
                NameOfSpace SPACE_hPhi[SUBSPACE_insulationSurface_down];
            }

            For i In {1:INPUT_NumOfTSAElements-1}
                {
                    Name LOCALQUANT_hThinShell~{i};
                    Type Local;
                    NameOfSpace SPACE_hPhi[SUBSPACE_tsa~{i}];
                }
            EndFor

            {
                Name LOCALQUANT_hThinShell~{INPUT_NumOfTSAElements};
                Type Local;
                NameOfSpace SPACE_hPhi[SUBSPACE_insulationSurface_up];
            }
            // TSA quantities ends +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // TSA quantities starts +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            {
                Name LOCALQUANT_TThinShell~{0};
                Type Local;
                NameOfSpace SPACE_temperature[SUBSPACE_insulationSurface_up];
            }

            For i In{1 : INPUT_NumOfTSAElements - 1}
                {
                    Name LOCALQUANT_TThinShell~{i};
                    Type Local;
                    NameOfSpace SPACE_temperature[SUBSPACE_tsa~{i}];
                }
            EndFor

            {
                Name LOCALQUANT_TThinShell~{INPUT_NumOfTSAElements};
                Type Local;
                NameOfSpace SPACE_temperature[SUBSPACE_insulationSurface_down];
            }
            // TSA quantities ends +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

        }

        Equation{
            Integral{
                // note that it is only defined in DOM_allConducting, not all domain
                [ rho[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}] * Dof{d LOCALQUANT_h}, {d LOCALQUANT_h} ];
                In DOM_allConducting;
                Jacobian JAC_vol;
                Integration Int;
            }

            Integral{
                DtDof[mu[] * Dof{LOCALQUANT_h}, {LOCALQUANT_h}];
                In DOM_total;
                Jacobian JAC_vol;
                Integration Int;
            }
            If(Flag_nl_iteration == 1) 
            Integral
            {
                JacNL[d_of_rho_wrt_j_TIMES_j[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}] * Dof{d LOCALQUANT_h} , {d LOCALQUANT_h_Derivative} ];
                In DOM_allWindings; 
                Jacobian JAC_vol;
                Integration Int; 
            }
            EndIf
            // the global term allows to link current and voltage in the cuts
            GlobalTerm{
                [ Dof{GLOBALQUANT_V}, {GLOBALQUANT_I} ];
                In DOM_airCuts;
            }

            Integral {
                [ kappa[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}] * Dof{d LOCALQUANT_T}, {d LOCALQUANT_T} ];
                In DOM_thermal;
                Jacobian JAC_vol;
                Integration Int;
            }
            Integral {
                DtDof[ Cv[{LOCALQUANT_T}, Norm[mu[] * {LOCALQUANT_h}]] * Dof{LOCALQUANT_T}, {LOCALQUANT_T} ];
                In DOM_thermal;
                Jacobian JAC_vol;
                Integration Int;
            }



 
            Integral {
                [ -(rho[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}] * {d LOCALQUANT_h}) * {d LOCALQUANT_h}, {LOCALQUANT_T} ];
                In DOM_resistiveHeating;
                Jacobian JAC_vol;
                Integration Int;
            }

            

            For i In {0:INPUT_NumOfTSAElements-1}
                    Integral {
                        [                   electromagneticMassFunctionNoDta1b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_hThinShell~{i + 1 - 1}},
                            {d LOCALQUANT_hThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   electromagneticStiffnessFunctiona1b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 1 - 1}},
                            {LOCALQUANT_hThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            electromagneticMassFunctionDta1b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 1 - 1}},
                            {LOCALQUANT_hThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
                    Integral {
                        [                   electromagneticMassFunctionNoDta1b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_hThinShell~{i + 1 - 1}},
                            {d LOCALQUANT_hThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   electromagneticStiffnessFunctiona1b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 1 - 1}},
                            {LOCALQUANT_hThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            electromagneticMassFunctionDta1b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 1 - 1}},
                            {LOCALQUANT_hThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
                    Integral {
                        [                   electromagneticMassFunctionNoDta2b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_hThinShell~{i + 2 - 1}},
                            {d LOCALQUANT_hThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   electromagneticStiffnessFunctiona2b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 2 - 1}},
                            {LOCALQUANT_hThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            electromagneticMassFunctionDta2b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 2 - 1}},
                            {LOCALQUANT_hThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
                    Integral {
                        [                   electromagneticMassFunctionNoDta2b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_hThinShell~{i + 2 - 1}},
                            {d LOCALQUANT_hThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   electromagneticStiffnessFunctiona2b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 2 - 1}},
                            {LOCALQUANT_hThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            electromagneticMassFunctionDta2b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_hThinShell~{i + 2 - 1}},
                            {LOCALQUANT_hThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
            EndFor

            

            For i In {0:INPUT_NumOfTSAElements-1}
             // row of the 1D FE matrix
                Integral {
                    [
                        - electromagneticRHSFunctionk1[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * SquNorm[
                            ({LOCALQUANT_hThinShell~{i + 1}} - {LOCALQUANT_hThinShell~{i}})/th_terminal_k
                        ],
                        {LOCALQUANT_TThinShell~{i + 1 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                } 

                Integral {
                    [
                        -electromagneticTripleFunctionk1a1b1[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 1 - 1}} * {d LOCALQUANT_hThinShell~{i + 1 - 1}},
                        {LOCALQUANT_TThinShell~{i + 1 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
                Integral {
                    [
                        -electromagneticTripleFunctionk1a1b2[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 1 - 1}} * {d LOCALQUANT_hThinShell~{i + 2 - 1}},
                        {LOCALQUANT_TThinShell~{i + 1 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
                Integral {
                    [
                        -electromagneticTripleFunctionk1a2b1[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 2 - 1}} * {d LOCALQUANT_hThinShell~{i + 1 - 1}},
                        {LOCALQUANT_TThinShell~{i + 1 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
                Integral {
                    [
                        -electromagneticTripleFunctionk1a2b2[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 2 - 1}} * {d LOCALQUANT_hThinShell~{i + 2 - 1}},
                        {LOCALQUANT_TThinShell~{i + 1 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
             // row of the 1D FE matrix
                Integral {
                    [
                        - electromagneticRHSFunctionk2[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * SquNorm[
                            ({LOCALQUANT_hThinShell~{i + 1}} - {LOCALQUANT_hThinShell~{i}})/th_terminal_k
                        ],
                        {LOCALQUANT_TThinShell~{i + 2 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                } 

                Integral {
                    [
                        -electromagneticTripleFunctionk2a1b1[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 1 - 1}} * {d LOCALQUANT_hThinShell~{i + 1 - 1}},
                        {LOCALQUANT_TThinShell~{i + 2 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
                Integral {
                    [
                        -electromagneticTripleFunctionk2a1b2[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 1 - 1}} * {d LOCALQUANT_hThinShell~{i + 2 - 1}},
                        {LOCALQUANT_TThinShell~{i + 2 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
                Integral {
                    [
                        -electromagneticTripleFunctionk2a2b1[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 2 - 1}} * {d LOCALQUANT_hThinShell~{i + 1 - 1}},
                        {LOCALQUANT_TThinShell~{i + 2 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
                Integral {
                    [
                        -electromagneticTripleFunctionk2a2b2[
                            {LOCALQUANT_TThinShell~{i}},
                            {LOCALQUANT_TThinShell~{i+1}}
                        ] * {d LOCALQUANT_hThinShell~{i + 2 - 1}} * {d LOCALQUANT_hThinShell~{i + 2 - 1}},
                        {LOCALQUANT_TThinShell~{i + 2 - 1}}
                    ];
                    In DOM_allInsulationSurface;
                    Integration Int;
                    Jacobian JAC_sur;
                }
            EndFor

            

            For i In {0:INPUT_NumOfTSAElements-1}
                    Integral {
                        [                   thermalMassFunctionNoDta1b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_TThinShell~{i + 1 - 1}},
                            {d LOCALQUANT_TThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   thermalStiffnessFunctiona1b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 1 - 1}},
                            {LOCALQUANT_TThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            thermalMassFunctionDta1b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 1 - 1}},
                            {LOCALQUANT_TThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
                    Integral {
                        [                   thermalMassFunctionNoDta1b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_TThinShell~{i + 1 - 1}},
                            {d LOCALQUANT_TThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   thermalStiffnessFunctiona1b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 1 - 1}},
                            {LOCALQUANT_TThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            thermalMassFunctionDta1b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 1 - 1}},
                            {LOCALQUANT_TThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
                    Integral {
                        [                   thermalMassFunctionNoDta2b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_TThinShell~{i + 2 - 1}},
                            {d LOCALQUANT_TThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   thermalStiffnessFunctiona2b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 2 - 1}},
                            {LOCALQUANT_TThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            thermalMassFunctionDta2b1[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 2 - 1}},
                            {LOCALQUANT_TThinShell~{i + 1 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
                    Integral {
                        [                   thermalMassFunctionNoDta2b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{d LOCALQUANT_TThinShell~{i + 2 - 1}},
                            {d LOCALQUANT_TThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        [                   thermalStiffnessFunctiona2b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 2 - 1}},
                            {LOCALQUANT_TThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }

                    Integral {
                        DtDof[
                            thermalMassFunctionDta2b2[
                                {LOCALQUANT_TThinShell~{i}},
                                {LOCALQUANT_TThinShell~{i+1}}
                            ] * Dof{LOCALQUANT_TThinShell~{i + 2 - 1}},
                            {LOCALQUANT_TThinShell~{i + 2 - 1}}
                        ];
                        In DOM_allInsulationSurface;
                        Integration Int;
                        Jacobian JAC_sur;
                    }
            EndFor

        }
    }



}

//======================================================================================
// Resolution: =========================================================================
//======================================================================================
Resolution{
    {
        Name RESOLUTION_stronglyCoupled;
        System{
            {
                Name SYSTEM_stronglyCoupled;
                NameOfFormulation FORMULATION_stronglyCoupled;
            }
        }

        Operation{
            InitSolution[SYSTEM_stronglyCoupled];
            PostOperation[POSTOP_maximumTemperature];

            SaveSolution[SYSTEM_stronglyCoupled];
            SetExtrapolationOrder[INPUT_extrapolationOrder];

            If(Flag_adaptive_time_stepping == 1)

                If(Flag_trackTimesPerTimeStep == 1)
                    Evaluate[$t_before = GetWallClockTime[]];
                EndIf

                TimeLoopAdaptive[
                    t_init,
                    t_end,
                    t_step_init,
                    t_step_min,
                    t_step_max,
                    "Euler",
                    List[INPUT_tAdaptiveBreakPoints],
                    PostOperation{
                        {
                            POSTOP_CONV_maximumTemperature,
                            rel_tol_adaptive_time_stepping,
                            abs_tol_adaptive_time_stepping,
                            LinfNorm 
                        }
                    }
                ]{
                    // Nonlinear solver starts +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                    If(Flag_nl_iteration == 1) 
                    IterativeLoopN[
                        NMaxIt,
                        relaxFactor,
                        PostOperation{
                            {
                                POSTOP_CONV_maximumTemperature,
                                nl_relTol_norm,
                                nl_absTol_norm,
                                LinfNorm 
                            }
                        }

                    ]{
                        GenerateJac SYSTEM_stronglyCoupled;
                        SolveJac SYSTEM_stronglyCoupled;

                    }
                    Else
                        Generate SYSTEM_stronglyCoupled;
                        Solve SYSTEM_stronglyCoupled;
                    EndIf
                    // Check if the solution is NaN and remove it
                    Test[$KSPResidual != $KSPResidual]{
                        Print["Critical: Removing NaN solution from the solution vector."];
                        RemoveLastSolution[SYSTEM_stronglyCoupled];
                    }
                    // Nonlinear solver ends +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                }{
                        PostOperation[POSTOP_maximumTemperature];
                        If(Flag_write_solution_to_disk == 1)
                            SaveSolution[SYSTEM_stronglyCoupled];
                        EndIf

                        If(Flag_trackTimesPerTimeStep == 1)
                            Evaluate[$t_diff = GetWallClockTime[] - $t_before];
                            Print[{$TimeStep, $t_diff}, Format "Time Step %g: WALL= %g", File "tracked_run_times.txt"]; 
                            Evaluate[$t_before = GetWallClockTime[]];
                        EndIf

                }
            Else

                TimeLoopTheta[
                    t_init,
                    t_end,
                    t_step_fct[],
                    t_theta
                ]{
                    // Nonlinear solver starts +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                    If(Flag_nl_iteration == 1) 
                    IterativeLoopN[
                        NMaxIt,
                        relaxFactor,
                        PostOperation{
                            {
                                POSTOP_CONV_maximumTemperature,
                                nl_relTol_norm,
                                nl_absTol_norm,
                                LinfNorm 
                            }
                        }

                    ]{
                        GenerateJac SYSTEM_stronglyCoupled;
                        SolveJac SYSTEM_stronglyCoupled;

                    }
                    Else
                        Generate SYSTEM_stronglyCoupled;
                        Solve SYSTEM_stronglyCoupled;
                    EndIf

                    // Check if the solution is NaN and remove it
                    Test[$KSPResidual != $KSPResidual]{
                        Print["Critical: Removing NaN solution from the solution vector."];
                        RemoveLastSolution[SYSTEM_stronglyCoupled];
                    }
                    // Nonlinear solver ends +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                    PostOperation[POSTOP_maximumTemperature];
                    If(Flag_write_solution_to_disk == 1)
                        SaveSolution[SYSTEM_stronglyCoupled];
                    EndIf
                }

            EndIf

            /*PostOperation[POSTOP_timeSeriesPlot_totalResistiveHeating];
            PostOperation[POSTOP_timeSeriesPlot_maximumTemperature];
            PostOperation[POSTOP_timeSeriesPlot_voltageBetweenTerminals];
            PostOperation[POSTOP_timeSeriesPlot_axialComponentOfTheMagneticField];
            */
            If(Flag_write_solution_to_disk == 2)
                SaveSolution SYSTEM_stronglyCoupled ;
            EndIf

            }
    }
}

//======================================================================================
// Post-processing: ====================================================================
//======================================================================================
PostProcessing{
    {
        Name POSTPRO_stronglyCoupled;
        NameOfFormulation FORMULATION_stronglyCoupled;
        NameOfSystem SYSTEM_stronglyCoupled;
        Quantity{
            {
                Name RESULT_magneticField; // magnetic flux density (magnetic field)
                Value{
                    Local{
                        [mu[] * {LOCALQUANT_h}];
                        In Region[{ DOM_total }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_magnitudeOfMagneticField; // magnetic flux density magnitude
                Value{
                    Local{
                        [Norm[mu[] * {LOCALQUANT_h}]];
                        In Region[{ DOM_total }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_currentDensity; // current density
                Value{
                    Local{
                        [{d LOCALQUANT_h}];
                        In Region[{ DOM_allConducting }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_magnitudeOfCurrentDensity; // current density magnitude
                Value{
                    Local{
                        [Norm[{d LOCALQUANT_h}]];
                        In Region[{ DOM_allConducting }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_resistivity; // current density magnitude
                Value{
                    Local{
                        [rho[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}]];
                        In Region[{ DOM_allConducting }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_arcLength;
                Value{
                    Local{
                        [Pancake3DGetContinuousArcLength[XYZ[]]{
                            0.005,
                            0.000129,
                            0,
                            0.0,
                            24,
                            1,
                            0.004,
                            0.01
                        }];
                        In DOM_allWindings;
                        Jacobian JAC_vol;
                    }
                }
            }
            {
                Name RESULT_arcLengthContactLayer;
                Value{
                    Local{
                        [Pancake3DGetContinuousArcLength_contactLayer[XYZ[]]{
                            0.005,
                            0.000129,
                            0,
                            0.0,
                            24,
                            1,
                            0.004,
                            0.01
                        }];
                        In DOM_allInsulationSurface;
                        Jacobian JAC_sur;
                    }
                }
            }
            {
                Name RESULT_turnNumberContactLayer;
                Value{
                    Local{
                        [Pancake3DGetContinuousTurnNumber_contactLayer[XYZ[]]{
                            0.005,
                            0.000129,
                            0,
                            0.0,
                            24,
                            1,
                            0.004,
                            0.01
                        }];
                        In DOM_allInsulationSurface;
                        Jacobian JAC_sur;
                    }
                }
            }
            {
                Name RESULT_turnNumber;
                Value{
                    Local{
                        [Pancake3DGetContinuousTurnNumber[XYZ[]]{
                            0.005,
                            0.000129,
                            0,
                            0.0,
                            24,
                            1,
                            0.004,
                            0.01
                        }];
                        In DOM_allWindings;
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_criticalCurrentDensity; // critical current density of the winding
                Value{
                    Local{
                        [Jcritical[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}]];
                        In Region[{ DOM_allWindings }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_criticalCurrent;
                Value{
                    Local{
                        [Icritical[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}]];
                        In Region[{ DOM_allWindings }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_currentSharingIndex;
                Value{
                    Local{
                        [lambda[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}]];
                        In Region[{ DOM_allWindings }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_jHTS;
                Value{
                    Local{
                        [jHTS[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}]];
                        In Region[{ DOM_allWindings }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_jHTSOverjCritical;
                Value{
                    Local{
                        // add small epsilon to avoid division by zero
                        [jHTS[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}]/(Jcritical[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}] + 1e-10)];
                        In Region[{ DOM_allWindings }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_magneticEnergy;
                Value{
                    Integral{
                        Type Global;
                        [1/2 * mu[] * {LOCALQUANT_h} * {LOCALQUANT_h}];
                        In DOM_total;
                        Jacobian JAC_vol;
                        Integration Int;
                    }
                }
            }

            {
                Name RESULT_inductance;
                Value{
                    Integral{
                        Type Global;
                        [mu[] * {LOCALQUANT_h} * {LOCALQUANT_h}];
                        In DOM_total;
                        Jacobian JAC_vol;
                        Integration Int;
                    }
                }
            }

            {
                Name RESULT_resistiveHeating; // resistive heating
                Value{
                    Local{
                        [(rho[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}] * {d LOCALQUANT_h}) * {d LOCALQUANT_h}];
                        In Region[{ DOM_resistiveHeating }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_voltageBetweenTerminals; // voltages in cuts
                Value{
                    Local{
                        [ - {GLOBALQUANT_V} ];
                        In DOM_terminalCut;
                    }
                }
            }

            {
                Name RESULT_currentThroughCoil; // currents in cuts
                Value{
                    Local{
                        [ {GLOBALQUANT_I} ];
                        In DOM_terminalCut;
                    }
                }
            }


            {
                Name RESULT_axialComponentOfTheMagneticField; // axial magnetic flux density
                Value{
                    Local{
                        [ CompZ[mu[] * {LOCALQUANT_h}] ];
                        In DOM_total;
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_totalResistiveHeating; // total resistive heating for convergence
                Value{
                    Integral{
                        Type Global;
                        [(rho[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}, {d LOCALQUANT_h}] * {d LOCALQUANT_h}) * {d LOCALQUANT_h}];
                        In DOM_resistiveHeating;
                        Jacobian JAC_vol;
                        Integration Int;
                    }

                        For i In {0:INPUT_NumOfTSAElements-1}
                            Integral {
                                Type Global;
                                [
                                    electromagneticOnlyFunction[
                                        {LOCALQUANT_TThinShell~{i}},
                                        {LOCALQUANT_TThinShell~{i+1}}
                                    ] * SquNorm[
                                        ({LOCALQUANT_hThinShell~{i + 1}} - {LOCALQUANT_hThinShell~{i}})/th_terminal_k
                                    ]
                                ];
                                In DOM_allInsulationSurface;
                                Integration Int;
                                Jacobian JAC_sur;
                            } 
                        
                            Integral {
                                Type Global;
                                [
                                    electromagneticMassFunctionNoDta1b1[
                                        {LOCALQUANT_TThinShell~{i}},
                                        {LOCALQUANT_TThinShell~{i+1}}
                                    ] * {d LOCALQUANT_hThinShell~{i + 1 - 1}} * {d LOCALQUANT_hThinShell~{i + 1 - 1}}
                                ];
                                In DOM_allInsulationSurface;
                                Integration Int;
                                Jacobian JAC_sur;
                            }
                            Integral {
                                Type Global;
                                [
                                    electromagneticMassFunctionNoDta1b2[
                                        {LOCALQUANT_TThinShell~{i}},
                                        {LOCALQUANT_TThinShell~{i+1}}
                                    ] * {d LOCALQUANT_hThinShell~{i + 1 - 1}} * {d LOCALQUANT_hThinShell~{i + 2 - 1}}
                                ];
                                In DOM_allInsulationSurface;
                                Integration Int;
                                Jacobian JAC_sur;
                            }
                            Integral {
                                Type Global;
                                [
                                    electromagneticMassFunctionNoDta2b1[
                                        {LOCALQUANT_TThinShell~{i}},
                                        {LOCALQUANT_TThinShell~{i+1}}
                                    ] * {d LOCALQUANT_hThinShell~{i + 2 - 1}} * {d LOCALQUANT_hThinShell~{i + 1 - 1}}
                                ];
                                In DOM_allInsulationSurface;
                                Integration Int;
                                Jacobian JAC_sur;
                            }
                            Integral {
                                Type Global;
                                [
                                    electromagneticMassFunctionNoDta2b2[
                                        {LOCALQUANT_TThinShell~{i}},
                                        {LOCALQUANT_TThinShell~{i+1}}
                                    ] * {d LOCALQUANT_hThinShell~{i + 2 - 1}} * {d LOCALQUANT_hThinShell~{i + 2 - 1}}
                                ];
                                In DOM_allInsulationSurface;
                                Integration Int;
                                Jacobian JAC_sur;
                            }
                        EndFor
 
                }
            }
            {
                Name RESULT_temperature;
                Value {
                    Local{
                        [{LOCALQUANT_T}];
                        In DOM_thermal;
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_maximumTemperature; // maximum temperature
                Value{
                    Term {
                        Type Global;
                        [ #999 ];
                        In DOM_thermal;
                    }
                }
            }

            {
                Name RESULT_heatFlux;
                Value {
                    Local{
                        [-kappa[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}] * {d LOCALQUANT_T}];
                        In DOM_thermal;
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_magnitudeOfHeatFlux;
                Value {
                    Local{
                        [Norm[-kappa[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}] * {d LOCALQUANT_T}]];
                        In DOM_thermal;
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_thermalConductivity; // current density magnitude
                Value{
                    Local{
                        [kappa[{LOCALQUANT_T}, mu[] * {LOCALQUANT_h}]];
                        In Region[{ DOM_thermal }];
                        Jacobian JAC_vol;
                    }
                }
            }

            {
                Name RESULT_specificHeatCapacity; // current density magnitude
                Value{
                    Local{
                        [Cv[{LOCALQUANT_T}, Norm[mu[] * {LOCALQUANT_h}]]];
                        In Region[{ DOM_thermal }];
                        Jacobian JAC_vol;
                    }
                }
            }

 {
                Name RESULT_debug;
                Value{
                    Local{
                        [ 5 ];
                        In DOM_allInsulationSurface;
                        Jacobian JAC_sur;
                    }
                }
            }
        }
    }

}

//======================================================================================
// Post-operation: =====================================================================
//======================================================================================
PostOperation{
    {
        Name ERIK_THESIS_PARAREAL;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            Print[
                RESULT_axialComponentOfTheMagneticField,
                OnPoint {0.0, 0.0, 0.0},
                File "ERIK_THESIS_PARAREAL_field.pos",
                Format TimeTable
            ];

            Print[
                RESULT_magneticEnergy,
                OnGlobal,
                File "ERIK_THESIS_PARAREAL_magneticEnergy.pos",
                Format TimeTable
            ];

            Print[
                RESULT_voltageBetweenTerminals,
                OnRegion DOM_terminalCut,
                File "ERIK_THESIS_PARAREAL_voltage.pos",
                Format TimeTable
            ];

            /*Print[
                RESULT_temperature,
                OnPoint {-0.005773477871703055, -8.190356057401254e-06, 0.0},
                File "ERIK_THESIS_PARAREAL_temperature.pos",
                Format TimeTable
            ];*/

            Print[
                RESULT_totalResistiveHeating,
                OnGlobal,
                File "ERIK_THESIS_PARAREAL_resistiveHeating.pos",
                Format TimeTable
            ];

        }
    }
 {
        Name POSTOP_debug;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // 3D magnetic field vector field:
            
            Print[
                RESULT_debug,
                OnElementsOf DOM_allInsulationSurface,
                File "debug-DefaultFormat.pos",
                Name "Debug Variable"
            ];

        }
    }
    {
        Name POSTOP_magneticField;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // 3D magnetic field vector field:
            
            Print[
                RESULT_magneticField,
                OnElementsOf DOM_total,
                File "MagneticField-DefaultFormat.pos",
                Name "Magnetic Field [T]"
            ];

        }
    }
    {
        Name POSTOP_magnitudeOfMagneticField;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // 3D magnetic field magnitude scalar field:
            
            Print[
                RESULT_magnitudeOfMagneticField,
                OnElementsOf DOM_total,
                File "MagneticFieldMagnitude-DefaultFormat.pos",
                Name "The Magnitude of the Magnetic Field [T]"
            ];

        }
    }
    {
        Name POSTOP_currentDensity;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // 3D current density vector field:
            
            Print[
                RESULT_currentDensity,
                OnElementsOf DOM_allConducting,
                File "CurrentDensity-DefaultFormat.pos",
                Name "Current Density [A/m^2]"
            ];

        }
    }
    {
        Name POSTOP_magnitudeOfCurrentDensity;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // 3D current density vector field:
            
            Print[
                RESULT_magnitudeOfCurrentDensity,
                OnElementsOf DOM_allConducting,
                File "CurrentDensityMagnitude-DefaultFormat.pos",
                Name "The Magnitude of the Current Density [A/m^2]"
            ];

        }
    }
    {
        Name POSTOP_arcLength;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_arcLength,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "arcLength-DefaultFormat.pos",
                LastTimeStepOnly 1,
                Name "Arc Length [m]"
            ];

        }
    }
    {
        Name POSTOP_arcLengthContactLayer;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_arcLengthContactLayer,
                OnElementsOf DOM_allInsulationSurface,
                File "arcLengthContactLayer-DefaultFormat.pos",
                LastTimeStepOnly 1,
                Name "Arc Length Contact Layer [m]"
            ];

        }
    }
    {
        Name POSTOP_turnNumberContactLayer;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_turnNumberContactLayer,
                OnElementsOf DOM_allInsulationSurface,
                File "turnNumberContactLayer-DefaultFormat.pos",
                LastTimeStepOnly 1,
                Name "Turn number contact layer [m]"
            ];

        }
    }
    {
        Name POSTOP_turnNumber;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_turnNumber,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "turnNumber-DefaultFormat.pos",
                LastTimeStepOnly 1,
                Name "Turn number [m]"
            ];

        }
    }
    {
        Name POSTOP_resistiveHeating;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Resistive heating:
            
            Print[
                RESULT_resistiveHeating,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "ResistiveHeating_Windings-DefaultFormat.pos",
                Name "Resistive Heating Windings [W/m^3]"
            ];


            
            Print[
                RESULT_resistiveHeating,
                OnElementsOf DOM_allConductingWithoutWindings,
                File "ResistiveHeating-DefaultFormat.pos",
                Name "Resistive Heating Without Windings [W/m^3]"
            ];

        }
    }
    {
        Name POSTOP_resistivity;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Resistive heating:
            
            Print[
                RESULT_resistivity,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "Resistivity_Windings-DefaultFormat.pos",
                Name "Resistivity Windings [Ohm*m]"
            ];


            
            Print[
                RESULT_resistivity,
                OnElementsOf DOM_allConductingWithoutWindings,
                File "Resistivity_ConductingWithoutWindings-DefaultFormat.pos",
                Name "Resistivity Without Windings [Ohm*m]"
            ];

        }
    }
    {
        Name POSTOP_inductance;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Current at the cut:
            
            Print[
                RESULT_inductance,
                OnGlobal,
                File "Inductance-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                LastTimeStepOnly 1,
                Name "Inductance [H]"
            ];

        }
    }
    {
        Name POSTOP_timeConstant;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Current at the cut:
            
            Print[
                RESULT_axialComponentOfTheMagneticField,
                OnPoint {0, 0, 0},
                File "axialComponentOfTheMagneticFieldForTimeConstant-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                Name "The Magnitude of the Magnetic Field [T]"
            ];

        }
    }
    {
        Name POSTOP_criticalCurrentDensity;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Critical current density:
            
            Print[
                RESULT_criticalCurrentDensity,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "CriticalCurrentDensity-DefaultFormat.pos",
                Name "Critical Current Density [A/m^2]"
            ];

        }
    }
    {
        Name POSTOP_criticalCurrent;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Critical current:
            
            Print[
                RESULT_criticalCurrent,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "CriticalCurrent-DefaultFormat.pos",
                Name "Critical Current [A]"
            ];

        }
    }
    {
        Name POSTOP_currentSharingIndex;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Critical current:
            
            Print[
                RESULT_currentSharingIndex,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "currentSharingIndex-DefaultFormat.pos",
                Name "Current Sharing Index [-]"
            ];

        }
    }
    {
        Name POSTOP_jHTS;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Current density in HTS layer:
            
            Print[
                RESULT_jHTS,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "jHTS-DefaultFormat.pos",
                Name "Current Density in HTS Layer [A/m^2]"
            ];

        }
    }
    {
        Name POSTOP_jHTSOverjCritical;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Normalized HTS current density:
            
            Print[
                RESULT_jHTSOverjCritical,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "HTSCurrentDensityOverCriticalCurrentDensity-DefaultFormat.pos",
                Name "(HTS Current Density)/(Critical Current Density)"
            ];

        }
    }
    // {
    //     Name POSTOP_Ic;
    //     NameOfPostProcessing POSTPRO_stronglyCoupled;
    //     LastTimeStepOnly 1;
    //     Operation {
    //         Print[
    //             RESULT_criticalCurrent,
    //             OnElementsOf DOM_allWindings,
    //             StoreMinInRegister 1
    //         ];
    //     }
    // }
    {
        Name POSTOP_I;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        LastTimeStepOnly 1;
        Operation {
            Print[
                RESULT_currentThroughCoil,
                OnRegion DOM_terminalCut,
                Format Table,
                StoreInVariable $I
            ];
        }
    }
    {
        Name POSTOP_voltageBetweenTerminals;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Voltage at the cut:
            
            Print[
                RESULT_voltageBetweenTerminals,
                OnRegion DOM_terminalCut,
                File "VoltageBetweenTerminals-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                Name "Voltage [V]"
            ];

        }
    }
    {
        Name POSTOP_currentThroughCoil;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Current at the cut:
            
            Print[
                RESULT_currentThroughCoil,
                OnRegion DOM_terminalCut,
                File "CurrentThroughCoil-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                Name "Current [A]"
            ];

        }
    }
    {
        Name POSTOP_maximumTemperature;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation {
            Print[ RESULT_temperature, 
                    OnElementsOf DOM_thermal, 
                    StoreMaxInRegister 999, 
                    Format Table,
                    LastTimeStepOnly 1, 
                    SendToServer "No",
                    File "maximumTemperature_dump.txt"
                ] ;
            // We can print the maximum temperature at any region that is part
            // of the thermal domain since the `StoreMaxInRegister` command
            // already searches all of the thermal region for the maximum and
            //populates the same value for all physical regions of the thermal 
            // domain.
            // Printing in just one domain makes the parsing of the output easier.
            
            Print[
                RESULT_maximumTemperature,
                OnRegion Region[1000000],
                File "ERIK_THESIS_PARAREAL_temperature.pos",
                Format TimeTable,
                LastTimeStepOnly 1,
                AppendToExistingFile 1,
                NoTitle,
                Name "Maximum temperature [K]"
            ];

        }
    }
    {
        Name POSTOP_temperature;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation {
            // 3D temperature scalar field:
            
            Print[
                RESULT_temperature,
                OnElementsOf DOM_thermal,
                File "Temperature-DefaultFormat.pos",
                Name "Temperature [K]"
            ];

        }
    }
    {
        Name POSTOP_heatFlux;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation {
            // 3D temperature scalar field:
            
            Print[
                RESULT_heatFlux,
                OnElementsOf DOM_thermal,
                File "HeatFlux-DefaultFormat.pos",
                Name "Heat Flux [W/m^2]"
            ];

        }
    }
    {
        Name POSTOP_thermalConductivity;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Thermal conductivity:
            
            Print[
                RESULT_thermalConductivity,
                OnElementsOf DOM_allWindings,
                AtGaussPoints 9,
                File "thermalConductivity_Windings-DefaultFormat.pos",
                Name "Thermal Conductivity Windings [W/(m*K)]"
            ];


            
            Print[
                RESULT_thermalConductivity,
                OnElementsOf DOM_allConductingWithoutWindings,
                File "thermalConductivity_ConductingWithoutWindings-DefaultFormat.pos",
                Name "Thermal Conductivity Without Windings [W/(m*K)]"
            ];

        }
    }
    {
        Name POSTOP_specificHeatCapacity;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            // Specific heat:
            
            Print[
                RESULT_specificHeatCapacity,
                OnElementsOf DOM_thermal,
                File "specificHeatCapacity-DefaultFormat.pos",
                Name "Specific Heat Capacity [J/(kg*K)]"
            ];

        }
    }
    {
        Name POSTOP_timeSeriesPlot_totalResistiveHeating;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_totalResistiveHeating,
                OnGlobal,
                File "totalResistiveHeating(TimeSeriesPlot)-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                Name "totalResistiveHeating(TimeSeriesPlot)"
            ];

        }
    }
    {
        Name POSTOP_timeSeriesPlot_maximumTemperature;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
        }
    }
    {
        Name POSTOP_timeSeriesPlot_voltageBetweenTerminals;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_voltageBetweenTerminals,
                OnRegion DOM_terminalCut,
                File "voltageBetweenTerminals(TimeSeriesPlot)-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                Name "voltageBetweenTerminals(TimeSeriesPlot)"
            ];

        }
    }
    {
        Name POSTOP_timeSeriesPlot_axialComponentOfTheMagneticField;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation{
            
            Print[
                RESULT_axialComponentOfTheMagneticField,
                OnPoint {0.0, 0.0, 0.0},
                File "axialComponentOfTheMagneticField(TimeSeriesPlot)-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                Name "axialComponentOfTheMagneticField(TimeSeriesPlot)"
            ];

        }
    }
    // convergence criteria as postoperations:
    {
        Name POSTOP_CONV_maximumTemperature;
        NameOfPostProcessing POSTPRO_stronglyCoupled;
        Operation {
            Print[ RESULT_temperature,
                OnElementsOf DOM_thermal,
                StoreMaxInRegister 999,
                Format Table,
                LastTimeStepOnly 1,
                SendToServer "No"
             ] ;

            
            Print[
                RESULT_maximumTemperature,
                OnRegion DOM_thermal,
                File "RESULT_maximumTemperature-TimeTableFormat.csv",
                Format TimeTable,
                Comma,
                LastTimeStepOnly 1,
                AppendToExistingFile 1,
                Name "Maximum temperature [K]"
            ];

        } 
    }

}