# Parareal Implementation in Python to Study Transient Phenomena in No-Insulation Superconducting Coils

This Python code accompanies the paper E. Schnaubelt et al. "Parallel-in-Time Integration of Transient Phenomena in No-Insulation Superconducting Coils Using Parareal", accepted after peer review for the conference proceedings of the "15th International Conference on Scientific Computing in Electrical Engineering" (SCEE 2024). The code has been updated slightly for chapter 6 "Three-Dimensional Magneto-Thermal Simulation of Stacks of No-Insulation Pancake Coils" in E. Schnaubelt, "Models and Methods for Transient Magneto-Thermal Finite Element Simulation of Superconducting Magnets", Ph.D. thesis, Technische Universität Darmstadt, 2025.

## Installation/Getting started

In order to run this code, you need to [download Python](https://www.python.org/downloads/). The results of the paper have been created using Version 3.11.8 on AlmaLinux 9. 

Next, you will need to install the Python requirements. This is easiest via [pip](https://pip.pypa.io/en/stable/installation/). You will need to install all the packages in the `requirements.txt`. This can be conveniently done from the command line by invoking `pip install -r requirements.txt`. Most modern IDEs will have inbuilt features to install packages from a `requirements.txt`.

Last, to run the [GetDP](https://www.getdp.info) model of the superconducting pancake coil, you need a special version called [CERNGetDP](https://gitlab.cern.ch/steam/cerngetdp) that contains all necessary material laws and other functionality. The version used for the paper is [2025.2.1](https://gitlab.cern.ch/steam/cerngetdp/-/releases/2025.2.1). It can be downloaded for [Windows](https://cernbox.cern.ch/remote.php/dav/public-files/n6BIGib9k2OKA2B/Windows/cerngetdp_2025.2.1.zip) or [Linux](https://cernbox.cern.ch/remote.php/dav/public-files/n6BIGib9k2OKA2B/Linux/cerngetdp_2025.2.1.tar.gz). All releases are found in the [CERNBox](https://cernbox.cern.ch/s/n6BIGib9k2OKA2B). 

By default, the ´CERNGetDP´ executable should be placed in the path such that one can simply call `getdp`. This can be changed by editing the variable `getdp_path` in `run_parareal_coupledPancake.py`.

You can check if everything runs by running `python run_parareal_coupledPancake.py`. This default call, e.g. `python run_parareal_coupledPancake.py` will run a `joblib`-parallel version of the Parareal implementation. To use `MPI`, make sure you have it installed in your operating system and invoke `mpiexec -N 8 python run_parareal_coupledPancake.py` for 8 `MPI` tasks. 

To run on an HTCondor system, you can simply call `./condor_submit.sh` which will schedule as many jobs as there are different combinations in `HTCondor_combinations.txt`. It will then call `run_parareal_coupledPancake_HTCondor.py` which takes some command line inputs passed via HTCondor's `queue` mechanism.

## File Structure 

The files and directories are 

- `parareal.py`: implementation of Parareal in Python taking functions as coarse and solve integrators. 
- `getdp_runner.py`: implements `solve_ivp_getdp`, a function to solve initial value problems using GetDP with syntax inspired by `scipy`
- `getdp_read_presolution.py`: helper function for `getdp_runner`; reads a specific type of file (`.pre`) created by GetDP 
- `getdp_create_preresolution.py`: helper function for `getdp_runner`; creates a specific type of file (`.pre`) created by GetDP
- `run_parareal_coupledPancake.py`: main runner file invoking the pancake coil Parareal run using the GetDP model, which is located in `getdp_models`
- `getdp_models/`: folder containing the no-insulation superconducting coil, for more info on GetDP see [the GetDP website](https://www.getdp.info) and for more info one the coil model, see [this IEEE Trans. Appl. Supercond. paper](https://ieeexplore.ieee.org/document/10349801).

The following files are only used for HTCondor systems:
- `condor_submit.sh`: shell script to submit jobs to HTCondor conveniently
- `run_parareal_coupledPancake_HTCondor.py`: main runner file for usage in HTCondor
- `HTCondor_submission.sub`: submission file for HTCondor describing number of CPUS, memory etc. requirements
- `HTCondor_combinations.txt`: the different combinations that are queued by `HTCondor_submission.sub`, where they are defined in the parameter `arguments`