This is a collection of [FiQuS](https://gitlab.cern.ch/steam/fiqus) input files for the simulation of no-insulated pancake coils in chapter 6 "Three-Dimensional Magneto-Thermal Simulation of Stacks of No-Insulation Pancake Coils" in E. Schnaubelt, "Models and Methods for Transient Magneto-Thermal Finite Element Simulation of Superconducting Magnets", Ph.D. thesis, Technische Universität Darmstadt, 2025.

The repository is also available on [Zenodo](https://doi.org/10.5281/zenodo.14993690) for long-term storage.

## Getting Started

1. Install [Python 3.11.8](https://www.python.org/downloads/release/python-3118/).
2. Download the CERNGetDP 2025.2.1 release from [here](https://gitlab.cern.ch/steam/cerngetdp/-/releases/2025.2.1) and extract it to your favorite location.
3. If you haven't done already, clone this repository by running the code below in a terminal
    ```bash
    git clone ssh://git@gitlab.cern.ch:7999/eschnaub/thesis_pancake_inputs.git
    ```
    or download it as a zip from [here](https://gitlab.cern.ch/eschnaub/thesis_pancake_inputs/-/archive/master/thesis_pancake_inputs-master.zip).
4. Update `getdp_path` in the `run_fiqus.py` script to point the path to the GetDP executable downloaded in step 2. It should look something like this:
    ```python
    getdp_path = os.path.join('C:', 'Program Files', 'CERNGetDP', 'cerngetdp_2025.2.1', 'getdp_2025.2.1.exe') # Windows
    # OR
    getdp_path = "/some/path/to/getdp/getdp_2025.2.1" # Linux
    # OR
    getdp_path = "getdp" # If GetDP is in the $PATH with alias getdp	
    ```
5.  Install `FiQuS 2025.2.0` by running one of the codes below in a terminal
```bash
pip install fiqus==2025.2.0
```
or
```
pip install -r requirements.txt
```
Consider activating a [virtual environment](https://docs.python.org/3/library/venv.html) before to avoid conflicts with other Python packages.

## Running models

To run the provided input files, you can use the `run_fiqus.py` script. This script will automatically generate the necessary files and run the simulation using FiQuS.
```bash
python run_fiqus.py
```
This assumes that `python` is in your `$PATH`. If you have installed Python 3.11.8 in a virtual environment, make sure to activate it before running the script. 

The default model is the characteristic time simulation for the heated soldered metal insulation coil 1 (HSMI1). To change it, change the `input_folder` and `magnet_name` following the example for HSMI1 in the `run_fiqus.py` script.