{% import "materials.pro" as materials %}

stop_temperature = <<dm.magnet.solve.thermal.time_stepping.stop_temperature>>;

/* -------------------------------------------------------------------------- */

Group {

  {% for name, number in zip(rm.powered.names + rm.conducting.names + rm.insulator_kapton.names + rm.insulator_G10.names,
                             rm.powered.numbers + rm.conducting.numbers + rm.insulator_kapton.numbers + rm.insulator_G10.numbers) %}
    <<name>> = Region[ <<number>> ];
  {% endfor %}

  {% for bnd_type in rm.boundaries %}
    {% for bnd_group_names, bnd_group_numbers in zip(rm.boundaries[bnd_type].names, rm.boundaries[bnd_type].numbers) %}
      {% for name, number in zip(bnd_group_names, bnd_group_numbers) %}
        {% if name %}
          <<name>> = Region[ <<number>> ];
        {% endif %}
      {% endfor %}
    {% endfor %}
  {% endfor %}

{% for cond_name in dm.conductors.keys() %}
  <<nc.omega>><<nc.powered>>_<<cond_name>> = Region[ {<<rm.powered.names|join(', ')>>} ];
{% endfor %}
  <<nc.omega>><<nc.powered>> = Region[ {<<nc.omega>><<nc.powered>>_<<dm.conductors.keys()|join(', ' + nc.omega + nc.powered + '_')>>} ];

  <<nc.omega>><<nc.conducting>> = Region[ {<<rm.conducting.names|join(', ')>>} ];

{% set ins_materials = ['kapton', 'G10'] %}
  <<nc.omega>><<nc.insulator>>_kapton = Region[ {<<rm.insulator_kapton.names|join(', ')>>} ];
  <<nc.omega>><<nc.insulator>>_G10 = Region[ {<<rm.insulator_G10.names|join(', ')>>} ];
  <<nc.omega>><<nc.insulator>> = Region[ {<<nc.omega>><<nc.insulator>>_<<ins_materials|join(', ' + nc.omega + nc.insulator + '_')>>} ];

  <<nc.omega>> = Region[ {<<nc.omega>><<nc.powered>>, <<nc.omega>><<nc.conducting>>, <<nc.omega>><<nc.insulator>>} ];

  {% if dm.magnet.solve.thermal.jc_degradation_to_zero.turns %}
    icZero = Region[{ht<<dm.magnet.solve.thermal.jc_degradation_to_zero.turns|join(', ht')>>}];
  {% else %}
    icZero = Region[{}];
  {% endif %}

//jc[] = $Time > thresh? 0: someVal;
{% for name, cond in dm.conductors.items() %}
  jcNonZero_<<name>> = Region[<<nc.omega>><<nc.powered>>_<<name>>];
  {% if 'ht' + str(dm.magnet.solve.thermal.jc_degradation_to_zero.turns[0]) in rm.powered.names %}
  jcNonZero_<<name>> -= Region[icZero];
  {% endif %}
{% endfor %}

{% for nr, names in enumerate(rm.boundaries.temperature.names) %}
  <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.temperature)[nr]>> = Region[ {<<names|join(', ')>>} ];
{% endfor %}

{% for nr, names in enumerate(rm.boundaries.heat_flux.names) %}
  {% if dm.magnet.solve.thermal.He_cooling.sides != 'external' and nr == 0 %}
  general_adiabatic = Region[ {<<names|join(', ')>>} ];
  {% else %}
  <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.heat_flux)[nr - 1 if dm.magnet.solve.thermal.He_cooling.sides != 'external' else nr]>> = Region[ {<<names|join(', ')>>} ];
  {% endif %}
{% endfor %}

{% for nr, names in enumerate(rm.boundaries.cooling.names) %}
  {% if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' and nr == 0 %}
  general_cooling = Region[ {<<names|join(', ')>>} ];
  {% else %}
  <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.cooling)[nr - 1 if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' else nr]>> = Region[ {<<names|join(', ')>>} ];
  {% endif %}
{% endfor %}

  Bnds_dirichlet = Region[ {<<dm.magnet.solve.thermal.overwrite_boundary_conditions.temperature|join(', ')>>} ];
  Bnds_neumann = Region[ {{% if dm.magnet.solve.thermal.He_cooling.sides != 'external' %}general_adiabatic{% endif %}{% if dm.magnet.solve.thermal.overwrite_boundary_conditions.heat_flux %}, <<dm.magnet.solve.thermal.overwrite_boundary_conditions.heat_flux|join(', ')>>{% endif %}} ];
  Bnds_robin = Region[ {{% if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' %}general_cooling{% endif %}{% if dm.magnet.solve.thermal.overwrite_boundary_conditions.cooling %}, <<dm.magnet.solve.thermal.overwrite_boundary_conditions.cooling|join(', ')>>{% endif %}} ];
  Bnds_support = Region[ {Bnds_neumann, Bnds_robin} ];

}

Function {
  // time steps adaptive time stepping must hit
  Breakpoints = {<<dm.magnet.solve.thermal.time_stepping.breakpoints|join(', ')>>};

  // --------------- MATERIAL FUNCTIONS ----------------------------------------
{% set criticalCurrentDensityMacroName = {'Nb-Ti_CUDI1': 'MATERIAL_CriticalCurrentDensity_NiobiumTitanium_CUDI1_T'} %}
{% set resistivityMacroName = {'Cu': 'MATERIAL_Resistivity_Copper_T', 'SS': 'MATERIAL_Resistivity_SSteel_T'} %}
{% set thermalConductivityMacroName = {'Cu': 'MATERIAL_ThermalConductivity_Copper_T', 'SS': 'MATERIAL_ThermalConductivity_SSteel_T',
                                       'kapton': 'MATERIAL_ThermalConductivity_Kapton_T', 'G10': 'MATERIAL_ThermalConductivity_G10_T'} %}
{% set specificHeatCapacityMacroName = {'Cu': 'MATERIAL_SpecificHeatCapacity_Copper_T', 'SS': 'MATERIAL_SpecificHeatCapacity_SSteel_T',
                                        'Nb-Ti': 'MATERIAL_SpecificHeatCapacity_NiobiumTitanium_T',
                                        'kapton': 'MATERIAL_SpecificHeatCapacity_Kapton_T', 'G10': 'MATERIAL_SpecificHeatCapacity_G10_T', 
                                        'helium': 'MATERIAL_SpecificHeatCapacity_Helium_T'} %}

{% for name, cond in dm.conductors.items() %}
  {% if cond.cable.f_inner_voids and cond.cable.f_outer_voids %}
  f_inner_voids_<<name>> = <<cond.cable.f_inner_voids>>;
  f_outer_voids_<<name>> = <<cond.cable.f_outer_voids>>;
  f_strand_<<name>> = 1.0 - (<<cond.cable.f_inner_voids>> + <<cond.cable.f_outer_voids>>);
  {% else %}
  {% if cond.strand.type == 'Round' %}
    {% set n_strands = cond.cable.n_strands %}
    {% set A_Strand = cond.cable.n_strands * Pi/4.0 * cond.strand.diameter**2 %}
  {% elif cond.strand.type == 'Rectangular' %}
    {% set n_strands = cond.cable.n_strands if cond.cable.type == 'Rutherford' else 1 %}
    {% set A_Strand = n_strands * cond.strand.bare_width * cond.strand.bare_height %}
  {% endif %}
  {% set A_cable = cond.cable.bare_cable_width * cond.cable.bare_cable_height_mean %}

  {% set f_both_voids = 1.0 - A_Strand / A_cable %}
  {% set f_inner_voids = f_both_voids * (0.5 - 1.0/n_strands) %}
  {% set f_outer_voids = f_both_voids * (0.5 + 1.0/n_strands) %}

  f_inner_voids_<<name>> = <<f_inner_voids>>;
  f_outer_voids_<<name>> = <<f_outer_voids>>;
  f_strand_<<name>> = 1.0 - <<f_both_voids>>;
  {% endif %}

  f_stabilizer_<<name>> = f_strand_<<name>> * <<cond.strand.Cu_noCu_in_strand>> / (1. + <<cond.strand.Cu_noCu_in_strand>>);
  f_sc_<<name>> = f_strand_<<name>> * (1.0 - <<cond.strand.Cu_noCu_in_strand>> / (1. + <<cond.strand.Cu_noCu_in_strand>>));
{% endfor %}

source_current = <<dm.power_supply.I_initial>>;

{% for name, cond in dm.conductors.items() %}
{% if cond.Jc_fit.type == 'CUDI1' %}
  {% if cond.strand.type == 'Round' %}
    {% set wire_diameter = (cond.cable.n_strands)**(1/2) * cond.strand.diameter %}
  {% elif cond.strand.type == 'Rectangular' %}
    {% set wire_diameter = (4 * cond.cable.n_strands * cond.strand.bare_width * cond.strand.bare_height / Pi) ** (1 / 2) %}
  {% endif %}
  criticalCurrentDensity[jcNonZero_<<name>>] = <<materials[criticalCurrentDensityMacroName[cond.strand.material_superconductor + '_' + cond.Jc_fit.type]](C1=cond.Jc_fit.C1_CUDI1, C2=cond.Jc_fit.C2_CUDI1, Tc0=cond.Jc_fit.Tc0_CUDI1, Bc20=cond.Jc_fit.Bc20_CUDI1, wireDiameter=wire_diameter, Cu_noCu=cond.strand.Cu_noCu_in_strand)>> * f_sc_<<name>>;
{% elif cond.Jc_fit.type == 'Summers' %}
  criticalCurrentDensity[jcNonZero_<<name>>] = <<materials[criticalCurrentDensityMacroName[cond.strand.material_superconductor + '_' + cond.Jc_fit.type]](Jc0=cond.Jc_fit.Jc0_Summers, Tc0=cond.Jc_fit.Tc0_Summers, Bc20=cond.Jc_fit.Bc20_Summers)>> * f_sc_<<name>>;
{% elif cond.Jc_fit.type == 'Bordini' %}
  criticalCurrentDensity[jcNonZero_<<name>>] = <<materials[criticalCurrentDensityMacroName[cond.strand.material_superconductor + '_' + cond.Jc_fit.type]](Tc0=cond.Jc_fit.Tc0_Bordini, Bc20=cond.Jc_fit.Bc20_Bordini, C0=cond.Jc_fit.C0_Bordini, alpha=cond.Jc_fit.alpha_Bordini)>> * f_sc_<<name>>;
{% elif cond.Jc_fit.type == 'BSCCO_2212_LBNL' %}
  criticalCurrentDensity[jcNonZero_<<name>>] = <<materials[criticalCurrentDensityMacroName[cond.strand.material_superconductor + '_' + cond.Jc_fit.type]](f_scaling=cond.Jc_fit.f_scaling_Jc_BSCCO2212)>> * f_sc_<<name>>;
{% endif %}
{% endfor %}
  criticalCurrentDensity[icZero] = 0;

{% for name, cond in dm.conductors.items() %}
  rho[<<nc.omega>><<nc.powered>>_<<name>>] = EffectiveResistivity[<<materials[resistivityMacroName[cond.strand.material_stabilizer]](RRR=cond.strand.RRR, RRRRefTemp=cond.strand.T_ref_RRR_high)>>]
                                                {f_stabilizer_<<name>>};
{% endfor %}

  // effective thermal conductivity of the bare part
{% for name, cond in dm.conductors.items() %}
kappa[<<nc.omega>><<nc.powered>>_<<name>>] = RuleOfMixtures[
  <<materials[thermalConductivityMacroName[cond.strand.material_stabilizer]
](RRR=cond.strand.RRR)>>
{% if cond.cable.material_inner_voids != 'helium' %}
, <<materials[thermalConductivityMacroName[cond.cable.material_inner_voids]]()>>
{% endif %}
{% if cond.cable.material_outer_voids != 'helium' %}
, <<materials[thermalConductivityMacroName[cond.cable.material_outer_voids]]()>>
{% endif %}
]
{f_stabilizer_<<name>>
{% if cond.cable.material_inner_voids != 'helium' %}
, f_inner_voids_<<name>>
{% endif %}
{% if cond.cable.material_outer_voids != 'helium' %}
,  f_outer_voids_<<name>>
{% endif %}
};
{% endfor %}

  // heat capacity of bare part
{% for name, cond in dm.conductors.items() %}
  {% if cond.strand.material_superconductor == 'Nb-Ti' %}
  heatCap[<<nc.omega>><<nc.powered>>_<<name>>] = RuleOfMixtures[
    <<materials[specificHeatCapacityMacroName[cond.strand.material_stabilizer]]()>>,
    <<materials[specificHeatCapacityMacroName[cond.strand.material_superconductor]](C1=cond.Jc_fit.C1_CUDI1, C2=cond.Jc_fit.C2_CUDI1, current=dm.power_supply.I_initial)>>, 
    <<materials[specificHeatCapacityMacroName[cond.cable.material_inner_voids]]()>>,
    <<materials[specificHeatCapacityMacroName[cond.cable.material_outer_voids]]()>>
  ]
  {
    f_stabilizer_<<name>>,
    f_sc_<<name>>,
    f_inner_voids_<<name>>,
    f_outer_voids_<<name>>
  };
{% else %}
  heatCap[<<nc.omega>><<nc.powered>>_<<name>>_TH] = RuleOfMixtures[
    <<materials[specificHeatCapacityMacroName[cond.strand.material_stabilizer]]()>>,
    <<materials[specificHeatCapacityMacroName[cond.strand.material_superconductor]]()>>,
    <<materials[specificHeatCapacityMacroName[cond.cable.material_inner_voids]]()>>,
    <<materials[specificHeatCapacityMacroName[cond.cable.material_outer_voids]]()>>
  ]
  {
    f_stabilizer_<<name>>, 
    f_sc_<<name>>,
    f_inner_voids_<<name>>, 
    f_outer_voids_<<name>>
  };
  {% endif %}
{% endfor %}

  // joule losses of bare part
  jouleLosses[<<nc.omega>><<nc.powered>>] = CFUN_quenchState_Ic[criticalCurrentDensity[$1] * SurfaceArea[]]{source_current} * rho[$1] * SquNorm[source_current/SurfaceArea[]];

  jouleLosses[<<nc.omega>><<nc.insulator>>] = 0;

  // joule losses of quench heaters
  {% set qh_dict = dm.quench_protection.quench_heaters %}
  {% for qh_index, name in enumerate(rm.conducting.names) %}
    {% set l_SS = qh_dict.l_stainless_steel[qh_index] / (qh_dict.l_copper[qh_index] + qh_dict.l_stainless_steel[qh_index]) * qh_dict.l[qh_index] %}
    jouleLosses[<<name>>] = <<materials['MATERIAL_QuenchHeater_SSteel_t_T'](t_on=qh_dict.t_trigger[qh_index], U_0=qh_dict.U0[qh_index], C=qh_dict.C[qh_index], R_warm=qh_dict.R_warm[qh_index], w_SS=qh_dict.w[qh_index], h_SS=qh_dict.h[qh_index], l_SS=l_SS, mode=1)>>;
    qh_current[<<name>>] = <<materials['MATERIAL_QuenchHeater_SSteel_t_T'](t_on=qh_dict.t_trigger[qh_index], U_0=qh_dict.U0[qh_index], C=qh_dict.C[qh_index], R_warm=qh_dict.R_warm[qh_index], w_SS=qh_dict.w[qh_index], h_SS=qh_dict.h[qh_index], l_SS=l_SS, mode=2)>>;
  {% endfor %}

  // thermal conductivity of quench heaters
  kappa[<<nc.omega>><<nc.conducting>>] = <<materials[thermalConductivityMacroName['SS']]()>>;

  // heat capacity of quench heaters
  heatCap[ <<nc.omega>><<nc.conducting>> ] = <<materials[specificHeatCapacityMacroName['SS']]()>>;

  // thermal conductivity and heat capacity of insulation
{% for ins_mat in ins_materials %}
  kappa[<<nc.omega>><<nc.insulator>>_<<ins_mat>>] = <<materials[thermalConductivityMacroName[ins_mat]]()>>;
  heatCap[<<nc.omega>><<nc.insulator>>_<<ins_mat>>] = <<materials[specificHeatCapacityMacroName[ins_mat]]()>>;
{% endfor %}

}

Constraint {
    { Name initTemp ;
      Case {
          {% for nr, names in enumerate(rm.boundaries.temperature.names) %}

          { Region <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.temperature)[nr]>>; Value <<rm.boundaries.temperature['values'][nr][0]>>;  Type Assign; } // boundary condition
          {% endfor %}
        {% if dm.magnet.solve.thermal.solve_type == 'transient' %}
          { Region <<nc.omega>> ; Value <<dm.magnet.solve.thermal.init_temperature>> ; Type Init; } // init. condition
        {% endif %}
      }
    }
}

Integration { // integration schemes with numbers of integration points
  { Name Int ;
    Case {
      { Type Gauss ;
        Case {
          { GeoElement Line       ; NumberOfPoints  2 ; }
          { GeoElement Triangle   ; NumberOfPoints  3 ; }
          { GeoElement Quadrangle   ; NumberOfPoints  4 ; }
        }
      }
    }
  }
}

Jacobian { // Jacobian for the mapping from physical to reference element
  { Name Vol ;
    Case {
      { Region All ; Jacobian Vol ; }
    }
  }
  { Name Sur ;
    Case {
      { Region All ; Jacobian Sur ; }
    }
  }
}

FunctionSpace {
  { Name Hgrad_T; Type Form0;
    BasisFunction {
      { Name un;  NameOfCoef ui;  Function BF_Node;
          Support Region[{<<nc.omega>>, Bnds_support}] ; Entity NodesOf[All];
      }
  }

    Constraint {
      { NameOfCoef ui; EntityType NodesOf; NameOfConstraint initTemp; }
      // do not constraint second order basis function as it's already covered by ui
    }
  }
}

Formulation {

  { Name Thermal_T;   Type FemEquation;
    Quantity {
      // cont temperature
      { Name T; Type Local; NameOfSpace Hgrad_T; }
    }

    Equation {
      Integral { [ kappa[{T}] * Dof{d T} , {d T} ] ;
        In <<nc.omega>>; Integration Int ; Jacobian Vol ; }

      Integral { DtDof[ heatCap[{T}] * Dof{T}, {T} ];
        In <<nc.omega>>; Integration Int; Jacobian Vol;  }

      Integral { [ - jouleLosses[{T}], {T}];
        In <<nc.omega>>; Integration Int; Jacobian Vol;  }

        // non-homogeneous Neumann --> imposed heat flux
        {% for nr, value in enumerate(rm.boundaries.heat_flux['values']) %}
          Integral { [- <<value[0]>> , {T} ] ;
            In {% if dm.magnet.solve.thermal.He_cooling.sides != 'external' and nr == 0 %} general_adiabatic {% else %} <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.heat_flux)[nr - 1 if dm.magnet.solve.thermal.He_cooling.sides != 'external' else nr]>> {% endif %}; Integration Int ; Jacobian Sur ; }
        {% endfor %}

          // Robin
          // n * kappa grad (T) = h (T - Tinf) becomes two terms since GetDP can only
          // handle linear and not affine terms
          // NOTE: signs might be switched
        {% for nr, values in enumerate(rm.boundaries.cooling['values']) %}
          Integral { [<<values[0]>> * Dof{T}, {T} ] ;
            In {% if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' and nr == 0 %} general_cooling {% else %} <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.cooling)[nr - 1 if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' else nr]>> {% endif %}; Integration Int ; Jacobian Sur ; }
          Integral { [-<<values[0]>> * <<values[1]>> , {T} ] ;
            In {% if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' and nr == 0 %} general_cooling {% else %} <<list(dm.magnet.solve.thermal.overwrite_boundary_conditions.cooling)[nr - 1 if dm.magnet.solve.thermal.He_cooling.sides != 'adiabatic' else nr]>> {% endif %}; Integration Int ; Jacobian Sur ; }
        {% endfor %}

    }
  }
}

Resolution {
  { Name Thermal_T ;
    System {
      { Name Sys_The ; NameOfFormulation Thermal_T ;
      }
    }
    Operation {
      SetExtrapolationOrder[0];

      //PostOperation[resetMaxTemp]; // clear maximum temperature output file

      InitSolution Sys_The; // init. the solution using init. constraints

      //PostOperation[PrintMaxTemp]; // get maximum temperature (= init. temp)
        
        TimeLoopAdaptive
        [ <<dm.magnet.solve.thermal.time_stepping.initial_time>>, <<dm.magnet.solve.thermal.time_stepping.final_time>>, <<dm.magnet.solve.thermal.time_stepping.initial_time_step>>, <<dm.magnet.solve.thermal.time_stepping.min_time_step>>, <<dm.magnet.solve.thermal.time_stepping.max_time_step>>, "<<dm.magnet.solve.thermal.time_stepping.integration_method>>", List[Breakpoints],
        System { { Sys_The, <<dm.magnet.solve.thermal.time_stepping.rel_tol_time>>, <<dm.magnet.solve.thermal.time_stepping.abs_tol_time>>, <<dm.magnet.solve.thermal.time_stepping.norm_type>> } } ]
        {
          IterativeLoopN[<<dm.magnet.solve.thermal.non_linear_solver.max_iterations>>, <<dm.magnet.solve.thermal.non_linear_solver.relaxation_factor>>,
            System { { Sys_The, <<dm.magnet.solve.thermal.non_linear_solver.rel_tolerance>>, <<dm.magnet.solve.thermal.non_linear_solver.abs_tolerance>>, Solution <<dm.magnet.solve.thermal.non_linear_solver.norm_type>> } }]
          {
             GenerateJac Sys_The ; SolveJac Sys_The;
             {% if dm.magnet.solve.thermal.enforce_init_temperature_as_minimum %}
             SolutionSetMin[Sys_The, <<dm.magnet.solve.thermal.init_temperature>>];
             {% endif %}
          }
        }
        {
          SaveSolution[Sys_The];
          {% raw %}
            Test[$Breakpoint > 0] {
              PostOperation[PrintMaxTemp]; // get maximum temperature (= init. temp)
              Print[{#1}, Format "Max temperature is %g "];
              Test[#1 > stop_temperature] {
                Break[];
              }
            }
          {% endraw %}
        }

      PostOperation[T_avg];
      SaveSolution Sys_The ;
    }
  }
}

PostProcessing {
    { Name Thermal_T ; NameOfFormulation Thermal_T ;
      PostQuantity {
        { Name dummyQuantity ; Value {
        }
      }

        // Temperature
        { Name T ; Value {
            Term { [ {T} ] ;
              In <<nc.omega>> ; Jacobian Vol ; }
          }
        }

        // Temperature
        { Name T_avg ; Value {
            Integral {  [ {T} / SurfaceArea[] ] ;
              In <<nc.omega>><<nc.powered>> ; Jacobian Vol ; Integration Int; }
          }
        }

        // QH power
        { Name qh_power ; Value {
            Integral {  [ jouleLosses[{T}] * <<qh_dict.h[0]>> / SurfaceArea[] ] ;
              In <<nc.omega>><<nc.conducting>> ; Jacobian Vol ; Integration Int; }
          }
        }

        // QH current
        { Name qh_current ; Value {
            Integral {  [ - qh_current[{T}] / SurfaceArea[]] ;
              In <<nc.omega>><<nc.conducting>> ; Jacobian Vol ; Integration Int; }
          }
        }

        // Heat flux
        { Name flux ; Value {
            Term { [-kappa[{T}] * {d T} ] ;
              In <<nc.omega>><<nc.powered>> ; Jacobian Vol ; }
          }
        }

        { Name quenchState_post ; Value {
          Term { [ CFUN_quenchState_Ic[criticalCurrentDensity[{T}] * SurfaceArea[]]{source_current} ] ;
            In <<nc.omega>><<nc.powered>> ; Jacobian Vol ; }
        }
      }

      { Name jouleLosses ; Value {
        Term { [ jouleLosses[{T}] ] ;
          In <<nc.omega>> ; Jacobian Vol ; }
      }
    }

       // Maximum temperature in bare part from register 1
       { Name Tmax; Value{  Term{ Type Global; [#1]; In <<nc.omega>><<nc.powered>>;
         Jacobian Vol;} } }
      }
    }
}

PostOperation PrintMaxTemp UsingPost Thermal_T {
  // Get maximum in bare region and store in register 1
  Print[ T, OnElementsOf <<nc.omega>><<nc.powered>>, StoreMaxInRegister 1, Format Table,
    LastTimeStepOnly 1, File "dummy.txt", SendToServer "No"] ;

  // Save maximum temperature in file by appending to existing file
/*  Print[Tmax, OnRegion <<nc.omega>><<nc.powered>>, Format Table,
    File StrCat["Tmax.txt"], LastTimeStepOnly 1, AppendToExistingFile 1, SendToServer "No"];*/
}

// Clean the file saving maximum temperatures
/*PostOperation resetMaxTemp UsingPost Thermal_T {
  Echo["", Format Table, File StrCat["Tmax.txt"] ];
}*/

PostOperation {
{
    Name Map_T; NameOfPostProcessing Thermal_T;
    // Adaptive time stepping: this allows to resample time afterwards
    {% if dm.magnet.postproc.thermal.output_time_steps_pos > 1 %}
    {% set resample_step = (dm.magnet.solve.thermal.time_stepping.final_time - dm.magnet.solve.thermal.time_stepping.initial_time)/dm.magnet.postproc.thermal.output_time_steps_pos %}
    {% set last_time_step_only = 0 %}
    ResampleTime[<<dm.magnet.solve.thermal.time_stepping.initial_time>>, <<dm.magnet.solve.thermal.time_stepping.final_time>>, <<resample_step>>];
    {% elif (dm.magnet.postproc.thermal.output_time_steps_pos == 1 and not dm.magnet.postproc.thermal.save_pos_at_the_end) %}
      {% set last_time_step_only = 1 %}
    {% else %}
      {% set last_time_step_only = 0 %}
    {% endif %}
    Operation {
    //Print[ flux, OnElementsOf <<nc.omega>><<nc.powered>>, File "flux.pos", AppendToExistingFile 1, LastTimeStepOnly 1, SendToServer "No"  ] ;

//Print[ kappa, OnElementsOf <<nc.omega>><<nc.powered>>, File "kappa.pos", AppendToExistingFile 1, LastTimeStepOnly 1 ]  ;
//Print[ heatCap, OnElementsOf <<nc.omega>><<nc.powered>>, File "heatCap.pos", AppendToExistingFile 1, LastTimeStepOnly 1 ]  ;

    Print[ T, OnElementsOf <<nc.omega>>, File "T.pos", SendToServer "No", LastTimeStepOnly <<last_time_step_only>>, AppendToExistingFile <<last_time_step_only>> ]  ;

    //Print[ jouleLosses, OnElementsOf <<nc.omega>><<nc.powered>>, File "jouleLosses.pos", AppendToExistingFile 1, LastTimeStepOnly 1, SendToServer "No" ]  ;

    //Print[ quenchState_post, OnElementsOf <<nc.omega>><<nc.powered>>, File "quenchState.pos", AppendToExistingFile 1, LastTimeStepOnly 1, SendToServer "No" ] ;

    }
  }

  {
    Name T_avg; NameOfPostProcessing Thermal_T;
    {% if dm.magnet.postproc.thermal.output_time_steps_txt > 1 %}
    {% set resample_step = (dm.magnet.solve.thermal.time_stepping.final_time - dm.magnet.solve.thermal.time_stepping.initial_time)/dm.magnet.postproc.thermal.output_time_steps_txt %}
    {% set last_time_step_only = 0 %}
    ResampleTime[<<dm.magnet.solve.thermal.time_stepping.initial_time>>, <<dm.magnet.solve.thermal.time_stepping.final_time>>, <<resample_step>>];
    {% elif (dm.magnet.postproc.thermal.output_time_steps_txt == 1 and not dm.magnet.postproc.thermal.save_txt_at_the_end) %}
      {% set last_time_step_only = 1 %}
    {% else %}
      {% set last_time_step_only = 0 %}
    {% endif %}
    Operation {
    // writes pairs of time step and average temperature to file, one line for each time step
    {% for idx, half_turn in enumerate(rm.powered.numbers) %}
      Print[ T_avg[Region[<<half_turn>>]], OnGlobal, File "T_avg_<<idx>>.txt", Format Table, AppendToExistingFile 1, LastTimeStepOnly <<last_time_step_only>>, AppendToExistingFile <<last_time_step_only>>] ;
    {% endfor %}
    }
  }
}
