import os
import shutil

import pandas as pd
from steam_sdk.analyses.AnalysisSTEAM import AnalysisSTEAM

if __name__ == "__main__":

    # input parameters
    sweep_file_name = 'MBH_1in1_TSA' # 'MBH_1in1_TSA' #'MBH_1in1_TSA_tQH'
    magnet_name = 'MBH_1in1' # 'MBH_1in1' # 'MBH_1in1_tQH'

    # initialize analysis object
    a = AnalysisSTEAM(file_name_analysis='input/FiQuS.yaml', verbose=True)

    # make local FiQuS folder if it does not exist
    os.makedirs(a.settings.local_FiQuS_folder, exist_ok=True)

    # change specific options in analysis depending on magnet
    sweep_file_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'input', f'{sweep_file_name}.csv')
    magnet_csv_path = os.path.join('output_thesis', f'{sweep_file_name}_{magnet_name}.csv')

    for name, step in a.data_analysis.AnalysisStepDefinition.items():
        if step.type in ['ModifyModel', 'ModifyModelMultipleVariables']:
            step.simulation_name = magnet_name
        elif step.type in ['MakeModel']:
            step.file_model_data = magnet_name
        elif step.type in ['ParametricSweep']:
            step.input_sweep_file = shutil.copy(sweep_file_path, magnet_csv_path)

    sweep_df = pd.read_csv(magnet_csv_path)

    # Overwrite magnet-specific geom file path
    sweep_df['Options_FiQuS.multipole.geometry.geom_file_path'] =\
        os.path.join(os.path.dirname(os.path.abspath(__file__)), 'output_thesis', magnet_name, f'{magnet_name}_pre_process_sweep_FiQuS.geom')

    sweep_df.to_csv(magnet_csv_path, index=False)

    a.run_analysis()