import gmsh

gmsh.initialize()
gmsh.model.add("extend_line")
gmsh.model.occ.importShapes("D:/cernbox/Repositories/fiqus-multipole-thermal-tsa-verification/output_thesis/SMC/Geometry_TSA/SMC_TH.brep", highestDimOnly=False)
gmsh.model.occ.synchronize()

lines = [[727, 728, 729, 730, 731], [625, 626, 627, 628, 629, 630, 631, 632], [280], [282]]
lines_thickness = [0.0008, 0.0003, 0.00015, 0.00015]
only_positive_direction = [False, False, True, False]
only_negative_direction = [False, False, False, True]

tsa_surs = []


for idx, (line_list, thickness) in enumerate(zip(lines, lines_thickness)):
    for line in line_list:
        normalVec = gmsh.model.getDerivative(dim=1, tag=line, parametricCoord=[0.5]) * thickness/2

        if not only_positive_direction[idx]:
            tsa_surs.extend(gmsh.model.occ.extrude([(1, line)], normalVec[1], -normalVec[0], 0))

        if not only_negative_direction[idx]:
            tsa_surs.extend(gmsh.model.occ.extrude([(1, line)], -normalVec[1], normalVec[0], 0))


tsa_surs = [(dim, tag) for dim, tag in tsa_surs if dim == 2]


all_surfaces = gmsh.model.getEntities(dim=2)
all_but_tsa_surfaces = [(dim, tag) for (dim, tag) in all_surfaces if tag not in [tag for (_, tag) in tsa_surs]]

gmsh.model.occ.synchronize()


gmsh.model.addPhysicalGroup(2, [tag for (_, tag) in all_but_tsa_surfaces], 1, "all_but_tsa_without_overlap")
gmsh.model.addPhysicalGroup(2, [tag for (_, tag) in tsa_surs], 2, "tsa_surs")

gmsh.model.mesh.generate(2)
gmsh.open("D:/cernbox/Repositories/fiqus-multipole-thermal-tsa-verification/output_thesis/SMC/Geometry_REF/SMC_TH.brep")
gmsh.model.mesh.generate(2)


gmsh.fltk.run()

