import gmsh

gmsh.initialize()
gmsh.model.add("extend_line")
gmsh.model.occ.importShapes("D:/cernbox/Repositories/fiqus-multipole-thermal-tsa-verification/output_thesis/MBH_1in1/Geometry_TSA/MBH_1in1_TH.brep", highestDimOnly=False)
gmsh.model.occ.synchronize()

lines = [[1225, 1226, 1227, 1228, 1229], [1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326], [1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211], [1376, 977, 976, 1372, 1371, 975, 974, 973, 972, 971, 970, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1380]]
lines_thickness = [0.00077374, 0.00087001, 0.00064281, 0.0002]

interlayer_tsa_surs = []
interturn_tsa_surs = []

for idx, (line_list, thickness) in enumerate(zip(lines, lines_thickness)):
    for line in line_list:
        normalVec = gmsh.model.getDerivative(dim=1, tag=line, parametricCoord=[0.5]) * thickness/2

        if idx < 3:
            interlayer_tsa_surs.extend(gmsh.model.occ.extrude([(1, line)], normalVec[1], -normalVec[0], 0))
            interlayer_tsa_surs.extend(gmsh.model.occ.extrude([(1, line)], -normalVec[1], normalVec[0], 0))
        else:
            interturn_tsa_surs.extend(gmsh.model.occ.extrude([(1, line)], normalVec[1], -normalVec[0], 0))
            interturn_tsa_surs.extend(gmsh.model.occ.extrude([(1, line)], -normalVec[1], normalVec[0], 0))

interlayer_tsa_surs = [(dim, tag) for dim, tag in interlayer_tsa_surs if dim == 2]

gmsh.model.occ.synchronize()

all_surfaces = gmsh.model.getEntities(dim=2)


all_but_tsa_surfaces = [(dim, tag) for (dim, tag) in all_surfaces if tag not in [tag for (_, tag) in interlayer_tsa_surs + interturn_tsa_surs]]

tsa_without_overlap = gmsh.model.occ.cut(interlayer_tsa_surs, all_but_tsa_surfaces, removeObject=False, removeTool=False)[0]
overlap_surface = gmsh.model.occ.intersect(interlayer_tsa_surs, all_but_tsa_surfaces, removeObject=False, removeTool=False)[0]
all_but_tsa_without_overlap = gmsh.model.occ.cut(all_but_tsa_surfaces, interlayer_tsa_surs, removeObject=False, removeTool=False)[0]

gmsh.model.occ.synchronize()


gmsh.model.addPhysicalGroup(2, [tag for (_, tag) in all_but_tsa_without_overlap], 1, "all_but_tsa_without_overlap")
gmsh.model.addPhysicalGroup(2, [tag for (_, tag) in tsa_without_overlap + interturn_tsa_surs], 2, "tsa_without_overlap")
gmsh.model.addPhysicalGroup(2, [tag for (_, tag) in overlap_surface], 3, "overlap_surface")


gmsh.option.setNumber("Mesh.MeshSizeMax", 0.001)

gmsh.model.mesh.generate(2)

# TODO: open brep for lines
# TODO: TSA also lines between turns.. 

gmsh.open("D:/cernbox/Repositories/fiqus-multipole-thermal-tsa-verification/output_thesis/MBH_1in1/Geometry_REF/MBH_1in1_TH.brep")

gmsh.fltk.run()

