import matplotlib.pyplot as plt
import numpy as np


# data from https://ieeexplore.ieee.org/document/7422690
# S. Izquierdo Bermudez et al., "Quench Protection Studies of the 11-T Nb3Sn Dipole for the LHC Upgrade," 
# in IEEE Transactions on Applied Superconductivity, vol. 26, no. 4, pp. 1-5, June 2016,
# Art no. 4701605, doi: 10.1109/TASC.2016.2536653
# Figure 4: measurements for coil 106 and 109
coil_106_I = np.array([6000, 8000, 9000, 10000])
coil_106_t = np.array([21.8e-3, 17.6e-3, 15.3e-3, 14.26e-3])

coil_109_I = np.array([6000, 8000, 10000, 11850])
coil_109_t = np.array([19e-3, 17e-3, 12.96e-3, 9.93e-3])

fiqus_I_old = np.array([6000, 7000, 8000, 9000, 10000, 11000, 12000])
fiqus_t_old = np.array([0.02115, 0.01925, 0.01735, 0.0155, 0.0138, 0.0123, 0.01095 ])

fiqus_I = np.array([6000, 7000, 8000, 9000, 10000, 11000, 12000])
fiqus_t = np.array([0.0201, 0.01825, 0.0164, 0.0146, 0.013, 0.01165, 0.0103 ])

fiqus_I_stycast = np.array([6000, 7000, 8000, 9000, 10000, 11000, 12000])
fiqus_t_stycast = np.array([0.02045, 0.0186, 0.01667, 0.0149,  0.01333, 0.0119, 0.0105])

izquierda_I = np.array([6000, 7000, 8000, 9000, 10000, 11000, 12000])
izquierda_t = np.array([24.25E-3, 21.98E-3, 20.17E-3, 18.30E-3, 16.70E-3, 15.23E-3, 13.82E-3])

n = 4
colors = plt.cm.viridis(np.linspace(0,1,n))

plt.plot(coil_106_I/1E3, coil_106_t * 1E3, label="Coil 106", linestyle="None", marker="o", color=colors[0])
plt.plot(coil_109_I/1E3, coil_109_t * 1E3, label="Coil 109", linestyle="None", marker="x", color=colors[1])
plt.plot(fiqus_I_old/1E3, fiqus_t_old * 1E3, label="FiQuS 55 mum", linestyle="--", color="black", marker="v")

plt.plot(fiqus_I/1E3, fiqus_t * 1E3, label="FiQuS 50 mum", linestyle="-", color=colors[2], marker="^")
plt.plot(fiqus_I_stycast/1E3, fiqus_t_stycast * 1E3, label="FiQuS 50 mum, 15 mum Stycast", linestyle="-", marker='s',color=colors[3])
# plt.plot(izquierda_I/1E3, izquierda_t * 1E3, label="Izquierda", linestyle="-")

plt.xlabel('Operating current in kA')
plt.ylabel('Quench heater delay in ms')
plt.tick_params(axis='x')
plt.tick_params(axis='y')
plt.legend()
plt.show()