
import os
import numpy as np
import matplotlib.pyplot as plt
from steammaterials.STEAM_materials import STEAM_materials

B = 3   
Tc0_Summers = 16.33
Bc20_Summers = 26.45
Jc0_Summers = 42240000000.0

T_arr = np.linspace(0, 17, 1000)
B_arr = np.ones(T_arr.shape) * B
Jc0arr = np.ones(T_arr.shape) * Jc0_Summers
Tc0arr = np.ones(T_arr.shape) * Tc0_Summers
Bc20arr = np.ones(T_arr.shape) * Bc20_Summers

B_T_plot_array = np.vstack((T_arr, B_arr, Jc0arr, Tc0arr, Bc20arr))

fct_name = "CFUN_Jc_Nb3Sn_Summers_v1"
jc = STEAM_materials(fct_name, B_T_plot_array.shape[0], B_T_plot_array.shape[1]).evaluate(B_T_plot_array) + 1e-10

# Plots the results
plt.figure()
plt.semilogy(T_arr, jc)
plt.xlabel('Temperature [K]')
plt.ylabel('Jc [A/m^2]')
plt.show()
