import os
import numpy as np
import matplotlib.pyplot as plt

# Material properties
from steammaterials.STEAM_materials import STEAM_materials


T_arr = np.linspace(0, 300, 1000)
fct_name = "CFUN_rhoSS_v1"
rho_obj = STEAM_materials(fct_name, 1, len(T_arr)).evaluate(T_arr)

T_eval = 1.9
w_SS = 0.024 # 0.019
h_SS= 2.5e-05
l_SS_input = 0.05
l_Cu = 0.13 # 0.09
l_tot = 1.7
U_0 = 450
R_warm = 2.596 # 2.344

l_SS = l_SS_input / (l_Cu + l_SS_input) * l_tot


rho_SS = STEAM_materials(fct_name, 1, 1).evaluate(np.array([T_eval]))


S_SS = (w_SS * h_SS)
R_SS    = rho_SS * l_SS / S_SS
		  
i_0  = - U_0 / (R_warm + R_SS)

print(f"I_0 at {T_eval} K for U_0 = {U_0} V: {i_0} A")

# Plots the results
plt.figure()
plt.plot(T_arr, rho_obj)
plt.xlabel('Temperature [K]')
plt.ylabel('Resistivity [Ohm*m]')
plt.show()
