import os
import gmsh


time = '0.066064s'
magnet = "SMC"

ref_model_path = os.path.join(os.getcwd(), 'output_thesis', magnet, 'rel_error_space', time, 'ref_model.pos')
sur_model_path = os.path.join(os.getcwd(), 'output_thesis', magnet, 'rel_error_space', time, 'sur_model.pos')
TSA_model_path = os.path.join(os.getcwd(), 'output_thesis', magnet, 'rel_error_space', time, 'TSA_model.pos')

gmsh.initialize()

gmsh.open(ref_model_path)
gmsh.open(sur_model_path)
gmsh.open(TSA_model_path)

gmsh.plugin.setString("MathEval", "Expression0", "Abs(v0 - w0)/v0")
gmsh.plugin.setNumber("MathEval", "View", 0)
gmsh.plugin.setNumber("MathEval", "OtherView", 1)

gmsh.plugin.run("MathEval")


gmsh.plugin.setString("MathEval", "Expression0", "Abs(v0 - w0)/v0")
gmsh.plugin.setNumber("MathEval", "View", 0)
gmsh.plugin.setNumber("MathEval", "OtherView", 2)

gmsh.plugin.run("MathEval")

gmsh.view.write(4, os.path.join(os.getcwd(), 'output_thesis', magnet, 'rel_error_space', time, f"rel_error_sur_{time}.pos"))
gmsh.view.write(5, os.path.join(os.getcwd(), 'output_thesis', magnet, 'rel_error_space', time, f"rel_error_TSA_{time}.pos"))

gmsh.fltk.run()

gmsh.finalize()