import numpy as np
import matplotlib.pyplot as plt

# Material properties
from steammaterials.STEAM_materials import STEAM_materials


T_arr = np.linspace(0, 300, 1000)
fct_name = "CFUN_kSteel_v1"
k_steel = STEAM_materials(fct_name, 1, len(T_arr)).evaluate(T_arr)

# Plots the results
plt.figure()
plt.plot(T_arr, k_steel)

plt.xlabel('Temperature [K]')
plt.ylabel('Thermal Conductivity [W/(mK)]')
plt.show()
