# FiQuS Multipole Thermal TSA Verification

This repository collects the input files to reproduce the simulations of chapter 5 "Transient Simulation of Superconducting Accelerator Magnets Using Thermal TSA" in E. Schnaubelt, "Models and Methods for Transient Magneto-Thermal Finite Element Simulation of Superconducting Magnets", Ph.D. thesis, Technische Universität Darmstadt, 2025.

The repository is also available on [Zenodo](https://doi.org/10.5281/zenodo.14993690) for long-term storage.

## Getting Started

1. Install [Python 3.11.8](https://www.python.org/downloads/release/python-3118/).
2. Download the `steam_models 2025.1.0` release from [here](https://gitlab.cern.ch/steam/steam_models/-/archive/2025.1.0/steam_models-2025.1.0.zip) and extract it to your favorite location.
3. Download the CERNGetDP 2025.2.1 release from [here](https://gitlab.cern.ch/steam/cerngetdp/-/releases/2025.2.1) and extract it to your favorite location.
4. If you haven't done already, clone this repository by running the code below in a terminal
    ```bash
    git clone ssh://git@gitlab.cern.ch:7999/steam/analyses/fiqus-multipole-thermal-tsa-verification.git
    ```
    or download it as a zip from [here](https://gitlab.cern.ch/steam/analyses/fiqus-multipole-thermal-tsa-verification.git).
5. Update `GetDP_path` in the `input/FiQuS.yaml` file to point the path to the GetDP executable downloaded in step 3. It should look something like this:
    ```yaml
    GetDP_path: C:\some\path\to\getdp\getdp_2025.2.1.exe # Windows
    # OR
    GetDP_path: /some/path/to/getdp/getdp_2025.2.1 # Linux
    # OR
    GetDP_path: getdp # If GetDP is in the $PATH with alias getdp	
    ```
6. Update `local_library_path` in the `input/FiQuS.yaml` file to point to the root of the `steam_models` library downloaded in step 2. It should look something like this:
    ```yaml
    local_library_path: C:\some\path\to\steam_models # Windows
    # OR
    local_library_path: /some/path/to/steam_models # Linux
    ```
7.  Install `FiQuS 2025.2.0` and `steam-sdk 2025.1.1` by running one of the codes below in a terminal
    ```bash
    pip install fiqus==2025.2.0
    pip install steam-sdk==2025.1.1
    ```
    or
    ```
    pip install -r requirements.txt
    ```
    Consider activating a [virtual environment](https://docs.python.org/3/library/venv.html) before to avoid conflicts with other Python packages.
8. Follow the instructions below to run the 4-cable, MBH, and other LHC and HL-LHC magnet models.

## 4-cable model

To recreate the results for the four cable model, first run the script `run_simple_thermal_model.py` to generate the results, e.g.,
```bash
python run_simple_thermal_model.py
```
This script has some default settings that can be changed on the top. In particular, the different insulation mesh sizes are defined and the number of different parallel processes. It could be that you don't have enough RAM to run many processes in parallel, which could lead to errors. In that case, reduce the number of parallel processes prescribed by the variable `max_parallel_processes`.

Furthermore, the tolerances are very tight in order to show that small errors can be achieved for the simple model; this will lead to long run times. If you want to run the model with less tight tolerances, you can change the tolerances in the input file in `input/simple_thermal_model/simple_thermal_model.yaml`. Last, you could consider removing the finest `target_size_insulation` entries which will lead to a quicker overall run time.

After generating the results, they can be visualized by running the script `plot_simple_thermal_model.py`, e.g.,
```bash
python plot_simple_thermal_model.py
```

## LHC and HL-LHC models

The results for the LHC and HL-LHC models can be generated by running the script `run_multipole_analysis.py`, e.g.,
```bash
python run_multipole_analysis.py
```
On the top, the settings for the analysis can be changed. In particular, `sweep_file_name` designates the name of the `.csv` file in the `input` folder that contains the magnet settings. ``magnet_name`` designates the name of the magnet model. The script will run the analysis for all the settings in the `.csv` file and save the results in the `output` folder.

Available `magnet_names` are `MBH_1in1`, `MB_2COILS`, `MQXA`, `MQXF_V2`, and `SMC`.

After generating the results, they can be visualized by running the script `plot_multipole_analysis.py`, e.g.,
```bash
python plot_multipole_analysis.py
```