# Nuclei Segmentation over Synthetic DAPI images with 2D StarDist

## Overview
The StarDist model is specialized in performing nuclei segmentation on synthetic Lifeact-RFP images, which were initially generated from sir-DNA images using the Pix2Pix model. This model is an integral part of a pipeline that begins with image generation via Pix2Pix, followed by nuclei segmentation using StarDist.

StarDist has been fine-tuned using the ZeroCostDL4Mic notebook, with a specific training dataset sourced from Zenodo.

- Fine-Tuning Notebook: [StarDist ZeroCostDL4Mic Notebook](https://colab.research.google.com/github/HenriquesLab/ZeroCostDL4Mic/blob/master/Colab_notebooks/StarDist_2D_ZeroCostDL4Mic.ipynb)
- Training Dataset: [Zenodo Dataset](https://zenodo.org/record/3715492#.XnMhuXUzY5l)

This model is pivotal in processing and analyzing synthetic images, thereby forming a crucial part of the image analysis pipeline.

## Training and Application
After training, the StarDist model is employed for segmenting nuclei in synthetic Lifeact-RFP images, which were created from sir-DNA images.

## Citation
Cite this model as:
Schmidt, U., Weigert, M., Broaddus, C., & Myers, G. (2018). Cell detection with star-convex polygons. In Medical Image Computing and Computer Assisted Intervention–MICCAI 2018: 21st International Conference, Granada, Spain, September 16-20, 2018, Proceedings, Part II 11 (pp. 265-273). Springer International Publishing.
