function[c,ceq] = uniEqConstraint(x)

    % This function corresponds to the constraint given in footnote 31 & 33;

    if length(x) == 2

        c0  = x(1);
        c1  = x(2);
        c   = -(c0 + c1 * 0.1);
        ceq = [];

    else
        
        c0      = x(1);
        c1      = x(2);
        rho     = x(3);
        sigma   = x(4);
        gamma   = 1;

        c(1)    = gamma^2 / (8 * pi) * (1 + rho) / (1 - rho) - sigma^2;
        c(2)    = -(c0 + c1 * 0.1);
        ceq     = [];
    end

end