function [Ustar,flag] = solveEq_JO(para, X)

   % This function solves the equilibrium for Big and joint-owned S & M firms
 
   % External parameters
    n           = size(X,1);
    N           = size(X,2);
    c0          = para.c0;
    c1          = para.c1;
    rho         = para.rho;
    delta       = -1/(N-1);
    sigma       = para.sigma;

    u0          = zeros(n,N);
    v_star      = zeros(n,N);

    options = optimset('Display','off','TolFun',1e-18);           
         
            % initial threshold for each firm
            % big 
            u0(:,1) = - c0 - (c1+ (N-1)*delta).*X(:,1) - ((sum(X,2)-X(:,1)).*delta);              
            % medium
            u0(:,2) = - c0 - (c1+delta).*X(:,2)- X(:,1).*delta;
            % small
            u0(:,3) = -2*c0 - (c1+ (N-1)*delta).*(X(:,2)+X(:,3)) -X(:,1).*(N-1).*delta;

            u_star=u0;            
            TTT=1;
            iter = 0;
            maxIter = 100;
            while TTT > 0.00001 && iter<maxIter
                iter = iter+1;
                
                    % conditional response prob. for each firm
                    sigmaj12 =(1 - normcdf((u_star(:,2).*sigma - rho*u_star(:, 1).*sigma)./sigma./sigma./sqrt(1-rho^2)));
                    sigmaj13 =(1 - normcdf((u_star(:,3).*sigma - rho*u_star(:, 1).*sigma)./sigma./sigma./sqrt(1-rho^2)));
           
                    sigmaj2 = (1 - normcdf((u_star(:,1).*sigma - rho*u_star(:, 2).*sigma)./sigma./sigma./sqrt(1-rho^2)));
                    sigmaj3 = (1 - normcdf((u_star(:,1).*sigma - rho*u_star(:, 3).*sigma)./sigma./sigma./sqrt(1-rho^2)));
                    pB0 = -1/delta./X(:,1).*(c0 + delta.*X(:,2)+(c1+ (N-1)*delta).*X(:, 3));
                    %pB0 = max(0,min(1, pB0));

                    % response threshold function for big and medium firm
                    if c1 + delta>0
                        v_star(:,1) =- c0 - (c1+ (N-1)*delta).*X(:, 1) - delta.*sum(X(:,2:3).*[sigmaj12 sigmaj13],2);
                        v_star(:,2) =- c0 - (c1+delta).*X(:, 2) - delta.*(X(:,1).*sigmaj2);              
                    else
                        v_star(:,1) =- c0 - (c1+ (N-1)*delta).*X(:, 1) - delta.*sum(X(:,2:3).*[sigmaj13 sigmaj12],2);
                        v_star(:,2) =- c0 - (c1+delta).*X(:, 3) - delta.*(X(:,1).*sigmaj2);              
           
                    end 

                    % adjust for small firm's threshold based on pB0
                    for g = 1:n
                        if sigmaj2(g) < pB0(g)
                            v_star(g,1) =- c0 - (c1+ (N-1)*delta).*X(g, 1) - delta.*sum(X(g,2:3).*[sigmaj12(g) sigmaj13(g)],2);
                            v_star(g,2) =- c0 - (c1+delta).*X(g, 2) - delta.*(X(g,1).*sigmaj2(g));              
                            v_star(g,3) = -2*c0- (c1+ (N-1)*delta).*(X(g,2)+X(g,3)) - (N-1).*delta.*(X(g,1).*sigmaj3(g));
                        else 
                            v_star(g,1) =- c0 - (c1+ (N-1)*delta).*X(g, 1) - delta.*X(g,2).*sigmaj12(g);
                            v_star(g,2) =- c0 - (c1+delta).*X(g, 2) - delta.*(X(g,1).*sigmaj2(g));              
                            v_star(g,3) = 10;
                        end
                    end

                TTT = norm(u_star - v_star);
                u_star=v_star; 
            end

            if TTT>0.00001
                disp('could not solve the eq.')
                flag = 0;
            else
                flag = 1;
            end

        Ustar = u_star;

end