function [Ustar] = solveEqNoInter(para, X)

   % External parameters 

    n           = size(X,1);
    N           = size(X,2);
    beta0       = para.beta0;
    beta1       = para.beta1;
    delta       = zeros(N,1); % no strategic interaction
    rho         = para.rho;
    sigma       = para.sigma;

    u0    = zeros(n,N);
    v_star= zeros(n,N);

    options = optimset('Display','off','TolFun',1e-18);           
            for i = 1: N
                u0(:,i) = - beta0(i) - beta1(i)*X(:,i) - ((sum(X,2)-X(:,i)).*delta(i));
            end
            u_star=u0;            
            TTT=1;
            while TTT > 0.00001
                for i = 1: N
                    sigmaj =(1 - normcdf((u_star.*sigma - rho*u_star(:, i).*sigma)./sqrt(1-rho^2)./sigma./sigma));
                    v_star(:,i) =- beta0(i) - beta1(i)*X(:, i) - delta(i).*(sum(X.*sigmaj,2)-X(:,i).*sigmaj(:,i)); 
                end
                                
                TTT = norm(u_star - v_star); 
                u_star=v_star; 
            end

        Ustar = u_star;
end