function[Y,X,epsEQ] = simulateData(para, G, s, Xrand)

%% This function inputs a seed and generates data for n = G games:
%% 1. binary choice variable Y (G by N matrix) 
%% 2. random state variables X (G by N matrix)


%X    = rand(s, [G para.N S]); 
X = Xrand(:, :, s);

% calculate equilibrium probability
[epsEQ] = solveEq(para, X);

% simulate binary choice data
muEps  	= zeros(1, para.N);
covEps 	= para.rho * ones(para.N , para.N);
covEps(logical(eye(para.N))) = 1;
covEps  = covEps .* para.sigma^2;
Eps 	= mvnrnd(muEps,covEps,G);

Y   	= double(Eps >= epsEQ); 
end